/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;

public class WebAppProxyServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(WebAppProxyServer.class);
    private WebAppProxy proxy = null;

    public WebAppProxyServer() {
        super(WebAppProxyServer.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        YarnConfiguration config = new YarnConfiguration(conf);
        try {
            this.doSecureLogin(conf);
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Proxy Server Failed to login", ie);
        }
        this.proxy = new WebAppProxy();
        this.addService(this.proxy);
        super.serviceInit(config);
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        SecurityUtil.login(conf, "yarn.web-proxy.keytab", "yarn.web-proxy.principal");
    }

    private void join() {
        this.proxy.join();
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(WebAppProxyServer.class, args, LOG);
        try {
            WebAppProxyServer proxy = new WebAppProxyServer();
            ShutdownHookManager.get().addShutdownHook(new CompositeService.CompositeServiceShutdownHook(proxy), 30);
            YarnConfiguration conf = new YarnConfiguration();
            proxy.init(conf);
            proxy.start();
            proxy.join();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting Proxy server", t);
            System.exit(-1);
        }
    }
}

