/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class AmFilterInitializer
extends FilterInitializer {
    private static final String FILTER_NAME = "AM_PROXY_FILTER";
    private static final String FILTER_CLASS = AmIpFilter.class.getCanonicalName();

    @Override
    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> params = new HashMap<String, String>();
        String proxy = WebAppUtils.getProxyHostAndPort(conf);
        String[] parts = proxy.split(":");
        params.put("PROXY_HOST", parts[0]);
        params.put("PROXY_URI_BASE", HttpConfig.getSchemePrefix() + proxy + System.getenv("APPLICATION_WEB_PROXY_BASE"));
        container.addFilter(FILTER_NAME, FILTER_CLASS, params);
    }
}

