/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.configuration.listeners;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.wso2.appserver.configuration.listeners.Utils;
import org.wso2.appserver.configuration.server.AppServerSecurity;
import org.wso2.appserver.configuration.server.ApplicationServerConfiguration;
import org.wso2.appserver.exceptions.ApplicationServerException;
import org.wso2.appserver.exceptions.ApplicationServerRuntimeException;
import org.wso2.appserver.utils.PathUtils;

public class ServerConfigurationLoader
implements LifecycleListener {
    private static ApplicationServerConfiguration appServerConfiguration;

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        Object source;
        if ("before_start".equals(lifecycleEvent.getType()) && (source = lifecycleEvent.getSource()) instanceof Server) {
            ServerConfigurationLoader.buildGlobalConfiguration();
        }
    }

    public static ApplicationServerConfiguration getServerConfiguration() {
        return appServerConfiguration;
    }

    private static synchronized void buildGlobalConfiguration() {
        try {
            if (appServerConfiguration == null) {
                Path schemaPath = Paths.get(PathUtils.getAppServerConfigurationBase().toString(), "wso2as.xsd");
                Path descriptorPath = Paths.get(PathUtils.getAppServerConfigurationBase().toString(), "wso2as.xml");
                appServerConfiguration = Utils.getUnmarshalledObject(descriptorPath, schemaPath, ApplicationServerConfiguration.class);
                Optional.ofNullable(appServerConfiguration).ifPresent(ApplicationServerConfiguration::resolveVariables);
                ServerConfigurationLoader.setSecuritySystemProperties();
            }
        }
        catch (ApplicationServerException e) {
            throw new ApplicationServerRuntimeException("An error has occurred when building the global configuration", e);
        }
    }

    private static void setSecuritySystemProperties() {
        Optional.ofNullable(appServerConfiguration).ifPresent(configuration -> {
            AppServerSecurity securityConfiguration = configuration.getSecurityConfiguration();
            System.setProperty("javax.net.ssl.keyStore", securityConfiguration.getKeystore().getLocation().replace("\\", "/"));
            System.setProperty("javax.net.ssl.keyStorePassword", securityConfiguration.getKeystore().getPassword());
            System.setProperty("javax.net.ssl.keyStoreType", securityConfiguration.getKeystore().getType());
            System.setProperty("javax.net.ssl.trustStore", securityConfiguration.getTruststore().getLocation().replace("\\", "/"));
            System.setProperty("javax.net.ssl.trustStorePassword", securityConfiguration.getTruststore().getPassword());
            System.setProperty("javax.net.ssl.trustStoreType", securityConfiguration.getTruststore().getType());
        });
    }
}

