/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.wso2.appserver.exceptions.ApplicationServerException;

public final class PathUtils {
    private static final Path PATH_CATALINA_BASE;
    private static final Path PATH_CATALINA_CONFIG_BASE;
    private static final Path PATH_APP_SERVER_CONFIG_BASE;

    private PathUtils() {
    }

    public static Path getCatalinaBase() {
        return PATH_CATALINA_BASE;
    }

    public static Path getCatalinaConfigurationBase() {
        return PATH_CATALINA_CONFIG_BASE;
    }

    public static Path getAppServerConfigurationBase() {
        return PATH_APP_SERVER_CONFIG_BASE;
    }

    public static Path getWebAppPath(Context context) throws ApplicationServerException {
        String webappFilePath = "";
        try {
            if (context != null) {
                String docBase = context.getDocBase();
                Host host = (Host)context.getParent();
                String appBase = host.getAppBase();
                File canonicalAppBase = new File(appBase);
                canonicalAppBase = canonicalAppBase.isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(PathUtils.getCatalinaBase().toString(), appBase).getCanonicalFile();
                File webappFile = new File(docBase);
                webappFilePath = webappFile.isAbsolute() ? webappFile.getCanonicalPath() : new File(canonicalAppBase, docBase).getPath();
            }
        }
        catch (IOException e) {
            throw new ApplicationServerException("Error while generating webapp file path", e);
        }
        return Paths.get(webappFilePath, new String[0]);
    }

    static {
        String catalinaBase = System.getProperty("catalina.base");
        PATH_CATALINA_BASE = Paths.get(catalinaBase, new String[0]);
        PATH_CATALINA_CONFIG_BASE = Paths.get(catalinaBase, "conf");
        PATH_APP_SERVER_CONFIG_BASE = Paths.get(catalinaBase, "conf", "wso2");
    }
}

