/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.balana.utils.exception.PolicyBuilderException;
import org.wso2.balana.utils.policy.dto.AllOfElementDTO;
import org.wso2.balana.utils.policy.dto.AnyOfElementDTO;
import org.wso2.balana.utils.policy.dto.ApplyElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeAssignmentElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeDesignatorDTO;
import org.wso2.balana.utils.policy.dto.AttributeElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeSelectorDTO;
import org.wso2.balana.utils.policy.dto.AttributeValueElementDTO;
import org.wso2.balana.utils.policy.dto.AttributesElementDTO;
import org.wso2.balana.utils.policy.dto.ConditionElementDT0;
import org.wso2.balana.utils.policy.dto.FunctionElementDTO;
import org.wso2.balana.utils.policy.dto.MatchElementDTO;
import org.wso2.balana.utils.policy.dto.ObligationElementDTO;
import org.wso2.balana.utils.policy.dto.PolicyElementDTO;
import org.wso2.balana.utils.policy.dto.PolicySetElementDTO;
import org.wso2.balana.utils.policy.dto.RequestElementDTO;
import org.wso2.balana.utils.policy.dto.RuleElementDTO;
import org.wso2.balana.utils.policy.dto.TargetElementDTO;

public class PolicyUtils {
    private static final Log log = LogFactory.getLog(PolicyUtils.class);

    public static Element createPolicyElement(PolicyElementDTO policyElementDTO, Document doc) throws PolicyBuilderException {
        Element policyElement = doc.createElement("Policy");
        policyElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        if (policyElementDTO.getPolicyName() == null || policyElementDTO.getPolicyName().trim().length() <= 0) {
            throw new PolicyBuilderException("Policy name can not be null");
        }
        policyElement.setAttribute("PolicyId", policyElementDTO.getPolicyName());
        if (policyElementDTO.getRuleCombiningAlgorithms() != null && policyElementDTO.getRuleCombiningAlgorithms().trim().length() > 0) {
            policyElement.setAttribute("RuleCombiningAlgId", policyElementDTO.getRuleCombiningAlgorithms());
        } else {
            policyElement.setAttribute("RuleCombiningAlgId", "urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:deny-overrides");
            log.warn((Object)"Rule combining algorithm is not defined. Use default algorithm; Deny Override");
        }
        if (policyElementDTO.getVersion() != null && policyElementDTO.getVersion().trim().length() > 0) {
            policyElement.setAttribute("Version", policyElementDTO.getVersion());
        } else {
            policyElement.setAttribute("Version", "1.0");
        }
        if (policyElementDTO.getPolicyDescription() != null && policyElementDTO.getPolicyDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(policyElementDTO.getPolicyDescription());
            policyElement.appendChild(descriptionElement);
        }
        TargetElementDTO targetElementDTO = policyElementDTO.getTargetElementDTO();
        List<RuleElementDTO> ruleElementDTOs = policyElementDTO.getRuleElementDTOs();
        List<ObligationElementDTO> obligationElementDTOs = policyElementDTO.getObligationElementDTOs();
        if (targetElementDTO != null) {
            policyElement.appendChild(PolicyUtils.createTargetElement(targetElementDTO, doc));
        } else {
            policyElement.appendChild(doc.createElement("Target"));
        }
        if (ruleElementDTOs != null && ruleElementDTOs.size() > 0) {
            for (RuleElementDTO ruleElementDTO : ruleElementDTOs) {
                policyElement.appendChild(PolicyUtils.createRuleElement(ruleElementDTO, doc));
            }
        } else {
            RuleElementDTO ruleElementDTO = new RuleElementDTO();
            ruleElementDTO.setRuleId(UUID.randomUUID().toString());
            ruleElementDTO.setRuleEffect("Deny");
            policyElement.appendChild(PolicyUtils.createRuleElement(ruleElementDTO, doc));
        }
        if (obligationElementDTOs != null && obligationElementDTOs.size() > 0) {
            ArrayList<ObligationElementDTO> obligations = new ArrayList<ObligationElementDTO>();
            ArrayList<ObligationElementDTO> advices = new ArrayList<ObligationElementDTO>();
            for (ObligationElementDTO obligationElementDTO : obligationElementDTOs) {
                if (obligationElementDTO.getType() == 2) {
                    advices.add(obligationElementDTO);
                    continue;
                }
                obligations.add(obligationElementDTO);
            }
            Element obligation = PolicyUtils.createObligationsElement(obligations, doc);
            Element advice = PolicyUtils.createAdvicesElement(advices, doc);
            if (obligation != null) {
                policyElement.appendChild(obligation);
            }
            if (advice != null) {
                policyElement.appendChild(advice);
            }
        }
        return policyElement;
    }

    public static Element createPolicySetElement(PolicySetElementDTO policyElementDTO, Document doc) throws PolicyBuilderException {
        List<String> policyIds;
        List<String> policySetIds;
        List<String> policies;
        Element policyElement = doc.createElement("PolicySet");
        policyElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        if (policyElementDTO.getPolicySetId() == null || policyElementDTO.getPolicySetId().trim().length() <= 0) {
            throw new PolicyBuilderException("Policy name can not be null");
        }
        policyElement.setAttribute("PolicySetId", policyElementDTO.getPolicySetId());
        if (policyElementDTO.getPolicyCombiningAlgId() != null && policyElementDTO.getPolicyCombiningAlgId().trim().length() > 0) {
            policyElement.setAttribute("PolicyCombiningAlgId", policyElementDTO.getPolicyCombiningAlgId());
        } else {
            policyElement.setAttribute("PolicyCombiningAlgId", "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-overrides");
            log.warn((Object)"Rule combining algorithm is not defined. Use default algorithm; Deny Override");
        }
        if (policyElementDTO.getVersion() != null && policyElementDTO.getVersion().trim().length() > 0) {
            policyElement.setAttribute("Version", policyElementDTO.getVersion());
        } else {
            policyElement.setAttribute("Version", "1.0");
        }
        if (policyElementDTO.getDescription() != null && policyElementDTO.getDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(policyElementDTO.getDescription());
            policyElement.appendChild(descriptionElement);
        }
        TargetElementDTO targetElementDTO = policyElementDTO.getTargetElementDTO();
        List<ObligationElementDTO> obligationElementDTOs = policyElementDTO.getObligationElementDTOs();
        if (targetElementDTO != null) {
            policyElement.appendChild(PolicyUtils.createTargetElement(targetElementDTO, doc));
        } else {
            policyElement.appendChild(doc.createElement("Target"));
        }
        List<String> policySets = policyElementDTO.getPolicySets();
        if (policySets == null || policySets.size() > 0) {
            // empty if block
        }
        if ((policies = policyElementDTO.getPolicies()) == null || policies.size() > 0) {
            // empty if block
        }
        if ((policySetIds = policyElementDTO.getPolicySetIdReferences()) != null && policySetIds.size() > 0) {
            for (String string : policySetIds) {
                Element element = doc.createElement("PolicySetIdReference");
                element.setTextContent(string);
                policyElement.appendChild(element);
            }
        }
        if ((policyIds = policyElementDTO.getPolicyIdReferences()) != null && policyIds.size() > 0) {
            for (String policyId : policyIds) {
                Element element = doc.createElement("PolicyIdReference");
                element.setTextContent(policyId);
                policyElement.appendChild(element);
            }
        }
        if (obligationElementDTOs != null && obligationElementDTOs.size() > 0) {
            ArrayList<ObligationElementDTO> arrayList = new ArrayList<ObligationElementDTO>();
            ArrayList<ObligationElementDTO> advices = new ArrayList<ObligationElementDTO>();
            for (ObligationElementDTO obligationElementDTO : obligationElementDTOs) {
                if (obligationElementDTO.getType() == 2) {
                    advices.add(obligationElementDTO);
                    continue;
                }
                arrayList.add(obligationElementDTO);
            }
            Element obligation = PolicyUtils.createObligationsElement(arrayList, doc);
            Element advice = PolicyUtils.createAdvicesElement(advices, doc);
            if (obligation != null) {
                policyElement.appendChild(obligation);
            }
            if (advice != null) {
                policyElement.appendChild(advice);
            }
        }
        return policyElement;
    }

    public static Element createRequestElement(RequestElementDTO requestElementDTO, Document doc) throws PolicyBuilderException {
        Element requestElement = doc.createElement("Request");
        requestElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        requestElement.setAttribute("ReturnPolicyIdList", Boolean.toString(requestElementDTO.isReturnPolicyIdList()));
        requestElement.setAttribute("CombinedDecision", Boolean.toString(requestElementDTO.isCombinedDecision()));
        List<AttributesElementDTO> attributesElementDTOs = requestElementDTO.getAttributesElementDTOs();
        if (attributesElementDTOs != null && attributesElementDTOs.size() > 0) {
            for (AttributesElementDTO dto : attributesElementDTOs) {
                requestElement.appendChild(PolicyUtils.createAttributesElement(dto, doc));
            }
        }
        return requestElement;
    }

    public static Element createMatchElement(MatchElementDTO matchElementDTO, Document doc) throws PolicyBuilderException {
        Element matchElement = null;
        if (matchElementDTO.getMatchId() != null && matchElementDTO.getMatchId().trim().length() > 0) {
            matchElement = doc.createElement("Match");
            matchElement.setAttribute("MatchId", matchElementDTO.getMatchId());
            if (matchElementDTO.getAttributeValueElementDTO() != null) {
                Element attributeValueElement = PolicyUtils.createAttributeValueElement(matchElementDTO.getAttributeValueElementDTO(), doc);
                matchElement.appendChild(attributeValueElement);
            }
            if (matchElementDTO.getAttributeDesignatorDTO() != null) {
                Element attributeDesignatorElement = PolicyUtils.createAttributeDesignatorElement(matchElementDTO.getAttributeDesignatorDTO(), doc);
                matchElement.appendChild(attributeDesignatorElement);
            }
            if (matchElementDTO.getAttributeSelectorDTO() != null) {
                Element attributeSelectorElement = PolicyUtils.createAttributeSelectorElement(matchElementDTO.getAttributeSelectorDTO(), doc);
                matchElement.appendChild(attributeSelectorElement);
            }
        }
        return matchElement;
    }

    public static Element createAttributeValueElement(AttributeValueElementDTO attributeValueElementDTO, Document doc) {
        Element attributeValueElement = doc.createElement("AttributeValue");
        if (attributeValueElementDTO.getAttributeValue() != null && attributeValueElementDTO.getAttributeValue().trim().length() > 0) {
            attributeValueElement.setTextContent(attributeValueElementDTO.getAttributeValue().trim());
            if (attributeValueElementDTO.getAttributeDataType() != null && attributeValueElementDTO.getAttributeDataType().trim().length() > 0) {
                attributeValueElement.setAttribute("DataType", attributeValueElementDTO.getAttributeDataType());
            } else {
                attributeValueElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
        }
        return attributeValueElement;
    }

    public static Element createAttributesElement(AttributesElementDTO elementDTO, Document doc) {
        Element attributesElement = doc.createElement("Attributes");
        attributesElement.setAttribute("Category", elementDTO.getCategory());
        List<AttributeElementDTO> attributeElementDTOs = elementDTO.getAttributeElementDTOs();
        if (attributeElementDTOs != null && attributeElementDTOs.size() > 0) {
            for (AttributeElementDTO attributeElementDTO : attributeElementDTOs) {
                Element attributeElement = doc.createElement("Attribute");
                attributeElement.setAttribute("AttributeId", attributeElementDTO.getAttributeId());
                attributeElement.setAttribute("IncludeInResult", Boolean.toString(attributeElementDTO.isIncludeInResult()));
                if (attributeElementDTO.getIssuer() != null && attributeElementDTO.getIssuer().trim().length() > 0) {
                    attributeElement.setAttribute("Issuer", attributeElementDTO.getIssuer());
                }
                List<String> values = attributeElementDTO.getAttributeValues();
                for (String value : values) {
                    Element attributeValueElement = doc.createElement("AttributeValue");
                    attributeValueElement.setAttribute("DataType", attributeElementDTO.getDataType());
                    attributeValueElement.setTextContent(value.trim());
                    attributeElement.appendChild(attributeValueElement);
                }
                attributesElement.appendChild(attributeElement);
            }
        }
        return attributesElement;
    }

    public static Element createFunctionElement(FunctionElementDTO functionElementDTO, Document doc) {
        Element functionElement = doc.createElement("Function");
        if (functionElementDTO.getFunctionId() != null && functionElementDTO.getFunctionId().trim().length() > 0) {
            functionElement.setAttribute("FunctionId", functionElementDTO.getFunctionId());
        }
        return functionElement;
    }

    public static Element createAttributeDesignatorElement(AttributeDesignatorDTO attributeDesignatorDTO, Document doc) throws PolicyBuilderException {
        String attributeDesignatorElementName = "AttributeDesignator";
        Element attributeDesignatorElement = doc.createElement(attributeDesignatorElementName);
        String attributeId = attributeDesignatorDTO.getAttributeId();
        String category = attributeDesignatorDTO.getCategory();
        if (attributeId != null && attributeId.trim().length() > 0 && category != null && category.trim().length() > 0) {
            attributeDesignatorElement.setAttribute("AttributeId", attributeDesignatorDTO.getAttributeId());
            attributeDesignatorElement.setAttribute("Category", attributeDesignatorDTO.getCategory());
            if (attributeDesignatorDTO.getDataType() != null && attributeDesignatorDTO.getDataType().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("DataType", attributeDesignatorDTO.getDataType());
            } else {
                attributeDesignatorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeDesignatorDTO.getIssuer() != null && attributeDesignatorDTO.getIssuer().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("Issuer", attributeDesignatorDTO.getIssuer());
            }
            if (attributeDesignatorDTO.getMustBePresent() != null && attributeDesignatorDTO.getMustBePresent().trim().length() > 0) {
                attributeDesignatorElement.setAttribute("MustBePresent", attributeDesignatorDTO.getMustBePresent());
            } else {
                attributeDesignatorElement.setAttribute("MustBePresent", "true");
            }
        } else {
            throw new PolicyBuilderException("Category  name can not be null");
        }
        return attributeDesignatorElement;
    }

    public static Element createAttributeSelectorElement(AttributeSelectorDTO attributeSelectorDTO, Document doc) {
        Element attributeSelectorElement = doc.createElement("AttributeSelector");
        if (attributeSelectorDTO.getAttributeSelectorRequestContextPath() != null && attributeSelectorDTO.getAttributeSelectorRequestContextPath().trim().length() > 0) {
            attributeSelectorElement.setAttribute("RequestContextPath", "urn:oasis:names:tc:xacml:2.0:example:attribute:" + attributeSelectorDTO.getAttributeSelectorRequestContextPath());
            if (attributeSelectorDTO.getAttributeSelectorDataType() != null && attributeSelectorDTO.getAttributeSelectorDataType().trim().length() > 0) {
                attributeSelectorElement.setAttribute("DataType", attributeSelectorDTO.getAttributeSelectorDataType());
            } else {
                attributeSelectorElement.setAttribute("DataType", "http://www.w3.org/2001/XMLSchema#string");
            }
            if (attributeSelectorDTO.getAttributeSelectorMustBePresent() != null && attributeSelectorDTO.getAttributeSelectorMustBePresent().trim().length() > 0) {
                attributeSelectorElement.setAttribute("MustBePresent", attributeSelectorDTO.getAttributeSelectorMustBePresent());
            }
        }
        return attributeSelectorElement;
    }

    public static Element createObligationsElement(List<ObligationElementDTO> obligationElementDTOs, Document doc) throws PolicyBuilderException {
        Element obligationExpressions = null;
        if (obligationElementDTOs != null && obligationElementDTOs.size() > 0) {
            for (ObligationElementDTO dto : obligationElementDTOs) {
                String id = dto.getId();
                String effect = dto.getEffect();
                if (id == null || id.trim().length() <= 0 || effect == null) continue;
                if (obligationExpressions == null) {
                    obligationExpressions = doc.createElement("ObligationExpressions");
                }
                Element obligationExpression = doc.createElement("ObligationExpression");
                obligationExpression.setAttribute("ObligationId", id);
                obligationExpression.setAttribute("FulfillOn", effect);
                List<AttributeAssignmentElementDTO> elementDTOs = dto.getAssignmentElementDTOs();
                if (elementDTOs != null) {
                    for (AttributeAssignmentElementDTO elementDTO : elementDTOs) {
                        Element element = PolicyUtils.createAttributeAssignmentElement(elementDTO, doc);
                        if (element == null) continue;
                        obligationExpression.appendChild(element);
                    }
                }
                obligationExpressions.appendChild(obligationExpression);
            }
        }
        return obligationExpressions;
    }

    public static Element createAdvicesElement(List<ObligationElementDTO> obligationElementDTOs, Document doc) throws PolicyBuilderException {
        Element adviceExpressions = null;
        if (obligationElementDTOs != null && obligationElementDTOs.size() > 0) {
            for (ObligationElementDTO dto : obligationElementDTOs) {
                String id = dto.getId();
                String effect = dto.getEffect();
                if (id == null || id.trim().length() <= 0 || effect == null) continue;
                if (adviceExpressions == null) {
                    adviceExpressions = doc.createElement("AdviceExpressions");
                }
                Element adviceExpression = doc.createElement("AdviceExpression");
                adviceExpression.setAttribute("AdviceId", id);
                adviceExpression.setAttribute("AppliesTo", effect);
                List<AttributeAssignmentElementDTO> elementDTOs = dto.getAssignmentElementDTOs();
                if (elementDTOs != null) {
                    for (AttributeAssignmentElementDTO elementDTO : elementDTOs) {
                        Element element = PolicyUtils.createAttributeAssignmentElement(elementDTO, doc);
                        if (element == null) continue;
                        adviceExpression.appendChild(element);
                    }
                }
                adviceExpressions.appendChild(adviceExpression);
            }
        }
        return adviceExpressions;
    }

    public static Element createAttributeAssignmentElement(AttributeAssignmentElementDTO assignmentElementDTO, Document doc) throws PolicyBuilderException {
        String attributeId = assignmentElementDTO.getAttributeId();
        if (attributeId != null && attributeId.trim().length() > 0) {
            String category = assignmentElementDTO.getCategory();
            String issuer = assignmentElementDTO.getIssuer();
            ApplyElementDTO applyElementDTO = assignmentElementDTO.getApplyElementDTO();
            AttributeDesignatorDTO designatorDTO = assignmentElementDTO.getDesignatorDTO();
            AttributeValueElementDTO valueElementDTO = assignmentElementDTO.getValueElementDTO();
            Element attributeAssignment = doc.createElement("AttributeAssignmentExpression");
            attributeAssignment.setAttribute("AttributeId", attributeId);
            if (category != null && category.trim().length() > 0) {
                attributeAssignment.setAttribute("Category", category);
            }
            if (issuer != null && issuer.trim().length() > 0) {
                attributeAssignment.setAttribute("Issuer", issuer);
            }
            if (applyElementDTO != null) {
                attributeAssignment.appendChild(PolicyUtils.createApplyElement(applyElementDTO, doc));
            }
            if (designatorDTO != null) {
                attributeAssignment.appendChild(PolicyUtils.createAttributeDesignatorElement(designatorDTO, doc));
            }
            if (valueElementDTO != null) {
                attributeAssignment.appendChild(PolicyUtils.createAttributeValueElement(valueElementDTO, doc));
            }
            return attributeAssignment;
        }
        return null;
    }

    public static Element createTargetElement(TargetElementDTO targetElementDTO, Document doc) throws PolicyBuilderException {
        Element targetElement = doc.createElement("Target");
        List<AnyOfElementDTO> anyOfElementDTOs = targetElementDTO.getAnyOfElementDTOs();
        for (AnyOfElementDTO anyOfElementDTO : anyOfElementDTOs) {
            Element anyOfElement = doc.createElement("AnyOf");
            List<AllOfElementDTO> allOfElementDTOs = anyOfElementDTO.getAllOfElementDTOs();
            for (AllOfElementDTO allOfElementDTO : allOfElementDTOs) {
                Element allOfElement = doc.createElement("AllOf");
                List<MatchElementDTO> matchElementDTOs = allOfElementDTO.getMatchElementDTOs();
                for (MatchElementDTO matchElementDTO : matchElementDTOs) {
                    Element matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    allOfElement.appendChild(matchElement);
                }
                anyOfElement.appendChild(allOfElement);
            }
            targetElement.appendChild(anyOfElement);
        }
        return targetElement;
    }

    public static Element createRuleElement(RuleElementDTO ruleElementDTO, Document doc) throws PolicyBuilderException {
        TargetElementDTO targetElementDTO = ruleElementDTO.getTargetElementDTO();
        ConditionElementDT0 conditionElementDT0 = ruleElementDTO.getConditionElementDT0();
        List<ObligationElementDTO> obligationElementDTOs = ruleElementDTO.getObligationElementDTOs();
        Element ruleElement = doc.createElement("Rule");
        if (ruleElementDTO.getRuleId() != null && ruleElementDTO.getRuleId().trim().length() > 0) {
            ruleElement.setAttribute("RuleId", ruleElementDTO.getRuleId());
        }
        if (ruleElementDTO.getRuleEffect() != null && ruleElementDTO.getRuleEffect().trim().length() > 0) {
            ruleElement.setAttribute("Effect", ruleElementDTO.getRuleEffect());
        }
        if (ruleElementDTO.getRuleDescription() != null && ruleElementDTO.getRuleDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(ruleElementDTO.getRuleDescription());
            ruleElement.appendChild(descriptionElement);
        }
        if (targetElementDTO != null) {
            Element targetElement = PolicyUtils.createTargetElement(targetElementDTO, doc);
            ruleElement.appendChild(targetElement);
        }
        if (conditionElementDT0 != null) {
            ruleElement.appendChild(PolicyUtils.createConditionElement(conditionElementDT0, doc));
        }
        if (obligationElementDTOs != null && obligationElementDTOs.size() > 0) {
            ArrayList<ObligationElementDTO> obligations = new ArrayList<ObligationElementDTO>();
            ArrayList<ObligationElementDTO> advices = new ArrayList<ObligationElementDTO>();
            for (ObligationElementDTO obligationElementDTO : obligationElementDTOs) {
                if (obligationElementDTO.getType() == 2) {
                    advices.add(obligationElementDTO);
                    continue;
                }
                obligations.add(obligationElementDTO);
            }
            Element obligation = PolicyUtils.createObligationsElement(obligations, doc);
            Element advice = PolicyUtils.createAdvicesElement(advices, doc);
            if (obligation != null) {
                ruleElement.appendChild(obligation);
            }
            if (advice != null) {
                ruleElement.appendChild(advice);
            }
        }
        return ruleElement;
    }

    public static Element createConditionElement(ConditionElementDT0 conditionElementDT0, Document doc) throws PolicyBuilderException {
        Element conditionElement = doc.createElement("Condition");
        if (conditionElementDT0.getApplyElement() != null) {
            conditionElement.appendChild(PolicyUtils.createApplyElement(conditionElementDT0.getApplyElement(), doc));
        } else if (conditionElementDT0.getAttributeValueElementDTO() != null) {
            Element attributeValueElement = PolicyUtils.createAttributeValueElement(conditionElementDT0.getAttributeValueElementDTO(), doc);
            conditionElement.appendChild(attributeValueElement);
        } else if (conditionElementDT0.getAttributeDesignator() != null) {
            AttributeDesignatorDTO attributeDesignatorDTO = conditionElementDT0.getAttributeDesignator();
            conditionElement.appendChild(PolicyUtils.createAttributeDesignatorElement(attributeDesignatorDTO, doc));
        } else if (conditionElementDT0.getFunctionFunctionId() != null) {
            Element functionElement = doc.createElement("Function");
            functionElement.setAttribute("FunctionId", conditionElementDT0.getFunctionFunctionId());
            conditionElement.appendChild(functionElement);
        } else if (conditionElementDT0.getVariableId() != null) {
            Element variableReferenceElement = doc.createElement("VariableReference");
            variableReferenceElement.setAttribute("VariableId", conditionElementDT0.getVariableId());
            conditionElement.appendChild(variableReferenceElement);
        }
        return conditionElement;
    }

    public static Element createApplyElement(ApplyElementDTO applyElementDTO, Document doc) throws PolicyBuilderException {
        List<AttributeSelectorDTO> list;
        List<AttributeDesignatorDTO> list2;
        List<AttributeValueElementDTO> attributeValueElementDTOs;
        List<ApplyElementDTO> applyElementDTOs;
        Element applyElement = doc.createElement("Apply");
        if (applyElementDTO.getFunctionId() != null && applyElementDTO.getFunctionId().trim().length() > 0) {
            applyElement.setAttribute("FunctionId", applyElementDTO.getFunctionId());
        }
        if (applyElementDTO.getFunctionFunctionId() != null && applyElementDTO.getFunctionFunctionId().trim().length() > 0) {
            FunctionElementDTO functionElementDTO = new FunctionElementDTO();
            functionElementDTO.setFunctionId(applyElementDTO.getFunctionFunctionId());
            Element functionElement = PolicyUtils.createFunctionElement(functionElementDTO, doc);
            applyElement.appendChild(functionElement);
        }
        if ((applyElementDTOs = applyElementDTO.getApplyElements()) != null && applyElementDTOs.size() > 0) {
            for (ApplyElementDTO applyElementDTO2 : applyElementDTOs) {
                Element element = PolicyUtils.createApplyElement(applyElementDTO2, doc);
                applyElement.appendChild(element);
            }
        }
        if ((attributeValueElementDTOs = applyElementDTO.getAttributeValueElementDTOs()) != null && attributeValueElementDTOs.size() > 0) {
            for (AttributeValueElementDTO attributeValueElementDTO : attributeValueElementDTOs) {
                Element attributeValueElement = PolicyUtils.createAttributeValueElement(attributeValueElementDTO, doc);
                applyElement.appendChild(attributeValueElement);
            }
        }
        if ((list2 = applyElementDTO.getAttributeDesignators()) != null && list2.size() > 0) {
            for (AttributeDesignatorDTO attributeDesignatorDTO : list2) {
                Element attributeDesignatorElement = PolicyUtils.createAttributeDesignatorElement(attributeDesignatorDTO, doc);
                applyElement.appendChild(attributeDesignatorElement);
            }
        }
        if ((list = applyElementDTO.getAttributeSelectors()) != null && list.size() > 0) {
            for (AttributeSelectorDTO attributeSelectorDTO : list) {
                Element attributeSelectorElement = PolicyUtils.createAttributeSelectorElement(attributeSelectorDTO, doc);
                applyElement.appendChild(attributeSelectorElement);
            }
        }
        return applyElement;
    }
}

