/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.utils.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.utils.Constants.PolicyConstants;
import org.wso2.balana.utils.PolicyUtils;
import org.wso2.balana.utils.exception.PolicyBuilderException;
import org.wso2.balana.utils.policy.dto.ApplyElementDTO;
import org.wso2.balana.utils.policy.dto.AttributeDesignatorDTO;
import org.wso2.balana.utils.policy.dto.AttributeValueElementDTO;
import org.wso2.balana.utils.policy.dto.BasicPolicyDTO;
import org.wso2.balana.utils.policy.dto.BasicRuleDTO;
import org.wso2.balana.utils.policy.dto.BasicTargetDTO;
import org.wso2.balana.utils.policy.dto.MatchElementDTO;

public class BasicPolicyHelper {
    private static final Log log = LogFactory.getLog(BasicPolicyHelper.class);

    public static Element createPolicyElement(BasicPolicyDTO basicPolicyDTO, Document doc) throws PolicyBuilderException {
        Element policyElement = doc.createElement("Policy");
        policyElement.setAttribute("xmlns", "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        if (basicPolicyDTO.getPolicyId() == null || basicPolicyDTO.getPolicyId().trim().length() <= 0) {
            throw new PolicyBuilderException("Policy name can not be null");
        }
        policyElement.setAttribute("PolicyId", basicPolicyDTO.getPolicyId());
        if (basicPolicyDTO.getRuleAlgorithm() != null && basicPolicyDTO.getRuleAlgorithm().trim().length() > 0) {
            policyElement.setAttribute("RuleCombiningAlgId", basicPolicyDTO.getRuleAlgorithm());
        } else {
            policyElement.setAttribute("RuleCombiningAlgId", "urn:oasis:names:tc:xacml:3.0:rule-combining-algorithm:deny-overrides");
            log.warn((Object)"Rule combining algorithm is not defined. Use default algorithm; Deny Override");
        }
        if (basicPolicyDTO.getVersion() != null && basicPolicyDTO.getVersion().trim().length() > 0) {
            policyElement.setAttribute("Version", basicPolicyDTO.getVersion());
        } else {
            policyElement.setAttribute("Version", "1.0");
        }
        if (basicPolicyDTO.getDescription() != null && basicPolicyDTO.getDescription().trim().length() > 0) {
            Element descriptionElement = doc.createElement("Description");
            descriptionElement.setTextContent(basicPolicyDTO.getDescription());
            policyElement.appendChild(descriptionElement);
        }
        BasicTargetDTO basicTargetDTO = basicPolicyDTO.getTargetDTO();
        List<BasicRuleDTO> basicRuleDTOs = basicPolicyDTO.getBasicRuleDTOs();
        if (basicTargetDTO != null) {
            policyElement.appendChild(BasicPolicyHelper.createTargetElement(basicTargetDTO, doc));
        } else {
            policyElement.appendChild(doc.createElement("Target"));
        }
        if (basicRuleDTOs != null && basicRuleDTOs.size() > 0) {
            for (BasicRuleDTO basicRuleDTO : basicRuleDTOs) {
                policyElement.appendChild(BasicPolicyHelper.createRuleElement(basicRuleDTO, doc));
            }
        } else {
            BasicRuleDTO basicRuleDTO = new BasicRuleDTO();
            basicRuleDTO.setRuleId(UUID.randomUUID().toString());
            basicRuleDTO.setRuleEffect("Deny");
            policyElement.appendChild(BasicPolicyHelper.createRuleElement(basicRuleDTO, doc));
        }
        return policyElement;
    }

    public static Element createRuleElement(BasicRuleDTO basicRuleDTO, Document doc) throws PolicyBuilderException {
        ApplyElementDTO notElementDTO;
        AttributeDesignatorDTO designatorDTO;
        Element matchElement;
        MatchElementDTO matchElementDTO;
        boolean notPrefix;
        String functionOnResources = basicRuleDTO.getFunctionOnResources();
        String functionOnSubjects = basicRuleDTO.getFunctionOnSubjects();
        String functionOnActions = basicRuleDTO.getFunctionOnActions();
        String functionOnEnvironment = basicRuleDTO.getFunctionOnEnvironment();
        String preFunctionOnResources = basicRuleDTO.getPreFunctionOnResources();
        String preFunctionOnSubjects = basicRuleDTO.getPreFunctionOnSubjects();
        String preFunctionOnActions = basicRuleDTO.getPreFunctionOnActions();
        String preFunctionOnEnvironment = basicRuleDTO.getPreFunctionOnEnvironment();
        String resourceNames = basicRuleDTO.getResourceList();
        String actionNames = basicRuleDTO.getActionList();
        String subjectNames = basicRuleDTO.getSubjectList();
        String environmentNames = basicRuleDTO.getEnvironmentList();
        String resourceId = basicRuleDTO.getResourceId();
        String subjectId = basicRuleDTO.getSubjectId();
        String actionId = basicRuleDTO.getActionId();
        String environmentId = basicRuleDTO.getEnvironmentId();
        String resourceDataType = basicRuleDTO.getResourceDataType();
        String subjectDataType = basicRuleDTO.getSubjectDataType();
        String actionDataType = basicRuleDTO.getActionDataType();
        String environmentDataType = basicRuleDTO.getEnvironmentDataType();
        Element resourcesElement = null;
        Element actionsElement = null;
        Node subjectsElement = null;
        Element environmentsElement = null;
        Element targetElement = null;
        Element applyElement = null;
        Element conditionElement = null;
        Element ruleElement = null;
        ApplyElementDTO rootApplyElementDTO = new ApplyElementDTO();
        ApplyElementDTO subjectApplyElementDTO = null;
        ApplyElementDTO resourceApplyElementDTO = null;
        ApplyElementDTO actionApplyElementDTO = null;
        ApplyElementDTO environmentApplyElementDTO = null;
        ArrayList<ApplyElementDTO> applyElementDTOs = new ArrayList<ApplyElementDTO>();
        if (resourceNames != null && resourceNames.trim().length() > 0) {
            String[] resources = resourceNames.split(",");
            if (resourceId == null || resourceId.trim().length() < 1) {
                resourceId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
            }
            notPrefix = false;
            if ("not".equals(preFunctionOnResources)) {
                notPrefix = true;
            }
            if (Arrays.asList(PolicyConstants.Functions.targetFunctions).contains(functionOnResources) && !notPrefix) {
                resourcesElement = doc.createElement("AnyOf");
                Element resourceElement = doc.createElement("AllOf");
                matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnResources, resources[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (Arrays.asList(PolicyConstants.Functions.advanceRuleFunctions).contains(functionOnResources)) {
                designatorDTO = new AttributeDesignatorDTO();
                designatorDTO.setCategory("urn:oasis:names:tc:xacml:3.0:attribute-category:resource");
                designatorDTO.setAttributeId(resourceId);
                designatorDTO.setDataType(resourceDataType);
                designatorDTO.setMustBePresent("true");
                resourceApplyElementDTO = BasicPolicyHelper.processGreaterLessThanFunctions(functionOnResources, resourceDataType, resourceNames, designatorDTO);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleBagRuleFunctions).contains(functionOnResources)) {
                resourceApplyElementDTO = BasicPolicyHelper.createApplyElementForBagFunctions(functionOnResources, "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resources, resourceDataType);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleRuleFunctions).contains(functionOnSubjects)) {
                resourceApplyElementDTO = BasicPolicyHelper.createApplyElementForNonBagFunctions(functionOnResources, "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resources[0].trim(), resourceDataType);
            }
            if (resourceApplyElementDTO != null) {
                if (notPrefix) {
                    notElementDTO = new ApplyElementDTO();
                    notElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:not");
                    notElementDTO.setApplyElement(resourceApplyElementDTO);
                    resourceApplyElementDTO = notElementDTO;
                }
                applyElementDTOs.add(resourceApplyElementDTO);
            }
        }
        if (actionNames != null && actionNames.trim().length() > 0) {
            String[] actions = actionNames.split(",");
            if (actionId == null || actionId.trim().length() < 1) {
                actionId = "urn:oasis:names:tc:xacml:1.0:action:action-id";
            }
            notPrefix = false;
            if ("not".equals(preFunctionOnActions)) {
                notPrefix = true;
            }
            if (Arrays.asList(PolicyConstants.Functions.targetFunctions).contains(functionOnActions) && !notPrefix) {
                actionsElement = doc.createElement("AnyOf");
                Element actionElement = doc.createElement("AllOf");
                matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnActions, actions[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            } else if (Arrays.asList(PolicyConstants.Functions.advanceRuleFunctions).contains(functionOnActions)) {
                designatorDTO = new AttributeDesignatorDTO();
                designatorDTO.setCategory("urn:oasis:names:tc:xacml:3.0:attribute-category:action");
                designatorDTO.setAttributeId(actionId);
                designatorDTO.setDataType(actionDataType);
                designatorDTO.setMustBePresent("true");
                actionApplyElementDTO = BasicPolicyHelper.processGreaterLessThanFunctions(functionOnActions, actionDataType, actionNames, designatorDTO);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleBagRuleFunctions).contains(functionOnActions)) {
                actionApplyElementDTO = BasicPolicyHelper.createApplyElementForBagFunctions(functionOnActions, "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actions, actionDataType);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleRuleFunctions).contains(functionOnActions)) {
                actionApplyElementDTO = BasicPolicyHelper.createApplyElementForNonBagFunctions(functionOnActions, "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actions[0].trim(), actionDataType);
            }
            if (actionApplyElementDTO != null) {
                if (notPrefix) {
                    notElementDTO = new ApplyElementDTO();
                    notElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:not");
                    notElementDTO.setApplyElement(actionApplyElementDTO);
                    actionApplyElementDTO = notElementDTO;
                }
                applyElementDTOs.add(actionApplyElementDTO);
            }
        }
        if (environmentNames != null && environmentNames.trim().length() > 0) {
            String[] environments = environmentNames.split(",");
            if (environmentId == null || environmentId.trim().length() < 1) {
                environmentId = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
            }
            notPrefix = false;
            if ("not".equals(preFunctionOnEnvironment)) {
                notPrefix = true;
            }
            if (Arrays.asList(PolicyConstants.Functions.targetFunctions).contains(functionOnEnvironment) && !notPrefix) {
                environmentsElement = doc.createElement("AnyOf");
                Element environmentElement = doc.createElement("AllOf");
                matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnEnvironment, environments[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                if (matchElement != null) {
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (Arrays.asList(PolicyConstants.Functions.advanceRuleFunctions).contains(functionOnEnvironment)) {
                designatorDTO = new AttributeDesignatorDTO();
                designatorDTO.setCategory("urn:oasis:names:tc:xacml:3.0:attribute-category:environment");
                designatorDTO.setAttributeId(environmentId);
                designatorDTO.setDataType(environmentDataType);
                designatorDTO.setMustBePresent("true");
                environmentApplyElementDTO = BasicPolicyHelper.processGreaterLessThanFunctions(functionOnEnvironment, environmentDataType, environmentNames, designatorDTO);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleBagRuleFunctions).contains(functionOnEnvironment)) {
                environmentApplyElementDTO = BasicPolicyHelper.createApplyElementForBagFunctions(functionOnEnvironment, "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environments, environmentDataType);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleRuleFunctions).contains(functionOnEnvironment)) {
                environmentApplyElementDTO = BasicPolicyHelper.createApplyElementForNonBagFunctions(functionOnEnvironment, "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environments[0].trim(), environmentDataType);
            }
            if (environmentApplyElementDTO != null) {
                if (notPrefix) {
                    notElementDTO = new ApplyElementDTO();
                    notElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:not");
                    notElementDTO.setApplyElement(environmentApplyElementDTO);
                    environmentApplyElementDTO = notElementDTO;
                }
                applyElementDTOs.add(environmentApplyElementDTO);
            }
        }
        if (subjectNames != null && subjectNames.trim().length() > 0) {
            String[] subjects = subjectNames.split(",");
            if (subjectId == null || subjectId.trim().length() < 1) {
                subjectId = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
            }
            notPrefix = false;
            if ("not".equals(preFunctionOnSubjects)) {
                notPrefix = true;
            }
            if (Arrays.asList(PolicyConstants.Functions.targetFunctions).contains(functionOnSubjects)) {
                subjectApplyElementDTO = BasicPolicyHelper.createApplyElementForNonBagFunctionsWithAnyOf(functionOnSubjects, "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType, subjects[0].trim());
            } else if (Arrays.asList(PolicyConstants.Functions.advanceRuleFunctions).contains(functionOnSubjects)) {
                designatorDTO = new AttributeDesignatorDTO();
                designatorDTO.setCategory("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
                designatorDTO.setAttributeId(subjectId);
                designatorDTO.setDataType(subjectDataType);
                designatorDTO.setMustBePresent("true");
                subjectApplyElementDTO = BasicPolicyHelper.processGreaterLessThanFunctions(functionOnSubjects, subjectDataType, subjectNames, designatorDTO);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleBagRuleFunctions).contains(functionOnSubjects)) {
                subjectApplyElementDTO = BasicPolicyHelper.createApplyElementForBagFunctions(functionOnSubjects, "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjects, subjectDataType);
            } else if (Arrays.asList(PolicyConstants.Functions.simpleRuleFunctions).contains(functionOnSubjects)) {
                subjectApplyElementDTO = BasicPolicyHelper.createApplyElementForNonBagFunctions(functionOnSubjects, "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjects[0].trim(), subjectDataType);
            }
            if (subjectApplyElementDTO != null) {
                if (notPrefix) {
                    notElementDTO = new ApplyElementDTO();
                    notElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:not");
                    notElementDTO.setApplyElement(subjectApplyElementDTO);
                    subjectApplyElementDTO = notElementDTO;
                }
                applyElementDTOs.add(subjectApplyElementDTO);
            }
        }
        if (applyElementDTOs.size() > 1) {
            if (applyElementDTOs.size() == 2) {
                rootApplyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                rootApplyElementDTO.setApplyElement((ApplyElementDTO)applyElementDTOs.get(0));
                rootApplyElementDTO.setApplyElement((ApplyElementDTO)applyElementDTOs.get(1));
                applyElement = PolicyUtils.createApplyElement(rootApplyElementDTO, doc);
            } else if (applyElementDTOs.size() == 3) {
                rootApplyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                ApplyElementDTO andElementDTO = new ApplyElementDTO();
                andElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                andElementDTO.setApplyElement((ApplyElementDTO)applyElementDTOs.get(0));
                andElementDTO.setApplyElement((ApplyElementDTO)applyElementDTOs.get(1));
                rootApplyElementDTO.setApplyElement(andElementDTO);
                rootApplyElementDTO.setApplyElement((ApplyElementDTO)applyElementDTOs.get(2));
                applyElement = PolicyUtils.createApplyElement(rootApplyElementDTO, doc);
            } else if (applyElementDTOs.size() == 4) {
                rootApplyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                ApplyElementDTO andElementDTO1 = new ApplyElementDTO();
                andElementDTO1.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                andElementDTO1.setApplyElement((ApplyElementDTO)applyElementDTOs.get(0));
                andElementDTO1.setApplyElement((ApplyElementDTO)applyElementDTOs.get(1));
                ApplyElementDTO andElementDTO2 = new ApplyElementDTO();
                andElementDTO2.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:and");
                andElementDTO2.setApplyElement((ApplyElementDTO)applyElementDTOs.get(2));
                andElementDTO2.setApplyElement((ApplyElementDTO)applyElementDTOs.get(3));
                rootApplyElementDTO.setApplyElement(andElementDTO1);
                rootApplyElementDTO.setApplyElement(andElementDTO2);
                applyElement = PolicyUtils.createApplyElement(rootApplyElementDTO, doc);
            }
        } else if (applyElementDTOs.size() == 1) {
            applyElement = PolicyUtils.createApplyElement((ApplyElementDTO)applyElementDTOs.get(0), doc);
        }
        if (resourcesElement != null || actionsElement != null || subjectsElement != null || environmentsElement != null) {
            targetElement = doc.createElement("Target");
            if (resourcesElement != null) {
                targetElement.appendChild(resourcesElement);
            }
            if (actionsElement != null) {
                targetElement.appendChild(actionsElement);
            }
            if (subjectsElement != null) {
                targetElement.appendChild(subjectsElement);
            }
            if (environmentsElement != null) {
                targetElement.appendChild(environmentsElement);
            }
        }
        if (applyElement != null) {
            conditionElement = doc.createElement("Condition");
            conditionElement.appendChild(applyElement);
        }
        if (basicRuleDTO.getRuleId() != null && basicRuleDTO.getRuleId().trim().length() > 0 && basicRuleDTO.getRuleEffect() != null && basicRuleDTO.getRuleEffect().trim().length() > 0) {
            ruleElement = doc.createElement("Rule");
            ruleElement.setAttribute("RuleId", basicRuleDTO.getRuleId());
            ruleElement.setAttribute("Effect", basicRuleDTO.getRuleEffect());
            if (basicRuleDTO.getRuleDescription() != null && basicRuleDTO.getRuleDescription().trim().length() > 0) {
                ruleElement.setAttribute("Description", basicRuleDTO.getRuleDescription());
            }
            if (targetElement != null) {
                ruleElement.appendChild(targetElement);
            }
            if (conditionElement != null) {
                ruleElement.appendChild(conditionElement);
            }
        }
        return ruleElement;
    }

    public static Element createTargetElement(BasicTargetDTO basicTargetDTO, Document doc) throws PolicyBuilderException {
        Element matchElement;
        MatchElementDTO matchElementDTO;
        Element matchElement2;
        MatchElementDTO matchElementDTO2;
        int n;
        Element matchElement32;
        Object matchElementDTO3;
        String functionOnResources = basicTargetDTO.getFunctionOnResources();
        String functionOnSubjects = basicTargetDTO.getFunctionOnSubjects();
        String functionOnActions = basicTargetDTO.getFunctionOnActions();
        String functionOnEnvironment = basicTargetDTO.getFunctionOnEnvironment();
        String resourceNames = basicTargetDTO.getResourceList();
        String actionNames = basicTargetDTO.getActionList();
        String subjectNames = basicTargetDTO.getSubjectList();
        String environmentNames = basicTargetDTO.getEnvironmentList();
        String resourceId = basicTargetDTO.getResourceId();
        String subjectId = basicTargetDTO.getSubjectId();
        String actionId = basicTargetDTO.getActionId();
        String environmentId = basicTargetDTO.getEnvironmentId();
        String resourceDataType = basicTargetDTO.getResourceDataType();
        String subjectDataType = basicTargetDTO.getSubjectDataType();
        String actionDataType = basicTargetDTO.getActionDataType();
        String environmentDataType = basicTargetDTO.getEnvironmentDataType();
        Element resourcesElement = null;
        Element actionsElement = null;
        Element subjectsElement = null;
        Element environmentsElement = null;
        Element targetElement = doc.createElement("Target");
        if (resourceNames != null && resourceNames.trim().length() > 0) {
            Element resourceEle;
            String resource;
            resourcesElement = doc.createElement("AnyOf");
            Element resourceElement = doc.createElement("AllOf");
            String[] resources = resourceNames.split(",");
            if (resourceId == null || resourceId.trim().length() < 1) {
                resourceId = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
            }
            if (functionOnResources.equals("equal") || functionOnResources.equals("regexp-match")) {
                matchElementDTO3 = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnResources, resources[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                matchElement32 = PolicyUtils.createMatchElement((MatchElementDTO)matchElementDTO3, doc);
                if (matchElement32 != null) {
                    resourceElement.appendChild(matchElement32);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (functionOnResources.equals("at-least-one-member-of")) {
                matchElementDTO3 = resources;
                int matchElement32 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement32; ++n) {
                    resource = matchElementDTO3[n];
                    resource = resource.trim();
                    resourceEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", resource, "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        resourceEle.appendChild(matchElement2);
                    }
                    resourcesElement.appendChild(resourceEle);
                }
            } else if (functionOnResources.equals("at-least-one-matching-regexp-member-of")) {
                matchElementDTO3 = resources;
                int matchElement32 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement32; ++n) {
                    resource = matchElementDTO3[n];
                    resource = resource.trim();
                    resourceEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", resource, "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        resourceEle.appendChild(matchElement2);
                    }
                    resourcesElement.appendChild(resourceEle);
                }
            } else if (functionOnResources.equals("set-equals")) {
                matchElementDTO3 = resources;
                int matchElement32 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement32; ++n) {
                    resource = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", resource = resource.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            } else if (functionOnResources.equals("set-equals-matching-regexp")) {
                matchElementDTO3 = resources;
                int matchElement32 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement32; ++n) {
                    resource = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", resource = resource.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", resourceId, resourceDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    resourceElement.appendChild(matchElement);
                }
                resourcesElement.appendChild(resourceElement);
            }
        }
        if (actionNames != null && actionNames.trim().length() > 0) {
            Element actionEle;
            String action;
            actionsElement = doc.createElement("AnyOf");
            Element actionElement = doc.createElement("AllOf");
            String[] actions = actionNames.split(",");
            if (actionId == null || actionId.trim().length() < 1) {
                actionId = "urn:oasis:names:tc:xacml:1.0:action:action-id";
            }
            if (functionOnActions.equals("equal") || functionOnActions.equals("regexp-match")) {
                matchElementDTO3 = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnActions, actions[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                matchElement32 = PolicyUtils.createMatchElement((MatchElementDTO)matchElementDTO3, doc);
                if (matchElement32 != null) {
                    actionElement.appendChild(matchElement32);
                }
                actionsElement.appendChild(actionElement);
            } else if (functionOnActions.equals("at-least-one-member-of")) {
                matchElementDTO3 = actions;
                int matchElement4 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement4; ++n) {
                    action = matchElementDTO3[n];
                    action = action.trim();
                    actionEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", action, "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        actionEle.appendChild(matchElement2);
                    }
                    actionsElement.appendChild(actionEle);
                }
            } else if (functionOnActions.equals("at-least-one-matching-regexp-member-of")) {
                matchElementDTO3 = actions;
                int matchElement4 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement4; ++n) {
                    action = matchElementDTO3[n];
                    action = action.trim();
                    actionEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", action, "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        actionEle.appendChild(matchElement2);
                    }
                    actionsElement.appendChild(actionEle);
                }
            } else if (functionOnActions.equals("set-equals-matching-regexp")) {
                matchElementDTO3 = actions;
                int matchElement4 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement4; ++n) {
                    action = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", action = action.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            } else if (functionOnActions.equals("set-equals")) {
                matchElementDTO3 = actions;
                int matchElement4 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement4; ++n) {
                    action = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", action = action.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:action", actionId, actionDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    actionElement.appendChild(matchElement);
                }
                actionsElement.appendChild(actionElement);
            }
        }
        if (environmentNames != null && environmentNames.trim().length() > 0) {
            Element environmentEle;
            String environment;
            environmentsElement = doc.createElement("AnyOf");
            Element environmentElement = doc.createElement("AllOf");
            String[] environments = environmentNames.split(",");
            if (environmentId == null || environmentId.trim().length() < 1) {
                environmentId = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
            }
            if (functionOnEnvironment.equals("equal") || functionOnEnvironment.equals("regexp-match")) {
                matchElementDTO3 = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnEnvironment, environments[0].trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                Element matchElement5 = PolicyUtils.createMatchElement((MatchElementDTO)matchElementDTO3, doc);
                if (matchElement5 != null) {
                    environmentElement.appendChild(matchElement5);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (functionOnEnvironment.equals("at-least-one-member-of")) {
                matchElementDTO3 = environments;
                int matchElement5 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement5; ++n) {
                    environment = matchElementDTO3[n];
                    environment = environment.trim();
                    environmentEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", environment, "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        environmentEle.appendChild(matchElement2);
                    }
                    environmentsElement.appendChild(environmentEle);
                }
            } else if (functionOnEnvironment.equals("at-least-one-matching-regexp-member-of")) {
                matchElementDTO3 = environments;
                int matchElement5 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement5; ++n) {
                    environment = matchElementDTO3[n];
                    environment = environment.trim();
                    environmentEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", environment, "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        environmentEle.appendChild(matchElement2);
                    }
                    environmentsElement.appendChild(environmentEle);
                }
            } else if (functionOnEnvironment.equals("set-equals-matching-regexp")) {
                matchElementDTO3 = environments;
                int matchElement5 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement5; ++n) {
                    environment = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", environment = environment.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            } else if (functionOnEnvironment.equals("set-equals")) {
                matchElementDTO3 = environments;
                int matchElement5 = ((String[])matchElementDTO3).length;
                for (n = 0; n < matchElement5; ++n) {
                    environment = matchElementDTO3[n];
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", environment = environment.trim(), "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", environmentId, environmentDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    environmentElement.appendChild(matchElement);
                }
                environmentsElement.appendChild(environmentElement);
            }
        }
        if (subjectNames != null && subjectNames.trim().length() > 0) {
            Element subjectEle;
            subjectsElement = doc.createElement("AnyOf");
            Element subjectElement = doc.createElement("AllOf");
            String[] subjects = subjectNames.split(",");
            if (subjectId == null || subjectId.trim().length() < 1) {
                subjectId = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
            }
            if ("equal".equals(functionOnSubjects) || "regexp-match".equals(functionOnSubjects)) {
                matchElementDTO3 = BasicPolicyHelper.createMatchElementForNonBagFunctions(functionOnSubjects, subjects[0].trim(), "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType);
                Element matchElement6 = PolicyUtils.createMatchElement((MatchElementDTO)matchElementDTO3, doc);
                if (matchElement6 != null) {
                    subjectElement.appendChild(matchElement6);
                }
                subjectsElement.appendChild(subjectElement);
            } else if ("at-least-one-member-of".equals(functionOnSubjects)) {
                for (String subject : subjects) {
                    subject = subject.trim();
                    subjectEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", subject, "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        subjectEle.appendChild(matchElement2);
                    }
                    subjectsElement.appendChild(subjectEle);
                }
            } else if ("at-least-one-matching-regexp-member-of".equals(functionOnSubjects)) {
                for (String subject : subjects) {
                    subject = subject.trim();
                    subjectEle = doc.createElement("AllOf");
                    matchElementDTO2 = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", subject, "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType);
                    matchElement2 = PolicyUtils.createMatchElement(matchElementDTO2, doc);
                    if (matchElement2 != null) {
                        subjectEle.appendChild(matchElement2);
                    }
                    subjectsElement.appendChild(subjectEle);
                }
            } else if ("set-equals".equals(functionOnSubjects)) {
                for (String subject : subjects) {
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("equal", subject = subject.trim(), "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    subjectElement.appendChild(matchElement);
                }
                subjectsElement.appendChild(subjectElement);
            } else if ("set-equals-matching-regexp".equals(functionOnSubjects)) {
                for (String subject : subjects) {
                    matchElementDTO = BasicPolicyHelper.createMatchElementForNonBagFunctions("regexp-match", subject = subject.trim(), "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", subjectId, subjectDataType);
                    matchElement = PolicyUtils.createMatchElement(matchElementDTO, doc);
                    if (matchElement == null) continue;
                    subjectElement.appendChild(matchElement);
                }
                subjectsElement.appendChild(subjectElement);
            }
        }
        if (resourcesElement != null) {
            targetElement.appendChild(resourcesElement);
        }
        if (actionsElement != null) {
            targetElement.appendChild(actionsElement);
        }
        if (subjectsElement != null) {
            targetElement.appendChild(subjectsElement);
        }
        if (environmentsElement != null) {
            targetElement.appendChild(environmentsElement);
        }
        return targetElement;
    }

    public static ApplyElementDTO createApplyElementForBagFunctions(String functionId, String category, String attributeId, String[] attributeValues, String dataType) {
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        functionId = BasicPolicyHelper.processFunction(functionId, dataType);
        if (attributeValues != null && functionId != null && functionId.trim().length() > 0 && category != null && category.trim().length() > 0 && attributeId != null && attributeId.trim().length() > 0) {
            ApplyElementDTO applyElementDTOBag = new ApplyElementDTO();
            for (String attributeValue : attributeValues) {
                attributeValue = attributeValue.trim();
                AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
                if (dataType != null && dataType.trim().length() > 0) {
                    attributeValueElementDTO.setAttributeDataType(dataType);
                } else {
                    attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                }
                attributeValueElementDTO.setAttributeValue(attributeValue.trim());
                applyElementDTOBag.setAttributeValueElementDTO(attributeValueElementDTO);
            }
            applyElementDTOBag.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:string-bag");
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeDesignatorDTO.setDataType(dataType);
            } else {
                attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeDesignatorDTO.setAttributeId(attributeId);
            attributeDesignatorDTO.setCategory(category);
            applyElementDTO.setApplyElement(applyElementDTOBag);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId(functionId);
        }
        return applyElementDTO;
    }

    public static ApplyElementDTO createApplyElementForNonBagFunctions(String functionId, String category, String attributeId, String attributeValue, String dataType) {
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        functionId = BasicPolicyHelper.processFunction(functionId, dataType);
        if (attributeValue != null && attributeValue.trim().length() > 0 && functionId != null && functionId.trim().length() > 0 && category != null && category.trim().length() > 0 && attributeId != null && attributeId.trim().length() > 0) {
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeValueElementDTO.setAttributeDataType(dataType);
            } else {
                attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeDesignatorDTO.setDataType(dataType);
            } else {
                attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeDesignatorDTO.setAttributeId(attributeId);
            attributeDesignatorDTO.setCategory(category);
            applyElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId(functionId);
        }
        return applyElementDTO;
    }

    public static ApplyElementDTO createApplyElementForNonBagFunctionsWithAnyOf(String functionId, String category, String attributeDesignatorId, String dataType, String attributeValue) {
        ApplyElementDTO applyElementDTO = null;
        functionId = BasicPolicyHelper.processFunction(functionId, dataType);
        if (attributeValue != null && attributeValue.trim().length() > 0 && functionId != null && functionId.trim().length() > 0 && category != null && category.trim().length() > 0 && attributeDesignatorId != null && attributeDesignatorId.trim().length() > 0) {
            applyElementDTO = new ApplyElementDTO();
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            if (dataType != null && dataType.trim().length() > 0) {
                attributeValueElementDTO.setAttributeDataType(dataType);
            } else {
                attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeDesignatorDTO.setDataType(dataType);
            } else {
                attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeDesignatorDTO.setAttributeId(attributeDesignatorId);
            attributeDesignatorDTO.setCategory(category);
            applyElementDTO.setFunctionFunctionId(functionId);
            applyElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            applyElementDTO.setAttributeDesignators(attributeDesignatorDTO);
            applyElementDTO.setFunctionId("urn:oasis:names:tc:xacml:1.0:function:any-of");
        }
        return applyElementDTO;
    }

    public static MatchElementDTO createMatchElementForNonBagFunctions(String functionId, String attributeValue, String category, String attributeId, String dataType) {
        MatchElementDTO matchElementDTO = new MatchElementDTO();
        if ((functionId = BasicPolicyHelper.processFunction(functionId, dataType)) != null && functionId.trim().length() > 0 && attributeValue != null && attributeValue.trim().length() > 0 && category != null && category.trim().length() > 0 && attributeId != null && attributeId.trim().length() > 0) {
            AttributeValueElementDTO attributeValueElementDTO = new AttributeValueElementDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeValueElementDTO.setAttributeDataType(dataType);
            } else {
                attributeValueElementDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeValueElementDTO.setAttributeValue(attributeValue.trim());
            AttributeDesignatorDTO attributeDesignatorDTO = new AttributeDesignatorDTO();
            if (dataType != null && dataType.trim().length() > 0) {
                attributeDesignatorDTO.setDataType(dataType);
            } else {
                attributeDesignatorDTO.setDataType("http://www.w3.org/2001/XMLSchema#string");
            }
            attributeDesignatorDTO.setAttributeId(attributeId);
            attributeDesignatorDTO.setCategory(category);
            matchElementDTO.setMatchId(functionId);
            matchElementDTO.setAttributeValueElementDTO(attributeValueElementDTO);
            matchElementDTO.setAttributeDesignatorDTO(attributeDesignatorDTO);
        }
        return matchElementDTO;
    }

    public static ApplyElementDTO processGreaterLessThanFunctions(String function, String dataType, String attributeValue, AttributeDesignatorDTO designatorDTO) throws PolicyBuilderException {
        String[] values = attributeValue.split(",");
        if ("greater-than-or-equal-and-less-than-or-equal".equals(function) || "greater-than-and-less-than-or-equal".equals(function) || "greater-than-or-equal-and-less-than".equals(function) || "greater-than-and-less-than".equals(function)) {
            if (values.length != 2) {
                throw new PolicyBuilderException("Can not create Apply element:Missing required attribute values for function : " + function);
            }
            String leftValue = values[0].trim();
            String rightValue = values[1].trim();
            ApplyElementDTO andApplyElement = new ApplyElementDTO();
            andApplyElement.setFunctionId(BasicPolicyHelper.processFunction("and"));
            ApplyElementDTO greaterThanApplyElement = new ApplyElementDTO();
            if ("greater-than-and-less-than".equals(function) || "greater-than-and-less-than-or-equal".equals(function)) {
                greaterThanApplyElement.setFunctionId(BasicPolicyHelper.processFunction("greater-than", dataType));
            } else {
                greaterThanApplyElement.setFunctionId(BasicPolicyHelper.processFunction("greater-than-or-equal", dataType));
            }
            ApplyElementDTO lessThanApplyElement = new ApplyElementDTO();
            if ("greater-than-and-less-than".equals(function) || "greater-than-or-equal-and-less-than".equals(function)) {
                lessThanApplyElement.setFunctionId(BasicPolicyHelper.processFunction("less-than", dataType));
            } else {
                lessThanApplyElement.setFunctionId(BasicPolicyHelper.processFunction("less-than-or-equal", dataType));
            }
            ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
            oneAndOnlyApplyElement.setFunctionId(BasicPolicyHelper.processFunction("one-and-only", dataType));
            oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
            AttributeValueElementDTO leftValueElementDTO = new AttributeValueElementDTO();
            leftValueElementDTO.setAttributeDataType(dataType);
            leftValueElementDTO.setAttributeValue(leftValue);
            AttributeValueElementDTO rightValueElementDTO = new AttributeValueElementDTO();
            rightValueElementDTO.setAttributeDataType(dataType);
            rightValueElementDTO.setAttributeValue(rightValue);
            greaterThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            greaterThanApplyElement.setAttributeValueElementDTO(leftValueElementDTO);
            lessThanApplyElement.setApplyElement(oneAndOnlyApplyElement);
            lessThanApplyElement.setAttributeValueElementDTO(rightValueElementDTO);
            andApplyElement.setApplyElement(greaterThanApplyElement);
            andApplyElement.setApplyElement(lessThanApplyElement);
            return andApplyElement;
        }
        ApplyElementDTO applyElementDTO = new ApplyElementDTO();
        if ("greater-than".equals(function)) {
            applyElementDTO.setFunctionId(BasicPolicyHelper.processFunction("greater-than", dataType));
        } else if ("greater-than-or-equal".equals(function)) {
            applyElementDTO.setFunctionId(BasicPolicyHelper.processFunction("greater-than-or-equal", dataType));
        } else if ("less-than".equals(function)) {
            applyElementDTO.setFunctionId(BasicPolicyHelper.processFunction("less-than", dataType));
        } else if ("less-than-or-equal".equals(function)) {
            applyElementDTO.setFunctionId(BasicPolicyHelper.processFunction("less-than-or-equal", dataType));
        } else {
            throw new PolicyBuilderException("Can not create Apply element:Invalid function : " + function);
        }
        ApplyElementDTO oneAndOnlyApplyElement = new ApplyElementDTO();
        oneAndOnlyApplyElement.setFunctionId(BasicPolicyHelper.processFunction("one-and-only", dataType));
        oneAndOnlyApplyElement.setAttributeDesignators(designatorDTO);
        AttributeValueElementDTO valueElementDTO = new AttributeValueElementDTO();
        valueElementDTO.setAttributeDataType(dataType);
        valueElementDTO.setAttributeValue(values[0]);
        applyElementDTO.setApplyElement(oneAndOnlyApplyElement);
        applyElementDTO.setAttributeValueElementDTO(valueElementDTO);
        return applyElementDTO;
    }

    private static String processFunction(String function, String type, String version) {
        return "urn:oasis:names:tc:xacml:" + version + ":function:" + BasicPolicyHelper.getDataTypePrefix(type) + "-" + function;
    }

    private static String processFunction(String function) {
        return "urn:oasis:names:tc:xacml:1.0:function:" + function;
    }

    private static String processFunction(String function, String type) {
        if (type == null || type.trim().length() == 0) {
            type = "http://www.w3.org/2001/XMLSchema#string";
        }
        return "urn:oasis:names:tc:xacml:1.0:function:" + BasicPolicyHelper.getDataTypePrefix(type) + "-" + function;
    }

    private static String getDataTypePrefix(String dataTypeUri) {
        if (dataTypeUri != null) {
            String[] stringArray;
            if (dataTypeUri.contains("#")) {
                return dataTypeUri.substring(dataTypeUri.indexOf("#") + 1);
            }
            if (dataTypeUri.contains(":") && (stringArray = dataTypeUri.split(":")) != null && stringArray.length > 0) {
                return stringArray[stringArray.length - 1];
            }
        }
        return dataTypeUri;
    }
}

