/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.balana.utils.policy;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.balana.utils.PolicyUtils;
import org.wso2.balana.utils.Utils;
import org.wso2.balana.utils.exception.PolicyBuilderException;
import org.wso2.balana.utils.policy.BasicPolicyHelper;
import org.wso2.balana.utils.policy.dto.BasicPolicyDTO;
import org.wso2.balana.utils.policy.dto.PolicyElementDTO;
import org.wso2.balana.utils.policy.dto.PolicySetElementDTO;
import org.wso2.balana.utils.policy.dto.RequestElementDTO;

public class PolicyBuilder {
    private static final Object lock = new Object();
    private static PolicyBuilder policyBuilder;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyBuilder getInstance() {
        if (policyBuilder == null) {
            Object object = lock;
            synchronized (object) {
                if (policyBuilder == null) {
                    policyBuilder = new PolicyBuilder();
                }
            }
        }
        return policyBuilder;
    }

    private PolicyBuilder() {
    }

    public String build(BasicPolicyDTO basicPolicyDTO) throws PolicyBuilderException {
        Document doc = null;
        try {
            doc = Utils.createNewDocument();
        }
        catch (ParserConfigurationException e) {
            throw new PolicyBuilderException("While creating Document Object", e);
        }
        if (doc != null) {
            doc.appendChild(BasicPolicyHelper.createPolicyElement(basicPolicyDTO, doc));
            try {
                return Utils.getStringFromDocument(doc);
            }
            catch (TransformerException e) {
                throw new PolicyBuilderException("Error while converting Policy element to String", e);
            }
        }
        return null;
    }

    public String build(PolicyElementDTO policyElementDTO) throws PolicyBuilderException {
        Document doc = null;
        try {
            doc = Utils.createNewDocument();
        }
        catch (ParserConfigurationException e) {
            throw new PolicyBuilderException("While creating Document Object", e);
        }
        if (doc != null) {
            doc.appendChild(PolicyUtils.createPolicyElement(policyElementDTO, doc));
            try {
                return Utils.getStringFromDocument(doc);
            }
            catch (TransformerException e) {
                throw new PolicyBuilderException("Error while converting Policy element to String", e);
            }
        }
        return null;
    }

    public String build(PolicySetElementDTO policyElementDTO) throws PolicyBuilderException {
        Document doc = null;
        try {
            doc = Utils.createNewDocument();
        }
        catch (ParserConfigurationException e) {
            throw new PolicyBuilderException("While creating Document Object", e);
        }
        if (doc != null) {
            doc.appendChild(PolicyUtils.createPolicySetElement(policyElementDTO, doc));
            try {
                return Utils.getStringFromDocument(doc);
            }
            catch (TransformerException e) {
                throw new PolicyBuilderException("Error while converting Policy element to String", e);
            }
        }
        return null;
    }

    public String buildRequest(RequestElementDTO requestElementDTO) throws PolicyBuilderException {
        Document doc = null;
        try {
            doc = Utils.createNewDocument();
        }
        catch (ParserConfigurationException e) {
            throw new PolicyBuilderException("While creating Document Object", e);
        }
        if (doc != null) {
            doc.appendChild(PolicyUtils.createRequestElement(requestElementDTO, doc));
            try {
                return Utils.getStringFromDocument(doc);
            }
            catch (TransformerException e) {
                throw new PolicyBuilderException("Error while converting request element to String", e);
            }
        }
        return null;
    }

    public String[] getFunctions() {
        return new String[0];
    }

    public String[] getRuleAlgorithms() {
        return new String[0];
    }

    public String[] getPolicyAlgorithms() {
        return new String[0];
    }

    public String[] getDataTypes() {
        return new String[0];
    }

    static {
        log = LogFactory.getLog(PolicyBuilder.class);
    }
}

