/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobObject;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.JacobThread;
import org.apache.ode.jacob.Synch;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.soup.CommGroup;
import org.apache.ode.jacob.soup.CommRecv;
import org.apache.ode.jacob.soup.CommSend;
import org.apache.ode.jacob.soup.Continuation;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.vpu.ChannelFactory;
import org.apache.ode.jacob.vpu.JacobMessages;
import org.apache.ode.jacob.vpu.Statistics;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.msg.MessageBundle;

public final class JacobVPU {
    private static final Log __log = LogFactory.getLog(JacobVPU.class);
    private static final JacobMessages __msgs = (JacobMessages)MessageBundle.getMessages(JacobMessages.class);
    static final ThreadLocal<Stack<JacobThread>> __activeJacobThread = new ThreadLocal();
    private static final Method REDUCE_METHOD;
    private ExecutionQueue _executionQueue;
    private Map<Class, Object> _extensions = new HashMap<Class, Object>();
    private ClassLoader _classLoader = this.getClass().getClassLoader();
    private int _cycle;
    private Statistics _statistics = new Statistics();
    private RuntimeException _fault;

    public JacobVPU() {
    }

    public JacobVPU(ExecutionQueue executionQueue) {
        this.setContext(executionQueue);
    }

    public JacobVPU(ExecutionQueue context, JacobRunnable concretion) {
        this.setContext(context);
        this.inject(concretion);
    }

    public boolean execute() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"execute", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        if (this._executionQueue == null) {
            throw new IllegalStateException("No state object for VPU!");
        }
        if (this._fault != null) {
            throw this._fault;
        }
        if (!this._executionQueue.hasReactions()) {
            return false;
        }
        this._cycle = this._executionQueue.cycle();
        Continuation rqe = this._executionQueue.dequeueReaction();
        JacobThreadImpl jt = new JacobThreadImpl(rqe);
        long ctime = System.currentTimeMillis();
        try {
            jt.run();
        }
        catch (RuntimeException re) {
            this._fault = re;
            throw re;
        }
        long rtime = System.currentTimeMillis() - ctime;
        ++this._statistics.numCycles;
        this._statistics.totalRunTimeMs += rtime;
        this._statistics.incRunTime(jt._targetStr, rtime);
        return true;
    }

    public void flush() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"flush", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        this._executionQueue.flush();
    }

    public void setContext(ExecutionQueue executionQueue) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"setContext", (Object[])new Object[]{"executionQueue", executionQueue}));
        }
        this._executionQueue = executionQueue;
        this._executionQueue.setClassLoader(this._classLoader);
    }

    public void registerExtension(Class extensionClass, Object obj) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"registerExtension", (Object[])new Object[]{"extensionClass", extensionClass, "obj", obj}));
        }
        this._extensions.put(extensionClass, obj);
    }

    public void addReaction(JacobObject jo, Method method, Object[] args, String desc) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"addReaction", (Object[])new Object[]{"jo", jo, "method", method, "args", args, "desc", desc}));
        }
        Continuation continuation = new Continuation(jo, method, args);
        continuation.setDescription(desc);
        this._executionQueue.enqueueReaction(continuation);
        ++this._statistics.runQueueEntries;
    }

    public static JacobThread activeJacobThread() {
        return __activeJacobThread.get().peek();
    }

    public void inject(JacobRunnable concretion) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("injecting " + concretion));
        }
        this.addReaction(concretion, REDUCE_METHOD, CollectionUtils.EMPTY_OBJECT_ARRAY, __log.isInfoEnabled() ? concretion.toString() : null);
    }

    static String stringifyMethods(Class kind) {
        StringBuffer buf = new StringBuffer();
        Method[] methods = kind.getMethods();
        boolean found = false;
        for (Method method : methods) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (found) {
                buf.append(" & ");
            }
            buf.append(method.getName()).append('(');
            Class<?>[] argTypes = method.getParameterTypes();
            for (int j = 0; j < argTypes.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(argTypes[j].getName());
            }
            buf.append(") {...}");
            found = true;
        }
        return buf.toString();
    }

    static String stringify(Object[] list) {
        if (list == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(list[i]);
        }
        return buf.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        if (this._executionQueue != null) {
            this._executionQueue.setClassLoader(classLoader);
        }
    }

    public void dumpState() {
        this._statistics.printToStream(System.err);
        this._executionQueue.dumpState(System.err);
    }

    public boolean isComplete() {
        return this._executionQueue.isComplete();
    }

    static {
        try {
            REDUCE_METHOD = JacobRunnable.class.getMethod("run", CollectionUtils.EMPTY_CLASS_ARRAY);
        }
        catch (Exception e) {
            throw new Error("Cannot resolve 'run' method", e);
        }
    }

    private class JacobThreadImpl
    implements Runnable,
    JacobThread {
        private final JacobObject _methodBody;
        private final Object[] _args;
        private final Method _method;
        private String _source;
        private String _targetStr = "Unknown";

        JacobThreadImpl(Continuation rqe) {
            assert (rqe != null);
            this._methodBody = rqe.getClosure();
            this._args = rqe.getArgs();
            this._source = rqe.getDescription();
            this._method = rqe.getMethod();
            if (__log.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer(this._methodBody.getClass().getName());
                buf.append('.');
                buf.append(rqe.getMethod());
                this._targetStr = buf.toString();
            }
        }

        @Override
        public void instance(JacobRunnable template) {
            String desc = null;
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + template));
                desc = template.toString();
            }
            ++((JacobVPU)JacobVPU.this)._statistics.numReductionsStruct;
            JacobVPU.this.addReaction(template, REDUCE_METHOD, CollectionUtils.EMPTY_OBJECT_ARRAY, desc);
        }

        @Override
        public Channel message(Channel channel, Method method, Object[] args) {
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + channel + " ! " + method.getName() + "(" + JacobVPU.stringify(args) + ")"));
            }
            ++((JacobVPU)JacobVPU.this)._statistics.messagesSent;
            SynchChannel replyChannel = null;
            if (method.getReturnType() != Void.TYPE) {
                if (method.getReturnType() != SynchChannel.class) {
                    throw new IllegalStateException("ChannelListener method can only return SynchChannel: " + method);
                }
                replyChannel = (SynchChannel)this.newChannel(SynchChannel.class, "", "Reply Channel");
                Object[] newArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = replyChannel;
                args = newArgs;
            }
            CommChannel chnl = (CommChannel)ChannelFactory.getBackend(channel);
            CommGroup grp = new CommGroup(false);
            CommSend send = new CommSend(chnl, method, args);
            grp.add(send);
            JacobVPU.this._executionQueue.add(grp);
            return replyChannel;
        }

        @Override
        public Channel newChannel(Class channelType, String creator, String description) {
            CommChannel chnl = new CommChannel(channelType);
            chnl.setDescription(description);
            JacobVPU.this._executionQueue.add(chnl);
            Channel ret = ChannelFactory.createChannel(chnl, channelType);
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": new " + ret));
            }
            ++((JacobVPU)JacobVPU.this)._statistics.channelsCreated;
            return ret;
        }

        @Override
        public String exportChannel(Channel channel) {
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": export<" + channel + ">"));
            }
            CommChannel chnl = (CommChannel)ChannelFactory.getBackend(channel);
            return JacobVPU.this._executionQueue.createExport(chnl);
        }

        @Override
        public Channel importChannel(String channelId, Class channelType) {
            CommChannel cframe = JacobVPU.this._executionQueue.consumeExport(channelId);
            return ChannelFactory.createChannel(cframe, channelType);
        }

        @Override
        public void object(boolean replicate, ChannelListener[] ml) {
            int i;
            if (__log.isTraceEnabled()) {
                StringBuffer msg = new StringBuffer();
                msg.append(JacobVPU.this._cycle);
                msg.append(": ");
                for (i = 0; i < ml.length; ++i) {
                    if (i != 0) {
                        msg.append(" + ");
                    }
                    msg.append(ml[i].getChannel());
                    msg.append(" ? ");
                    msg.append(ml.toString());
                }
                __log.debug((Object)msg.toString());
            }
            ++((JacobVPU)JacobVPU.this)._statistics.numContinuations;
            CommGroup grp = new CommGroup(replicate);
            for (i = 0; i < ml.length; ++i) {
                CommChannel chnl = (CommChannel)ChannelFactory.getBackend(ml[i].getChannel());
                CommRecv recv = new CommRecv(chnl, ml[i]);
                grp.add(recv);
            }
            JacobVPU.this._executionQueue.add(grp);
        }

        @Override
        public void object(boolean replicate, ChannelListener methodList) throws IllegalArgumentException {
            this.object(replicate, new ChannelListener[]{methodList});
        }

        @Override
        public Object getExtension(Class extensionClass) {
            return JacobVPU.this._extensions.get(extensionClass);
        }

        @Override
        public void run() {
            Synch synchChannel;
            Object[] args;
            assert (this._methodBody != null);
            assert (this._method != null);
            assert (this._method.getDeclaringClass().isAssignableFrom(this._methodBody.getClass()));
            if (__log.isTraceEnabled()) {
                __log.trace((Object)(JacobVPU.this._cycle + ": " + this._source));
            }
            if (this._method.getReturnType() != Void.TYPE) {
                args = new Object[this._args.length - 1];
                System.arraycopy(this._args, 0, args, 0, args.length);
                synchChannel = (SynchChannel)this._args[args.length];
            } else {
                args = this._args;
                synchChannel = null;
            }
            this.stackThread();
            long ctime = System.currentTimeMillis();
            try {
                this._method.invoke((Object)this._methodBody, args);
                if (synchChannel != null) {
                    synchChannel.ret();
                }
            }
            catch (IllegalAccessException iae) {
                String msg = __msgs.msgMethodNotAccessible(this._method.getName(), this._method.getDeclaringClass().getName());
                __log.error((Object)msg, (Throwable)iae);
                throw new RuntimeException(msg, iae);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                String msg = __msgs.msgClientMethodException(this._method.getName(), this._methodBody.getClass().getName());
                __log.error((Object)msg, e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
            finally {
                ctime = System.currentTimeMillis() - ctime;
                ((JacobVPU)JacobVPU.this)._statistics.totalClientTimeMs += ctime;
                this.unstackThread();
            }
        }

        public String toString() {
            return "PT[ " + this._methodBody + " ]";
        }

        private void stackThread() {
            Stack<JacobThread> currStack = __activeJacobThread.get();
            if (currStack == null) {
                currStack = new Stack();
                __activeJacobThread.set(currStack);
            }
            currStack.push(this);
        }

        private JacobThread unstackThread() {
            Stack<JacobThread> currStack = __activeJacobThread.get();
            assert (currStack != null);
            return currStack.pop();
        }
    }
}

