/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools.bpelc.cline;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.tools.ClineCommandContext;
import org.apache.ode.tools.ExecutionException;
import org.apache.ode.tools.bpelc.BpelCompileCommand;
import org.apache.ode.utils.cli.BaseCommandlineTool;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.ConsoleFormatter;
import org.apache.ode.utils.cli.FlagWithArgument;
import org.apache.ode.utils.cli.Fragments;
import org.apache.ode.utils.cli.MultiArgument;

public class BpelC
extends BaseCommandlineTool {
    private static final Log __log = LogFactory.getLog(BpelC.class);
    private static FlagWithArgument OUTPUT_DIR = new FlagWithArgument("od", "directory", "output directory", true);
    private static FlagWithArgument ROOT_WSDL = new FlagWithArgument("wsdl", "uri", "URI of the WSDL for the process (used with BPEL4WS 1.1 processes, for WS-BPEL 2.0 processes, use <import>).", true);
    private static MultiArgument BPEL_URLS = new MultiArgument("bpelurl", "the URLs of BPEL processes to compile.", false);
    private static Fragments DEFAULT = new Fragments(new CommandlineFragment[]{LOGGING, ROOT_WSDL, OUTPUT_DIR, BPEL_URLS});
    private static final String SYNOPSIS = "compile one or more BPEL processes";

    protected static String getProgramName() {
        return "bpelc";
    }

    public static void main(String[] args) {
        String[] b;
        BpelC.setClazz(BpelC.class);
        if (args.length == 0 || HELP.matches(args)) {
            ConsoleFormatter.printSynopsis((String)BpelC.getProgramName(), (String)SYNOPSIS, (Fragments[])new Fragments[]{DEFAULT, HELP});
            System.exit(0);
        }
        if (!DEFAULT.matches(args)) {
            BpelC.consoleErr((String)("INVALID COMMANDLINE: Try \"" + BpelC.getProgramName() + " -h\" for help."));
            System.exit(-1);
        }
        BpelC.initLogging();
        BpelCompileCommand bcc = new BpelCompileCommand();
        if (OUTPUT_DIR.isSet()) {
            String outputDir = OUTPUT_DIR.getValue();
            String[] od = new File(outputDir);
            if (!od.exists() || !od.isDirectory()) {
                BpelC.consoleErr((String)(outputDir + ": no such directory or not writable."));
                System.exit(-1);
            }
            bcc.setOuputDirectory((File)od);
        }
        if (ROOT_WSDL.isSet()) {
            bcc.setWsdlImportUri(ROOT_WSDL.getValue());
        }
        if ((b = BPEL_URLS.getValues()) == null || b.length == 0) {
            BpelC.consoleErr((String)"At least one process must be specified.");
            System.exit(-1);
        }
        for (String aB : b) {
            bcc.addBpelProcessUrl(aB);
        }
        try {
            bcc.execute(new ClineCommandContext(__log));
        }
        catch (ExecutionException ee) {
            BpelC.consoleErr((String)ee.getMessage());
            System.exit(-1);
        }
        catch (Throwable t) {
            BpelC.consoleErr((String)t.getMessage());
            t.printStackTrace();
            System.exit(-2);
        }
        System.exit(0);
    }
}

