/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.datasource.sample;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jndi.JNDIContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.datasource.core.api.DataSourceManagementService;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

@Component(name="org.wso2.carbon.kernel.datasource.sample", immediate=true)
public class DataSourceServiceListenerComponent {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceServiceListenerComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="org.wso2.carbon.datasource.DataSourceService", service=DataSourceService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceService")
    protected void onDataSourceServiceReady(DataSourceService service) {
        Connection connection = null;
        try {
            HikariDataSource dsObject = (HikariDataSource)service.getDataSource("WSO2_CARBON_DB");
            connection = dsObject.getConnection();
            logger.info("Database Major Version {}", (Object)connection.getMetaData().getDatabaseMajorVersion());
        }
        catch (DataSourceException e) {
            logger.error("error occurred while fetching the data source.", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("error occurred while fetching the connection.", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error("error occurred while closing the connection.", (Throwable)e);
                }
            }
        }
    }

    @Reference(name="org.wso2.carbon.datasource.DataSourceManagementService", service=DataSourceManagementService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDataSourceManagementService")
    protected void onDataSourceManagementServiceReady(DataSourceManagementService service) {
        logger.info("Sample bundle register method fired");
        try {
            DataSourceMetadata metadata = service.getDataSource("WSO2_CARBON_DB");
            logger.info(metadata.getName());
        }
        catch (DataSourceException e) {
            logger.error("Error occurred while fetching the data sources", (Throwable)e);
        }
    }

    @Reference(name="org.wso2.carbon.datasource.jndi", service=JNDIContextManager.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="onJNDIUnregister")
    protected void onJNDIReady(JNDIContextManager service) {
        try {
            Context ctx = service.newInitialContext();
            Object obj = ctx.lookup("java:comp/env/jdbc/WSO2CarbonDB/test");
            logger.info("Fetched data source: " + obj.toString());
        }
        catch (NamingException e) {
            logger.info("Error occurred while jndi lookup", (Throwable)e);
        }
    }

    protected void onJNDIUnregister(JNDIContextManager jndiContextManager) {
        logger.info("Unregistering data sources sample");
    }

    protected void unregisterDataSourceService(DataSourceService dataSourceService) {
        logger.info("Unregistering data sources sample");
    }

    protected void unregisterDataSourceManagementService(DataSourceManagementService dataSourceManagementService) {
        logger.info("Unregistering data sources sample");
    }
}

