/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.jndi.sample.osgi.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Optional;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jndi.JNDIContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.jndi.sample.osgi.internal.DataHolder;
import org.wso2.carbon.jndi.sample.osgi.services.FooService;
import org.wso2.carbon.jndi.sample.osgi.services.impl.FooServiceImpl;

public class OSGiURLExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OSGiURLExecutor.class);

    public void executeOSGIURLScheme() throws NamingException {
        BundleContext bundleContext = DataHolder.getDataHolderInstance().getBundleContext();
        ServiceReference contextManagerSRef = bundleContext.getServiceReference(JNDIContextManager.class);
        JNDIContextManager jndiContextManager = Optional.ofNullable(contextManagerSRef).map(arg_0 -> ((BundleContext)bundleContext).getService(arg_0)).orElseThrow(() -> new RuntimeException("JNDIContextManager service is not available."));
        Context initialContext = jndiContextManager.newInitialContext();
        this.accessServiceWithJNDIServiceName(bundleContext, initialContext);
        this.retrieveBundleContext(bundleContext, initialContext);
        this.listServices(bundleContext, initialContext);
    }

    private void accessServiceWithJNDIServiceName(BundleContext bundleContext, Context context) throws NamingException {
        Hashtable<String, Object> propertyMap = new Hashtable<String, Object>();
        ((Dictionary)propertyMap).put("service.ranking", 10);
        ((Dictionary)propertyMap).put("osgi.jndi.service.name", "foo/myService");
        FooServiceImpl fooService = new FooServiceImpl();
        ServiceRegistration fooServiceRegistration = bundleContext.registerService(FooService.class, (Object)fooService, propertyMap);
        FooService service = (FooService)context.lookup("osgi:service/org.wso2.carbon.jndi.sample.osgi.services.FooService");
        FooService jndiService = (FooService)context.lookup("osgi:service/foo/myService");
        logger.info("JNDI lookup message with OSGi URL scheme is : " + service.getMessage());
        logger.info("JNDI lookup message with OSGi URL scheme and JNDI service name is : " + jndiService.getMessage());
        fooServiceRegistration.unregister();
    }

    private void retrieveBundleContext(BundleContext bundleContext, Context context) throws NamingException {
        FooServiceImpl fooService = new FooServiceImpl();
        ServiceRegistration fooServiceRegistration = bundleContext.registerService(FooService.class, (Object)fooService, null);
        BundleContext owningBundleContext = (BundleContext)context.lookup("osgi:framework/bundleContext");
        ServiceReference serviceReference = owningBundleContext.getServiceReference("org.wso2.carbon.jndi.osgi.services.FooService");
        FooService service = (FooService)owningBundleContext.getService(serviceReference);
        logger.info("The service retrieved from the bundleContext has the message : " + service.getMessage());
        fooServiceRegistration.unregister();
    }

    private void listServices(BundleContext bundleContext, Context context) throws NamingException {
        Hashtable<String, String> propertyMap = new Hashtable<String, String>();
        ((Dictionary)propertyMap).put("osgi.jndi.service.name", "foo/myService");
        FooServiceImpl fooService = new FooServiceImpl();
        ServiceRegistration fooServiceRegistration = bundleContext.registerService(FooService.class, (Object)fooService, propertyMap);
        NamingEnumeration<Binding> listBindings = context.listBindings("osgi:service/foo/myService");
        Binding binding = (Binding)listBindings.nextElement();
        logger.info("First service retrieved from the listBinding has the class : " + binding.getClassName());
        listBindings.close();
        fooServiceRegistration.unregister();
    }
}

