/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ml.commons.domain.MLModel;
import org.wso2.carbon.ml.core.exceptions.MLModelHandlerException;
import org.wso2.carbon.ml.core.impl.Predictor;

public class MLModelUsageSample {
    private static final Log logger = LogFactory.getLog(MLModelUsageSample.class);

    public static void main(String[] args) throws Exception {
        MLModelUsageSample modelUsageSample = new MLModelUsageSample();
        URL resource = MLModelUsageSample.class.getClassLoader().getResource("downloaded-ml-model");
        String pathToDownloadedModel = new File(resource.toURI()).getAbsolutePath();
        MLModel mlModel = modelUsageSample.deserializeMLModel(pathToDownloadedModel);
        String[] featureValueArray1 = new String[]{"6", "148", "72", "35", "0", "33.6", "0.627", "50"};
        String[] featureValueArray2 = new String[]{"0", "101", "80", "40", "0", "26", "0.5", "33"};
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(featureValueArray1);
        list.add(featureValueArray2);
        modelUsageSample.predict(list, mlModel);
    }

    private MLModel deserializeMLModel(String pathToDownloadedModel) throws IOException, ClassNotFoundException, URISyntaxException {
        FileInputStream fileInputStream = new FileInputStream(pathToDownloadedModel);
        ObjectInputStream in = new ObjectInputStream(fileInputStream);
        MLModel mlModel = (MLModel)in.readObject();
        logger.info((Object)("Algorithm Type : " + mlModel.getAlgorithmClass()));
        logger.info((Object)("Algorithm Name : " + mlModel.getAlgorithmName()));
        logger.info((Object)("Response Variable : " + mlModel.getResponseVariable()));
        logger.info((Object)("Features : " + mlModel.getFeatures()));
        return mlModel;
    }

    public void predict(List<String[]> featureValueLists, MLModel mlModel) throws MLModelHandlerException {
        Predictor predictor = new Predictor(0L, mlModel, featureValueLists);
        List predictions = predictor.predict();
        logger.info((Object)("Predictions : " + predictions));
    }
}

