/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.cep.sample;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConsumerLogService
extends HttpServlet {
    private static Log log = LogFactory.getLog(XmlConsumerLogService.class);
    private DecimalFormat decimalFormat = new DecimalFormat("#");
    private static int elapsedCount = 50000;
    private static AtomicLong eventCount = new AtomicLong(0L);
    private static long lastTime;
    private long sentTime;
    private Pattern eventPattern;
    private static AtomicLong latency;

    public void init() throws ServletException {
        log.info((Object)"Logger service initiated");
        eventCount.set(0L);
        lastTime = System.currentTimeMillis();
        this.eventPattern = Pattern.compile("(<timestamp>(\\d+))");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.inputStreamToString((InputStream)request.getInputStream());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.inputStreamToString((InputStream)request.getInputStream());
    }

    private String inputStreamToString(InputStream in) throws IOException {
        int i;
        long receivedTime = System.currentTimeMillis();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        while ((i = in.read(buff)) > 0) {
            out.write(buff, 0, i);
        }
        out.close();
        String message = out.toString();
        Matcher eventPatternMatcher = this.eventPattern.matcher(message);
        if (eventPatternMatcher.find()) {
            this.sentTime = Long.parseLong(eventPatternMatcher.group(2));
        } else {
            log.error((Object)"unable to extract timestamp from received event");
        }
        latency.addAndGet(receivedTime - this.sentTime);
        eventCount.addAndGet(1L);
        if (eventCount.get() % (long)elapsedCount == 0L) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - lastTime;
            double throughputPerSecond = (double)elapsedCount / (double)elapsedTime * 1000.0;
            lastTime = currentTime;
            log.info((Object)("Sent " + elapsedCount + " sensor events in time (ms) for throughput of : " + elapsedTime + ", " + this.decimalFormat.format(throughputPerSecond) + ", Latency: " + (double)latency.get() / (double)elapsedCount));
            latency = new AtomicLong(0L);
        }
        return message;
    }

    static {
        latency = new AtomicLong(0L);
    }
}

