/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.consumer;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.sample.consumer.JNDIContext;

public class JMSQueueMessageConsumer
implements Runnable {
    private static Log log = LogFactory.getLog(JMSQueueMessageConsumer.class);
    private QueueConnectionFactory queueConnectionFactory = null;
    private String queueName = "";
    private boolean active = true;
    private String consumerId;
    private int consumers;
    private int warmUpCount;

    JMSQueueMessageConsumer(String queueName, int consumers, int warmUpCount) {
        this.queueName = queueName;
        this.consumers = consumers;
        this.warmUpCount = warmUpCount;
    }

    public void listen(String consumerId) throws InterruptedException, NamingException {
        this.consumerId = consumerId;
        this.queueConnectionFactory = JNDIContext.getInstance().getQueueConnectionFactory();
        Thread consumerThread = new Thread(this);
        log.info((Object)("Starting consumer # " + consumerId));
        consumerThread.start();
    }

    public void shutdown() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        QueueConnection queueConnection = null;
        try {
            queueConnection = this.queueConnectionFactory.createQueueConnection();
            queueConnection.start();
        }
        catch (JMSException e) {
            log.info((Object)("Can not create queue connection." + (Object)((Object)e)));
            return;
        }
        QueueSession session = null;
        try {
            session = queueConnection.createQueueSession(false, 1);
            Queue destination = session.createQueue(this.queueName);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            int count = 0;
            long totalLatency = 0L;
            long lastTimestamp = System.currentTimeMillis();
            while (this.active) {
                Message message = consumer.receive(1000L);
                if (message == null) continue;
                MapMessage mapMessage = (MapMessage)message;
                long currentTime = System.currentTimeMillis();
                long sentTimestamp = (Long)mapMessage.getObject("time");
                totalLatency += currentTime - sentTimestamp;
                int logCount = 1000;
                if (count % logCount == 0 && count > this.warmUpCount) {
                    double rate = (double)logCount * 1000.0 / (double)(System.currentTimeMillis() - lastTimestamp);
                    log.info((Object)("Consumer: " + this.consumerId + " (" + logCount + " received) rate: " + rate + " Latency:" + (double)totalLatency / ((double)logCount * 1.0)));
                    log.info((Object)("Total rate: " + (int)((double)this.consumers * rate)));
                    totalLatency = 0L;
                    lastTimestamp = System.currentTimeMillis();
                }
                ++count;
            }
            log.info((Object)"Finished listening for messages.");
        }
        catch (JMSException e) {
            log.info((Object)("Can not subscribe." + (Object)((Object)e)));
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    log.error((Object)e);
                }
            }
            try {
                queueConnection.stop();
                queueConnection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
}

