/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.sample.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.utils.EventDefinitionConverterUtils;
import org.wso2.carbon.sample.server.TestWso2EventServer;

public class WSO2EventServerUtil {
    private static Logger log = Logger.getLogger(TestWso2EventServer.class);
    static File securityFile = new File(".." + File.separator + ".." + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security");
    static String configDirectoryPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventstreams";
    static String sampleDirectoryPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + "samples" + File.separator + "artifacts" + File.separator + "sampleNumber" + File.separator + "eventstreams";

    public static void setTrustStoreParams() {
        String trustStore = securityFile.getAbsolutePath();
        System.setProperty("javax.net.ssl.trustStore", trustStore + "" + File.separator + "client-truststore.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
    }

    public static void setKeyStoreParams() {
        String keyStore = securityFile.getAbsolutePath();
        System.setProperty("Security.KeyStore.Location", keyStore + "" + File.separator + "wso2carbon.jks");
        System.setProperty("Security.KeyStore.Password", "wso2carbon");
    }

    public static String getDataBridgeConfigPath() {
        File filePath = new File("src" + File.separator + "test" + File.separator + "resources");
        if (!filePath.exists()) {
            filePath = new File("src" + File.separator + "main" + File.separator + "resources");
        }
        if (!filePath.exists()) {
            filePath = new File("test" + File.separator + "resources");
        }
        if (!filePath.exists()) {
            filePath = new File("resources");
        }
        if (!filePath.exists()) {
            filePath = new File("test" + File.separator + "resources");
        }
        return filePath.getAbsolutePath() + File.separator + "data-bridge-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<StreamDefinition> loadStreamDefinitions(String sampleNumber) {
        String directoryPath = sampleNumber.length() != 0 ? sampleDirectoryPath.replace("sampleNumber", sampleNumber) : configDirectoryPath;
        File directory = new File(directoryPath);
        ArrayList<StreamDefinition> streamDefinitions = new ArrayList<StreamDefinition>();
        if (!directory.exists()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " directory not exist"));
            return streamDefinitions;
        }
        if (!directory.isDirectory()) {
            log.error((Object)("Cannot load stream definitions from " + directory.getAbsolutePath() + " not a directory"));
            return streamDefinitions;
        }
        File[] defFiles = directory.listFiles();
        if (defFiles != null) {
            for (File fileEntry : defFiles) {
                if (fileEntry.isDirectory()) continue;
                BufferedReader bufferedReader = null;
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    String line;
                    bufferedReader = new BufferedReader(new FileReader(fileEntry));
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line).append("\n");
                    }
                    StreamDefinition streamDefinition = EventDefinitionConverterUtils.convertFromJson((String)stringBuilder.toString().trim());
                    streamDefinitions.add(streamDefinition);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Error in reading file " + fileEntry.getName()), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)("Error in reading file " + fileEntry.getName()), (Throwable)e);
                }
                catch (MalformedStreamDefinitionException e) {
                    log.error((Object)("Error in converting Stream definition " + e.getMessage()), (Throwable)e);
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("Error occurred when reading the file : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        return streamDefinitions;
    }
}

