/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.choreo.connect.mockbackend;

import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class MockAnalyticsServer
extends Thread {
    private static final Logger logger = Logger.getLogger(MockAnalyticsServer.class.getName());
    private int backEndServerPort;
    private HttpServer httpServer;
    private volatile ArrayList<String> list = new ArrayList();

    public MockAnalyticsServer(int port) {
        this.backEndServerPort = port;
    }

    @Override
    public void run() {
        if (this.backEndServerPort < 0) {
            throw new RuntimeException("Server port is not defined");
        }
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(this.backEndServerPort), 0);
            String context = "/analytics";
            this.httpServer.createContext(context + "/publish", exchange -> {
                String str;
                InputStream inputStream = exchange.getRequestBody();
                InputStreamReader isReader = new InputStreamReader(inputStream);
                BufferedReader reader = new BufferedReader(isReader);
                StringBuffer sb = new StringBuffer();
                while ((str = reader.readLine()) != null) {
                    sb.append(str);
                }
                String formattedString = sb.toString().replaceAll("=", ":");
                this.list.add(formattedString);
                byte[] response = "published".getBytes();
                exchange.getResponseHeaders().set("content-type", "text/plain");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/clear", exchange -> {
                this.list.clear();
                byte[] response = "cleared".getBytes();
                exchange.getResponseHeaders().set("content-type", "text/plain");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/get", exchange -> {
                String records = new JSONArray(this.list).toString();
                byte[] response = records.getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error occurred while setting up sandbox server", ex);
        }
    }
}

