/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.choreo.connect.mockbackend;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.wso2.choreo.connect.mockbackend.Utils;

public class MockBackendProd
extends Thread {
    private static final Logger log = LogManager.getLogger((String)"MockBackend");
    private HttpServer httpServer;
    private final int backendServerPort;
    private boolean secured = false;
    private boolean mtlsEnabled = false;
    private int retryCountEndpointTwo = 0;
    private int retryCountEndpointThree = 0;
    private int retryCountEndpointFour = 0;

    public MockBackendProd(int port) {
        this.backendServerPort = port;
    }

    public MockBackendProd(int port, boolean isSecured, boolean mtlsEnabled) {
        this.secured = isSecured;
        this.backendServerPort = port;
        this.mtlsEnabled = mtlsEnabled;
    }

    @Override
    public void run() {
        if (this.backendServerPort < 0) {
            throw new RuntimeException("Server port is not defined");
        }
        try {
            if (this.secured) {
                this.httpServer = HttpsServer.create(new InetSocketAddress(this.backendServerPort), 0);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(Utils.getKeyManagers("backendKeystore.pkcs12", "backend"), Utils.getTrustManagers(), null);
                ((HttpsServer)this.httpServer).setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext sslContext = SSLContext.getDefault();
                            SSLEngine engine = sslContext.createSSLEngine();
                            SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
                            sslParameters.setCipherSuites(engine.getEnabledCipherSuites());
                            sslParameters.setNeedClientAuth(MockBackendProd.this.mtlsEnabled);
                            sslParameters.setProtocols(engine.getEnabledProtocols());
                            params.setSSLParameters(sslParameters);
                        }
                        catch (Exception ex) {
                            log.error("Failed to create HTTPS port");
                        }
                    }
                });
            } else {
                this.httpServer = HttpServer.create(new InetSocketAddress(this.backendServerPort), 0);
            }
            String context = "/v2";
            this.httpServer.createContext(context + "/pet/findByStatus", exchange -> {
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/pet/", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/pet/findByTags", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/pets/findByTags", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/store/inventory", exchange -> {
                byte[] response = "{ \"AVAILABLE\": 1,  \"string\": 2,  \"pending\": 2,  \"available\": 233539,  \"PENDING\": 1}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/pet/3", exchange -> {
                byte[] response = "{\"id\":3, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/store/order/1", exchange -> {
                if (exchange.getRequestHeaders().containsKey("Authorization") && exchange.getRequestHeaders().get("Authorization").toString().contains("Basic YWRtaW46aGVsbG8=")) {
                    byte[] response = "{ \"AVAILABLE\": 1,  \"string\": 2,  \"pending\": 2,  \"available\": 233539,  \"PENDING\": 1}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                } else {
                    byte[] response = "{\"fault\":\"Authorization credentials are not provided.\"}".getBytes();
                    Utils.respondWithBodyAndClose(401, response, exchange);
                }
            });
            this.httpServer.createContext(context + "/user/john", exchange -> {
                if (exchange.getRequestHeaders().containsKey("Authorization") && exchange.getRequestHeaders().get("Authorization").toString().contains("Basic YWRtaW46aGVsbG8=")) {
                    byte[] response = "{ \"name\": \"john\" }".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                } else {
                    byte[] response = "{\"fault\":\"Forbidden.\"}".getBytes();
                    Utils.respondWithBodyAndClose(403, response, exchange);
                }
            });
            this.httpServer.createContext(context + "/jwtheader", exchange -> {
                byte[] response = exchange.getRequestHeaders().containsKey("X-JWT-Assertion") ? "\"{\"header\":\"available\"}\"".getBytes() : "\"{\"header\":\"not available\"}\"".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/jwttoken", exchange -> {
                byte[] response;
                if (exchange.getRequestHeaders().containsKey("X-JWT-Assertion")) {
                    String token = exchange.getRequestHeaders().get("X-JWT-Assertion").toString();
                    token = token.substring(1, token.length() - 1);
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put("token", (Object)token);
                    response = responseJSON.toString().getBytes();
                } else {
                    response = "\"{\"header\":\"not available\"}\"".getBytes();
                }
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/removeauthheader", exchange -> {
                byte[] response = !exchange.getRequestHeaders().containsKey("authHeader") ? "\"{\"header\":\"not available\"}\"".getBytes() : "\"{\"header\":\"available\"}\"".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext("/v3/pet/findByStatus", exchange -> {
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/delay-17", exchange -> {
                try {
                    log.info("Sleeping 17s...");
                    Thread.sleep(17000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/delay-8", exchange -> {
                try {
                    log.info("Sleeping 8s...");
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/delay-5", exchange -> {
                try {
                    log.info("Sleeping 5s...");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/delay-4", exchange -> {
                try {
                    log.info("Sleeping 4s...");
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/retry-four", exchange -> {
                ++this.retryCountEndpointFour;
                if (this.retryCountEndpointFour < 4) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(504, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            this.httpServer.createContext(context + "/retry-three", exchange -> {
                ++this.retryCountEndpointThree;
                if (this.retryCountEndpointThree < 3) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(503, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            this.httpServer.createContext(context + "/retry-two", exchange -> {
                ++this.retryCountEndpointTwo;
                if (this.retryCountEndpointTwo < 2) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(502, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            this.httpServer.createContext(context + "/req-cb", exchange -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    log.error("Error occurred while thread sleep", (Throwable)e);
                }
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/headers", exchange -> {
                JSONObject responseJSON = new JSONObject();
                exchange.getRequestHeaders().forEach((key, values) -> values.forEach(value -> responseJSON.put(key, value)));
                byte[] response = responseJSON.toString().getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/headers/23.api", exchange -> {
                JSONObject responseJSON = new JSONObject();
                exchange.getRequestHeaders().forEach((key, values) -> values.forEach(value -> responseJSON.put(key, value)));
                byte[] response = responseJSON.toString().getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            this.httpServer.createContext(context + "/echo", Utils::echo);
            this.httpServer.createContext(context + "/echo2", Utils::echo);
            this.httpServer.start();
        }
        catch (Exception ex) {
            log.error("Error occurred while setting up mock server", (Throwable)ex);
        }
    }

    public void stopIt() {
        this.httpServer.stop(0);
    }
}

