/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.choreo.connect.mockbackend;

import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wso2.choreo.connect.mockbackend.Utils;

public class MockBackendSandbox
extends Thread {
    private static final Logger logger = Logger.getLogger(MockBackendSandbox.class.getName());
    private final int backEndServerPort;
    private int retryCountEndpointTwo = 0;
    private int retryCountEndpointThree = 0;
    private int retryCountEndpointSeven = 0;

    public MockBackendSandbox(int port) {
        this.backEndServerPort = port;
    }

    @Override
    public void run() {
        if (this.backEndServerPort < 0) {
            throw new RuntimeException("Server port is not defined");
        }
        try {
            HttpServer httpServer = HttpServer.create(new InetSocketAddress(this.backEndServerPort), 0);
            String context = "/v2";
            httpServer.createContext(context + "/pet/findByStatus", exchange -> {
                byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/pets/findByStatus", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/pet/findByStatus/dynamic-ep-echo", Utils::echo);
            httpServer.createContext(context + "/delay-8", exchange -> {
                try {
                    logger.info("Sleeping 8s...");
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/delay-5", exchange -> {
                try {
                    logger.info("Sleeping 5s...");
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/delay-4", exchange -> {
                try {
                    logger.info("Sleeping 4s...");
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/retry-seven", exchange -> {
                ++this.retryCountEndpointSeven;
                if (this.retryCountEndpointSeven < 7) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(504, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            httpServer.createContext(context + "/retry-three", exchange -> {
                ++this.retryCountEndpointThree;
                if (this.retryCountEndpointThree < 3) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(403, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            httpServer.createContext(context + "/retry-two", exchange -> {
                ++this.retryCountEndpointTwo;
                if (this.retryCountEndpointTwo < 2) {
                    byte[] response = "{\"fault\":\"Gateway error.\"}".getBytes();
                    Utils.respondWithBodyAndClose(402, response, exchange);
                } else {
                    byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                    Utils.respondWithBodyAndClose(200, response, exchange);
                }
            });
            httpServer.createContext(context + "/req-cb", exchange -> {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.log(Level.SEVERE, "Error occurred while thread sleep", e);
                }
                byte[] response = "{\"id\":111111155, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                Utils.respondWithBodyAndClose(200, response, exchange);
            });
            httpServer.createContext(context + "/echo", Utils::echo);
            httpServer.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error occurred while setting up sandbox server", ex);
        }
    }
}

