/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.choreo.connect.mockbackend;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.net.InetSocketAddress;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.wso2.choreo.connect.mockbackend.InterceptorConstants;
import org.wso2.choreo.connect.mockbackend.Utils;

public class MockInterceptorServer
extends Thread {
    private static final Logger log = LogManager.getLogger((String)MockInterceptorServer.class.getName());
    private final int statusServerPort;
    private final HandlerServer handlerServer;
    private volatile InterceptorConstants.Handler handler;
    private volatile String requestFlowRequestBody;
    private volatile String requestFlowResponseBody;
    private volatile String responseFlowRequestBody;
    private volatile String responseFlowResponseBody;

    public MockInterceptorServer(int interceptorStatusPort, int handlerPort) {
        this.statusServerPort = interceptorStatusPort;
        this.handlerServer = new HandlerServer(handlerPort);
        this.clearStatus();
    }

    private void clearStatus() {
        this.handler = InterceptorConstants.Handler.NONE;
        this.requestFlowRequestBody = "";
        this.requestFlowResponseBody = "{}";
        this.responseFlowRequestBody = "";
        this.responseFlowResponseBody = "{}";
    }

    @Override
    public void run() {
        if (this.statusServerPort < 0) {
            throw new RuntimeException("Server port is not defined");
        }
        try {
            HttpServer managerHttpServer = HttpServer.create(new InetSocketAddress(this.statusServerPort), 0);
            String context = "/interceptor";
            managerHttpServer.createContext(context + "/status", exchange -> {
                JSONObject responseJSON = new JSONObject();
                responseJSON.put("handler", (Object)this.handler);
                responseJSON.put("requestFlowRequestBody", (Object)this.requestFlowRequestBody);
                responseJSON.put("responseFlowRequestBody", (Object)this.responseFlowRequestBody);
                byte[] response = responseJSON.toString().getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            managerHttpServer.createContext(context + "/clear-status", exchange -> {
                this.clearStatus();
                Utils.send200OK(exchange);
                exchange.close();
            });
            managerHttpServer.createContext(context + "/request", exchange -> {
                this.requestFlowResponseBody = Utils.requestBodyToString(exchange);
                Utils.send200OK(exchange);
                exchange.close();
            });
            managerHttpServer.createContext(context + "/response", exchange -> {
                this.responseFlowResponseBody = Utils.requestBodyToString(exchange);
                Utils.send200OK(exchange);
                exchange.close();
            });
            managerHttpServer.start();
        }
        catch (Exception ex) {
            log.error("Error occurred while setting up interceptor server", (Throwable)ex);
        }
    }

    @Override
    public void start() {
        super.start();
        this.handlerServer.start();
    }

    private class HandlerServer
    extends Thread {
        private final Logger log = LogManager.getLogger((String)HandlerServer.class.getName());
        private final int handlerServerPort;

        public HandlerServer(int port) {
            this.handlerServerPort = port;
        }

        @Override
        public void run() {
            if (this.handlerServerPort < 0) {
                throw new RuntimeException("Server port is not defined");
            }
            try {
                HttpsServer httpServer = HttpsServer.create(new InetSocketAddress(this.handlerServerPort), 0);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(Utils.getKeyManagers("interceptorKeystore.pkcs12", "interceptor"), Utils.getTrustManagers(), null);
                httpServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext sslContext = SSLContext.getDefault();
                            SSLEngine engine = sslContext.createSSLEngine();
                            SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
                            sslParameters.setCipherSuites(engine.getEnabledCipherSuites());
                            sslParameters.setNeedClientAuth(true);
                            sslParameters.setProtocols(engine.getEnabledProtocols());
                            params.setSSLParameters(sslParameters);
                        }
                        catch (Exception ex) {
                            HandlerServer.this.log.error("Failed to create HTTPS port");
                        }
                    }
                });
                String context = "/api/v1";
                httpServer.createContext(context + "/handle-request", exchange -> {
                    if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                        Utils.send404NotFound(exchange);
                        return;
                    }
                    this.log.info("Called /handle-request of interceptor service");
                    MockInterceptorServer.this.requestFlowRequestBody = Utils.requestBodyToString(exchange);
                    if (Arrays.asList(InterceptorConstants.Handler.NONE, InterceptorConstants.Handler.REQUEST_ONLY).contains((Object)MockInterceptorServer.this.handler)) {
                        MockInterceptorServer.this.handler = InterceptorConstants.Handler.REQUEST_ONLY;
                    } else {
                        MockInterceptorServer.this.handler = InterceptorConstants.Handler.BOTH;
                    }
                    byte[] response = MockInterceptorServer.this.requestFlowResponseBody.getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(200, response.length);
                    exchange.getResponseBody().write(response);
                    exchange.close();
                });
                httpServer.createContext(context + "/handle-response", exchange -> {
                    if (!"POST".equalsIgnoreCase(exchange.getRequestMethod())) {
                        Utils.send404NotFound(exchange);
                        return;
                    }
                    this.log.info("Called /handle-response of interceptor service");
                    MockInterceptorServer.this.responseFlowRequestBody = Utils.requestBodyToString(exchange);
                    if (Arrays.asList(InterceptorConstants.Handler.NONE, InterceptorConstants.Handler.RESPONSE_ONLY).contains((Object)MockInterceptorServer.this.handler)) {
                        MockInterceptorServer.this.handler = InterceptorConstants.Handler.RESPONSE_ONLY;
                    } else {
                        MockInterceptorServer.this.handler = InterceptorConstants.Handler.BOTH;
                    }
                    byte[] response = MockInterceptorServer.this.responseFlowResponseBody.getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(200, response.length);
                    exchange.getResponseBody().write(response);
                    exchange.close();
                });
                httpServer.start();
            }
            catch (Exception ex) {
                this.log.error("Error occurred while setting up interceptor handler server", (Throwable)ex);
            }
        }
    }
}

