/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.choreo.connect.mockbackend;

import com.sun.net.httpserver.HttpExchange;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class Utils {
    public static void echo(HttpExchange exchange) throws IOException {
        String requestBody = Utils.requestBodyToString(exchange);
        byte[] response = requestBody.getBytes();
        exchange.getResponseHeaders().putAll(exchange.getRequestHeaders());
        int respCode = response.length == 0 ? 204 : 200;
        exchange.sendResponseHeaders(respCode, response.length);
        exchange.getResponseBody().write(response);
        exchange.close();
    }

    public static String requestBodyToString(HttpExchange exchange) throws IOException {
        String str;
        InputStream inputStream = exchange.getRequestBody();
        InputStreamReader isReader = new InputStreamReader(inputStream);
        BufferedReader reader = new BufferedReader(isReader);
        StringBuffer sb = new StringBuffer();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static void respondWithBodyAndClose(int statusCode, byte[] response, HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), "application/json");
        exchange.sendResponseHeaders(statusCode, response.length);
        exchange.getResponseBody().write(response);
        exchange.close();
    }

    public static void send404NotFound(HttpExchange exchange) throws IOException {
        byte[] response = "{\"status\":\"404 Resource Not Found\"}".getBytes();
        exchange.getResponseHeaders().set("content-type", "application/json");
        exchange.sendResponseHeaders(404, response.length);
        exchange.getResponseBody().write(response);
        exchange.close();
    }

    public static void send200OK(HttpExchange exchange) throws IOException {
        byte[] response = "{\"status\":\"OK\"}".getBytes();
        exchange.getResponseHeaders().set("content-type", "application/json");
        exchange.sendResponseHeaders(200, response.length);
        exchange.getResponseBody().write(response);
    }

    public static TrustManager[] getTrustManagers() throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("mg.pem");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(inputStream);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        ks.setCertificateEntry("caCert", caCert);
        tmf.init(ks);
        return tmf.getTrustManagers();
    }

    public static KeyManager[] getKeyManagers(String keystoreName, String password) throws Exception {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(keystoreName);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(inputStream, password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, password.toCharArray());
        return kmf.getKeyManagers();
    }
}

