/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.hubspot.jinjava.Jinjava;
import com.hubspot.jinjava.JinjavaConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;
import org.wso2.config.mapper.util.FileUtils;

class JinjaParser {
    private static final Log log = LogFactory.getLog(JinjaParser.class);

    private JinjaParser() {
    }

    static Map<String, String> parse(Context context, Map<String, File> templateFiles) throws ConfigParserException {
        LinkedHashMap<String, String> outputs = new LinkedHashMap<String, String>();
        JinjavaConfig configurator = JinjavaConfig.newBuilder().withLstripBlocks(true).withTrimBlocks(true).build();
        Jinjava jinjava = new Jinjava(configurator);
        Map<String, Object> dottedKeyMap = JinjaParser.getHierarchicalDottedKeyMap(context.getTemplateData());
        templateFiles.entrySet().parallelStream().forEach(templateFile -> {
            String renderedTemplate = "";
            try {
                String template = FileUtils.readFile((File)templateFile.getValue());
                renderedTemplate = jinjava.render(template, dottedKeyMap);
            }
            catch (ConfigParserException e) {
                log.error((Object)"Error while parsing Jinja template", (Throwable)e);
            }
            outputs.put((String)templateFile.getKey(), renderedTemplate);
        });
        return outputs;
    }

    static Map<String, Object> getHierarchicalDottedKeyMap(Map<String, Object> dottedKeyMap) throws ConfigParserException {
        LinkedHashMap<String, Object> newContext = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : dottedKeyMap.entrySet()) {
            JinjaParser.changeToHierarchicalMap(entry, newContext);
        }
        return newContext;
    }

    private static void changeToHierarchicalMap(Map.Entry<String, Object> entry, Map<String, Object> context) throws ConfigParserException {
        List<String> dottedKeyList = JinjaParser.getDottedKeyArray(entry.getKey());
        Map<String, Object> parentMap = context;
        for (int i = 0; i < dottedKeyList.size() - 1; ++i) {
            LinkedHashMap<String, Object> map;
            String keyElement = dottedKeyList.get(i);
            Object object = parentMap.get(keyElement);
            if (object instanceof Map) {
                map = (LinkedHashMap<String, Object>)object;
            } else {
                map = new LinkedHashMap<String, Object>();
                parentMap.put(keyElement, map);
            }
            parentMap = map;
        }
        List<Object> value = entry.getValue();
        if (value instanceof List) {
            value = JinjaParser.processArray(value);
        }
        parentMap.put(dottedKeyList.get(dottedKeyList.size() - 1), value);
    }

    static List<String> getDottedKeyArray(String dottedFlatKey) throws ConfigParserException {
        ArrayList<String> list = new ArrayList<String>();
        int lastMatchedIndex = 0;
        while (lastMatchedIndex != -1) {
            int startIndex = 0;
            startIndex = lastMatchedIndex == 0 ? dottedFlatKey.indexOf(39, lastMatchedIndex) : dottedFlatKey.indexOf(39, lastMatchedIndex + 1);
            if (startIndex == -1) {
                int beginIndx = lastMatchedIndex == 0 ? 0 : lastMatchedIndex + 1;
                JinjaParser.splitAndAddToList(dottedFlatKey, list, beginIndx, dottedFlatKey.length());
                lastMatchedIndex = startIndex;
                continue;
            }
            int endIndex = dottedFlatKey.indexOf(39, startIndex + 1);
            if (endIndex == -1) {
                throw new ConfigParserException("Couldn't find matching ending \"'\" for sub key in flat key " + dottedFlatKey);
            }
            if (lastMatchedIndex == 0) {
                JinjaParser.splitAndAddToList(dottedFlatKey, list, lastMatchedIndex, startIndex);
            } else {
                JinjaParser.splitAndAddToList(dottedFlatKey, list, lastMatchedIndex + 1, startIndex);
            }
            list.add(dottedFlatKey.substring(startIndex + 1, endIndex));
            lastMatchedIndex = endIndex;
        }
        return list;
    }

    private static void splitAndAddToList(String flatKey, List<String> list, int startIndex, int endIndex) {
        String dottedSubKey = flatKey.substring(startIndex, endIndex);
        List<String> subKeyList = JinjaParser.splitWithoutEmptyStrings(dottedSubKey);
        list.addAll(subKeyList);
    }

    private static List<Object> processArray(List<Object> list) throws ConfigParserException {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Map<String, Object> map : list) {
            Object processedObject = map;
            if (map instanceof Map) {
                processedObject = JinjaParser.getHierarchicalDottedKeyMap(map);
            } else if (map instanceof List) {
                processedObject = JinjaParser.processArray((List)((Object)map));
            }
            newList.add(processedObject);
        }
        return newList;
    }

    static List<String> splitWithoutEmptyStrings(String input) {
        ArrayList<String> list = new ArrayList<String>();
        int lastDelimiterIndex = -1;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar != '.') continue;
            if (i - lastDelimiterIndex != 1) {
                String substring = input.substring(lastDelimiterIndex + 1, i);
                list.add(substring);
            }
            lastDelimiterIndex = i;
        }
        if (lastDelimiterIndex != input.length() - 1) {
            list.add(input.substring(lastDelimiterIndex + 1));
        }
        return list;
    }
}

