/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class KeyMapper {
    private KeyMapper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Context mapWithConfig(Context inputContext, String mappingFile) throws ConfigParserException {
        try (InputStreamReader validatorJson = new InputStreamReader((InputStream)new FileInputStream(mappingFile), Charset.defaultCharset());){
            Gson gson = new Gson();
            Map keyMappings = (Map)gson.fromJson((Reader)validatorJson, Map.class);
            Context context = KeyMapper.map(inputContext, keyMappings);
            return context;
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while parsing JSON file " + mappingFile, e);
        }
    }

    static Context map(Context context, Map<String, Object> keyMappings) throws ConfigParserException {
        LinkedHashMap<String, Object> mappedConfigs = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : context.getTemplateData().entrySet()) {
            Object mappedKeys = keyMappings.getOrDefault(entry.getKey(), entry.getKey());
            if (mappedKeys instanceof String) {
                mappedConfigs.put((String)mappedKeys, entry.getValue());
                continue;
            }
            if (!(mappedKeys instanceof List)) continue;
            ((List)mappedKeys).forEach(mappedKey -> mappedConfigs.put((String)mappedKey, entry.getValue()));
        }
        KeyMapper.processArrayKeys(keyMappings, mappedConfigs);
        context.getTemplateData().clear();
        context.getTemplateData().putAll(mappedConfigs);
        return context;
    }

    private static void processArrayKeys(Map<String, Object> keyMappings, Map<String, Object> mappedConfigs) throws ConfigParserException {
        for (Map.Entry<String, Object> entry : keyMappings.entrySet()) {
            String key = entry.getKey();
            String[] splitKey = key.split(":");
            if (splitKey.length == 2) {
                Object object = mappedConfigs.get(splitKey[0]);
                KeyMapper.processArrayKey(entry, splitKey, object);
                continue;
            }
            if (splitKey.length <= 2) continue;
            throw new ConfigParserException("Unknown key mapping key with multiple array elements: " + entry.getKey());
        }
    }

    private static void processArrayKey(Map.Entry<String, Object> entry, String[] splitKey, Object object) throws ConfigParserException {
        if (object instanceof List) {
            List list = (List)object;
            for (Object o : list) {
                if (!(o instanceof Map)) continue;
                KeyMapper.processMap(entry, splitKey[1], (Map)o);
            }
        }
    }

    private static void processMap(Map.Entry<String, Object> entry, String key, Map<String, Object> map) throws ConfigParserException {
        Object removedValue = map.remove(key);
        if (removedValue != null) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String[] splitValue = ((String)value).split(":");
                if (splitValue.length != 2) {
                    throw new ConfigParserException("Unknown key mapping value with multiple array elements: " + entry.getValue());
                }
                map.put(splitValue[1], removedValue);
            } else if (value instanceof List) {
                for (String mappedValue : (List)value) {
                    String[] splitValue = mappedValue.split(":");
                    if (splitValue.length != 2) {
                        throw new ConfigParserException("Unknown key mapping value with multiple array elements: " + entry.getValue());
                    }
                    map.put(splitValue[1], removedValue);
                }
            }
        }
    }
}

