/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ChangedFileSet;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class MetaDataParser {
    private static Log log = LogFactory.getLog(MetaDataParser.class);

    private MetaDataParser() {
    }

    static Map<String, String> readLastModifiedValues(String basePath, String path) throws ConfigParserException {
        HashMap<String, String> md5sumValues = new HashMap<String, String>();
        File file = new File(path);
        try {
            if (file.isDirectory()) {
                MetaDataParser.handleDirectories(basePath, md5sumValues, file);
            } else if (file.isFile()) {
                md5sumValues.put(Paths.get(basePath, new String[0]).relativize(file.toPath()).toString(), MetaDataParser.getMetadata(file));
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while reading metadata", e);
        }
        return md5sumValues;
    }

    private static String readLastModifiedValue(String path) throws ConfigParserException {
        try {
            File file = new File(path);
            return MetaDataParser.getMetadata(file);
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while reading metadata", e);
        }
    }

    private static void handleDirectories(String basePath, Map<String, String> md5sumValues, File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file1 : files) {
                if (file1.isFile()) {
                    md5sumValues.put(Paths.get(basePath, new String[0]).relativize(file1.toPath()).toString(), MetaDataParser.getMetadata(file1));
                    continue;
                }
                if (!file1.isDirectory()) continue;
                MetaDataParser.handleDirectories(basePath, md5sumValues, file1);
            }
        }
    }

    private static String getMetadata(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)fileInputStream);
            return string;
        }
    }

    static ChangedFileSet getChangedFiles(String basePath, List<String> deploymentConfigurationPaths, String metadataFilePath) throws ConfigParserException {
        File metaDataFile = new File(metadataFilePath);
        if (!metaDataFile.exists()) {
            return new ChangedFileSet(true, Collections.emptyList(), Collections.emptyList());
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(metaDataFile);
            Object object = null;
            try {
                properties.load(fileInputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Metadata File couldn't Read", e);
        }
        ChangedFileSet changedFileSet = new ChangedFileSet();
        for (String deploymentConfigurationPath : deploymentConfigurationPaths) {
            Map<String, String> actualLastModifiedValues = MetaDataParser.readLastModifiedValues(basePath, deploymentConfigurationPath);
            actualLastModifiedValues.forEach((path, lastModifiedValue) -> {
                String lastModifiedValueFromFile;
                String string = lastModifiedValueFromFile = properties.containsKey(path) ? (String)properties.get(path) : null;
                if (StringUtils.isNotEmpty((String)lastModifiedValueFromFile)) {
                    if (!lastModifiedValue.equals(lastModifiedValueFromFile)) {
                        changedFileSet.addChangedFile((String)path);
                    }
                } else {
                    changedFileSet.addNewFile((String)path);
                }
            });
        }
        return changedFileSet;
    }

    static ChangedFileSet getChangedFiles(String basePath, String metadataFilePath) throws ConfigParserException {
        File metaDataFile = new File(metadataFilePath);
        if (!metaDataFile.exists()) {
            return new ChangedFileSet(true, Collections.emptyList(), Collections.emptyList());
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(metaDataFile);
            Object object = null;
            try {
                properties.load(fileInputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Metadata File couldn't Read", (Throwable)e);
            throw new ConfigParserException("Metadata File couldn't Read", e);
        }
        ChangedFileSet changedFileSet = new ChangedFileSet();
        for (Map.Entry entry : properties.entrySet()) {
            String path = (String)entry.getKey();
            String lastModifiedValue = (String)entry.getValue();
            String actualLastModifiedValue = MetaDataParser.readLastModifiedValue(Paths.get(basePath, path).toString());
            if (!StringUtils.isNotEmpty((String)actualLastModifiedValue) || lastModifiedValue.equals(actualLastModifiedValue)) continue;
            changedFileSet.addChangedFile(path);
        }
        return changedFileSet;
    }

    static void storeMetaDataEntries(String basePath, String outputFilePath, Set<String> entries) throws ConfigParserException {
        File outputFile = new File(outputFilePath);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new ConfigParserException("Error while creating new directory " + outputFile.getAbsolutePath());
        }
        Properties properties = new Properties();
        for (String entry : entries) {
            properties.putAll(MetaDataParser.readLastModifiedValues(basePath, entry));
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFilePath);){
            properties.store(fileOutputStream, null);
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while storing metadata", e);
        }
    }

    static void storeReferences(String metadataPropertyPath, Context context) throws ConfigParserException {
        File outputFile = new File(metadataPropertyPath);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new ConfigParserException("Error while creating new directory " + outputFile.getAbsolutePath());
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(metadataPropertyPath), StandardCharsets.UTF_8);){
            Properties properties = new Properties();
            context.getResolvedEnvironmentVariables().forEach((key, value) -> properties.put("env:".concat((String)key), value));
            context.getResolvedSystemProperties().forEach((key, value) -> properties.put("sys:".concat((String)key), value));
            properties.store(outputStreamWriter, null);
        }
        catch (IOException e) {
            throw new ConfigParserException("Error While storing References", e);
        }
    }

    static boolean isReferencesChanged(String metadataPropertyPath) {
        boolean status = false;
        if (new File(metadataPropertyPath).exists()) {
            Properties references = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(metadataPropertyPath);){
                references.load(fileInputStream);
            }
            catch (IOException e) {
                log.error((Object)"Error while reading References", (Throwable)e);
            }
            for (Map.Entry<Object, Object> entry : references.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                if (key.contains("sys:")) {
                    value = System.getProperty(key.replace("sys:", ""));
                    if (entry.getValue().equals(value)) continue;
                    status = true;
                    break;
                }
                if (!key.contains("env:")) continue;
                value = System.getenv(key.replace("env:", ""));
                if (entry.getValue().equals(value)) continue;
                status = true;
                break;
            }
        }
        return status;
    }
}

