/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

public class Validator {
    private static final Log log = LogFactory.getLog(Validator.class);
    private static final String IF = "if";
    private static final String REGEX = "regex";
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_STRING_MESSAGE = "an empty string";

    private Validator() {
    }

    private static Map<String, Object> readConfiguration(String validationConfigFilePath) throws IOException {
        Gson gson = new Gson();
        try (FileInputStream fileInputStream = new FileInputStream(validationConfigFilePath);){
            InputStreamReader validatorJson = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            Map map = (Map)gson.fromJson((Reader)validatorJson, Map.class);
            return map;
        }
    }

    public static void validate(Context context, String fileName) throws ConfigParserException {
        try {
            Map<String, Object> ruleConfiguration = Validator.readConfiguration(fileName);
            for (Map.Entry<String, Object> entry : ruleConfiguration.entrySet()) {
                List value = (List)entry.getValue();
                for (Object rule : value) {
                    Validator.doValidation(entry.getKey(), (Map)rule, context.getTemplateData());
                }
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while reading validator file", e);
        }
    }

    private static void doValidation(String keyToValidate, Map<String, Object> validationRule, Map<String, Object> configurationValues) throws ConfigParserException {
        if (validationRule.get(IF) instanceof Map) {
            Map valuesToMatch = (Map)validationRule.get(IF);
            for (Map.Entry entry : valuesToMatch.entrySet()) {
                if (configurationValues.containsKey(entry.getKey())) {
                    Object configValue = configurationValues.get(entry.getKey());
                    if (configValue.equals(entry.getValue())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Condition doesn't match for %s, not enforcing rule. Expected %s for rule, was %s", entry.getKey(), configValue, entry.getValue()));
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Config %s is not present, hence not enforcing rule. ", entry.getKey()));
                }
                return;
            }
        }
        List<String> configValues = Validator.getConfigurationValues(configurationValues, keyToValidate);
        if (validationRule.get(REGEX) instanceof String) {
            for (String string : configValues) {
                String regex;
                if (string.matches(regex = (String)validationRule.get(REGEX))) continue;
                String errorMessage = (String)validationRule.get("error_message");
                if (errorMessage == null) {
                    errorMessage = String.format("Validation failed for %s. Expected value to match \"%s\", but was %s", keyToValidate, regex, EMPTY_STRING.equals(string) ? EMPTY_STRING_MESSAGE : string);
                }
                throw new ConfigParserException(errorMessage);
            }
        }
    }

    private static List<String> getConfigurationValues(Map<String, Object> configurationValues, String keyToValidate) {
        ArrayList<String> list = new ArrayList<String>();
        String[] splittedArray = StringUtils.split((String)keyToValidate, (String)":");
        if (splittedArray != null && splittedArray.length == 2) {
            Object configurations = configurationValues.get(splittedArray[0]);
            if (configurations instanceof List) {
                ((List)configurations).forEach(configuration -> {
                    if (configuration instanceof Map) {
                        if (((Map)configuration).get(splittedArray[1]) != null) {
                            list.add((String)((Map)configuration).get(splittedArray[1]));
                        } else {
                            list.add(EMPTY_STRING);
                        }
                    }
                });
            }
        } else if (configurationValues.containsKey(keyToValidate)) {
            list.add((String)configurationValues.get(keyToValidate));
        } else {
            list.add(EMPTY_STRING);
        }
        return list;
    }
}

