/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.config.mapper.ChangedFileSet;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.DefaultParser;
import org.wso2.config.mapper.JinjaParser;
import org.wso2.config.mapper.KeyMapper;
import org.wso2.config.mapper.MetaDataParser;
import org.wso2.config.mapper.ReferenceResolver;
import org.wso2.config.mapper.TomlParser;
import org.wso2.config.mapper.UnitResolver;
import org.wso2.config.mapper.Validator;
import org.wso2.config.mapper.ValueInferrer;
import org.wso2.config.mapper.model.Context;
import org.wso2.config.mapper.util.FileUtils;

public class ConfigParser {
    private static final Log log = LogFactory.getLog(ConfigParser.class);
    public static final String UX_FILE_PATH = "deployment.toml";
    private static final String TEMPLATE_FILE_DIR = "templates";
    private static final String INFER_CONFIG_FILE_PATH = "infer.json";
    private static final String VALIDATOR_FILE_PATH = "validator.json";
    private static final String MAPPING_FILE_PATH = "key-mappings.json";
    private static final String DEFAULT_VALUE_FILE_PATH = "default.json";
    private static final String UNIT_RESOLVER_FILE_PATH = "unit-resolve.json";
    private static final String META_DATA_CONFIG_FILE = "metadata_config.properties";
    private static final String META_DATA_TEMPLATE_FILE = "metadata_template.properties";
    private static final String CONFIG_PROPERTIES_FILE = "references.properties";
    private static final String META_DATA_DIRECTORY = ".metadata";
    private static final String JINJA_TEMPLATE_EXTENSION = ".j2";
    private static Map<String, Object> parsedConfigs;

    private ConfigParser() {
    }

    public static void parse(String configFilePath, String resourcesDir, String outputDir) throws ConfigParserException {
        ConfigPaths.setPaths(configFilePath, resourcesDir, outputDir);
        File deploymentConfigurationFile = new File(configFilePath);
        if (Boolean.getBoolean("avoidConfigUpdate")) {
            return;
        }
        if (!deploymentConfigurationFile.exists()) {
            log.warn((Object)("deployment.toml not found at " + configFilePath));
            return;
        }
        try {
            if (Boolean.getBoolean("forceConfigUpdate")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Forceful override configuration");
                }
                ConfigParser.deployAndStoreMetadata();
            } else {
                boolean referencesVariableChanged;
                ChangedFileSet configFileSet;
                List<String> configurationPaths = Arrays.asList(ConfigPaths.getTemplateFileDir(), ConfigPaths.getInferConfigurationFilePath(), ConfigPaths.getDefaultValueFilePath(), ConfigPaths.getValidatorFilePath(), ConfigPaths.getMappingFilePath(), ConfigPaths.getUnitResolverFilePath());
                ChangedFileSet templateFileSet = MetaDataParser.getChangedFiles(outputDir, configurationPaths, ConfigPaths.getMetadataTemplateFilePath());
                if (ConfigParser.isDeploymentRequired(templateFileSet, configFileSet = MetaDataParser.getChangedFiles(outputDir, ConfigPaths.getMetadataFilePath()), referencesVariableChanged = MetaDataParser.isReferencesChanged(ConfigPaths.getMetadataPropertyPath()))) {
                    if (templateFileSet.isFirstTimeStartup() && configFileSet.isFirstTimeStartup()) {
                        log.info((Object)"Initializing configurations with deployment configurations");
                    } else if (Boolean.getBoolean("avoidConfigHashRead")) {
                        log.info((Object)"Applying configurations with deployment configurations");
                    } else {
                        if (templateFileSet.isChanged()) {
                            templateFileSet.getChangedFiles().forEach(path -> log.warn((Object)("Configurations templates Changed in :" + path)));
                            templateFileSet.getNewFiles().forEach(path -> log.warn((Object)("New Configurations found in :" + path)));
                            log.info((Object)"Applying Configurations upon new Templates");
                        }
                        if (configFileSet.isChanged()) {
                            configFileSet.getChangedFiles().forEach(path -> log.warn((Object)("Configurations Changed in :" + path)));
                            log.warn((Object)("Overriding files in configuration directory " + outputDir));
                        }
                        if (referencesVariableChanged) {
                            log.warn((Object)("Configuration value changed in references, Overriding files in the configuration directory" + outputDir));
                        }
                    }
                    ConfigParser.deployAndStoreMetadata();
                }
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while store new configurations", e);
        }
    }

    private static boolean isDeploymentRequired(ChangedFileSet templateFileSet, ChangedFileSet configFileSet, boolean referencesVariableChanged) {
        if (templateFileSet.isChanged() || configFileSet.isChanged() || referencesVariableChanged) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No file changes detected");
        }
        return false;
    }

    private static void backupConfigurations(String configFilePath, String backupPath) throws ConfigParserException {
        File backupFile = new File(backupPath);
        FileUtils.deleteDirectory(backupFile);
        File templateDir = ConfigParser.checkTemplateDirExistence(ConfigPaths.getTemplateFileDir());
        FileUtils.writeDirectory(configFilePath, backupPath, ConfigParser.getTemplatedFilesMap(templateDir).keySet());
    }

    private static void deployAndStoreMetadata() throws IOException, ConfigParserException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Backed up the configurations into " + ConfigPaths.getOutputDir() + File.separator + "backup"));
        }
        ConfigParser.backupConfigurations(ConfigPaths.getOutputDir(), Paths.get(ConfigPaths.getOutputDir(), "backup").toString());
        Context context = new Context();
        Set<String> deployedFileSet = ConfigParser.deploy(context, ConfigPaths.getOutputDir());
        log.debug((Object)"Writing Metadata Entries...");
        HashSet<String> entries = new HashSet<String>(Arrays.asList(ConfigPaths.getTemplateFileDir(), ConfigPaths.getInferConfigurationFilePath(), ConfigPaths.getDefaultValueFilePath(), ConfigPaths.getUnitResolverFilePath(), ConfigPaths.getValidatorFilePath(), ConfigPaths.getMappingFilePath()));
        try {
            MetaDataParser.storeMetaDataEntries(ConfigPaths.getOutputDir(), ConfigPaths.getMetadataTemplateFilePath(), entries);
            deployedFileSet.add(ConfigPaths.getConfigFilePath());
            MetaDataParser.storeMetaDataEntries(ConfigPaths.getOutputDir(), ConfigPaths.getMetadataFilePath(), deployedFileSet);
            MetaDataParser.storeReferences(ConfigPaths.getMetadataPropertyPath(), context);
        }
        catch (ConfigParserException e) {
            log.warn((Object)"Error while storing metadata entries", (Throwable)e);
        }
    }

    private static Set<String> deploy(Context context, String outputFilePath) throws IOException, ConfigParserException {
        File outputDir = new File(outputFilePath);
        HashSet<String> changedFileSet = new HashSet<String>();
        if (outputDir.exists() && outputDir.isDirectory()) {
            Map<String, String> outputs = ConfigParser.parse(context);
            for (Map.Entry<String, String> entry : outputs.entrySet()) {
                File outputFile = new File(outputDir, entry.getKey());
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new ConfigParserException("Error while creating new directory " + outputFilePath);
                }
                if (!outputFile.createNewFile() && log.isDebugEnabled()) {
                    log.debug((Object)(outputFile.getAbsolutePath() + "File already exist"));
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), Charset.forName("UTF-8"));
                Throwable throwable = null;
                try {
                    outputStreamWriter.write(entry.getValue());
                    changedFileSet.add(outputFile.getAbsolutePath());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStreamWriter == null) continue;
                    if (throwable != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStreamWriter.close();
                }
            }
        }
        return changedFileSet;
    }

    static Map<String, String> parse(Context context) throws ConfigParserException {
        File templateDir = ConfigParser.checkTemplateDirExistence(ConfigPaths.getTemplateFileDir());
        context = TomlParser.parse(context);
        context = KeyMapper.mapWithConfig(context, ConfigPaths.getMappingFilePath());
        context = ValueInferrer.infer(context, ConfigPaths.getInferConfigurationFilePath());
        context = DefaultParser.addDefaultValues(context, ConfigPaths.getDefaultValueFilePath());
        ReferenceResolver.resolve(context);
        UnitResolver.updateUnits(context, ConfigPaths.getUnitResolverFilePath());
        Validator.validate(context, ConfigPaths.getValidatorFilePath());
        parsedConfigs = context.getTemplateData();
        if (Boolean.getBoolean("configParseOnly")) {
            return new HashMap<String, String>();
        }
        Map<String, File> fileNames = ConfigParser.getTemplatedFilesMap(templateDir);
        return JinjaParser.parse(context, fileNames);
    }

    private static File checkTemplateDirExistence(String templateFileDir) throws ConfigParserException {
        File templateDir = new File(templateFileDir);
        if (!templateDir.exists() || !templateDir.isDirectory()) {
            throw new ConfigParserException(String.format("Template directory (%s) does not exist or is not a directory", templateDir.getAbsolutePath()));
        }
        return templateDir;
    }

    private static Map<String, File> getTemplatedFilesMap(File templateDir) {
        LinkedHashMap<String, File> fileNames = new LinkedHashMap<String, File>();
        File[] files = templateDir.listFiles();
        if (Objects.nonNull(files)) {
            for (File file : files) {
                if (file.isFile() && file.getPath().endsWith(JINJA_TEMPLATE_EXTENSION)) {
                    fileNames.put(ConfigParser.getRelativeFilePath(file, file), file);
                    continue;
                }
                ConfigParser.handleDirectories(file, fileNames, file);
            }
        }
        return fileNames;
    }

    private static String getRelativeFilePath(File basePath, File file) {
        String fileName = basePath.getParentFile().toPath().relativize(file.toPath()).toString();
        if (file.getName().endsWith(JINJA_TEMPLATE_EXTENSION)) {
            fileName = fileName.substring(0, fileName.length() - JINJA_TEMPLATE_EXTENSION.length());
        }
        return fileName;
    }

    public static Map<String, Object> getParsedConfigs() {
        return parsedConfigs;
    }

    private static void handleDirectories(File basePath, Map<String, File> files, File file) {
        File[] fileList = file.listFiles();
        if (fileList != null) {
            for (File currentFile : fileList) {
                if (currentFile.isDirectory()) {
                    ConfigParser.handleDirectories(basePath, files, currentFile);
                    continue;
                }
                if (!currentFile.getPath().endsWith(JINJA_TEMPLATE_EXTENSION)) continue;
                files.put(ConfigParser.getRelativeFilePath(basePath, currentFile), currentFile);
            }
        }
    }

    public static class ConfigPaths {
        private static String configFilePath;
        private static String resourcesDir;
        private static String outputDir;
        private static String templateFileDir;
        private static String inferConfigurationFilePath;
        private static String defaultValueFilePath;
        private static String unitResolverFilePath;
        private static String validatorFilePath;
        private static String mappingFilePath;
        private static String metadataFilePath;
        private static String metadataTemplateFilePath;
        private static String metadataPropertyPath;

        private ConfigPaths() {
        }

        static void setPaths(String configFilePath, String resourcesDir, String outputDir) {
            ConfigPaths.configFilePath = configFilePath;
            ConfigPaths.resourcesDir = resourcesDir;
            ConfigPaths.outputDir = outputDir;
            templateFileDir = resourcesDir + File.separator + ConfigParser.TEMPLATE_FILE_DIR;
            inferConfigurationFilePath = resourcesDir + File.separator + ConfigParser.INFER_CONFIG_FILE_PATH;
            defaultValueFilePath = resourcesDir + File.separator + ConfigParser.DEFAULT_VALUE_FILE_PATH;
            unitResolverFilePath = resourcesDir + File.separator + ConfigParser.UNIT_RESOLVER_FILE_PATH;
            validatorFilePath = resourcesDir + File.separator + ConfigParser.VALIDATOR_FILE_PATH;
            mappingFilePath = resourcesDir + File.separator + ConfigParser.MAPPING_FILE_PATH;
            metadataFilePath = resourcesDir + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.META_DATA_CONFIG_FILE;
            metadataTemplateFilePath = resourcesDir + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.META_DATA_TEMPLATE_FILE;
            metadataPropertyPath = resourcesDir + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.CONFIG_PROPERTIES_FILE;
        }

        static String getConfigFilePath() {
            return configFilePath;
        }

        static void setConfigFilePath(String configFilePath) {
            ConfigPaths.configFilePath = configFilePath;
        }

        static String getResourcesDir() {
            return resourcesDir;
        }

        static String getOutputDir() {
            return outputDir;
        }

        static String getTemplateFileDir() {
            return templateFileDir;
        }

        static String getInferConfigurationFilePath() {
            return inferConfigurationFilePath;
        }

        static String getDefaultValueFilePath() {
            return defaultValueFilePath;
        }

        static String getUnitResolverFilePath() {
            return unitResolverFilePath;
        }

        static String getValidatorFilePath() {
            return validatorFilePath;
        }

        static String getMappingFilePath() {
            return mappingFilePath;
        }

        static String getMetadataFilePath() {
            return metadataFilePath;
        }

        static String getMetadataPropertyPath() {
            return metadataPropertyPath;
        }

        static String getMetadataTemplateFilePath() {
            return metadataTemplateFilePath;
        }

        static void setMetadataFilePaths(String metadataFilePath) {
            ConfigPaths.metadataFilePath = metadataFilePath + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.META_DATA_CONFIG_FILE;
            metadataTemplateFilePath = metadataFilePath + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.META_DATA_TEMPLATE_FILE;
            metadataPropertyPath = metadataFilePath + File.separator + ConfigParser.META_DATA_DIRECTORY + File.separator + ConfigParser.CONFIG_PROPERTIES_FILE;
        }
    }
}

