/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

public class ReferenceResolver {
    private static final String CONF_PLACEHOLDER_PREFIX = "$ref{";
    private static final String SYS_PROPERTY_PLACEHOLDER_PREFIX = "$sys{";
    private static final String SECRET_PROPERTY_PLACEHOLDER_PREFIX = "$secret{";
    private static final String ENV_VAR_PLACEHOLDER_PREFIX = "$env{";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String PLAIN_TEXT_VALUE_PLACE_HOLDER_PREFIX = "[";
    private static final String PLAIN_TEXT_VALUE_PLACE_HOLDER_SUFFIX = "]";

    private ReferenceResolver() {
    }

    public static void resolve(Context context) throws ConfigParserException {
        String avoidResolvingEnvAndSysVariable = System.getProperty("avoidResolvingEnvAndSysVariables");
        if ("true".equalsIgnoreCase(avoidResolvingEnvAndSysVariable)) {
            ReferenceResolver.resolveWithoutDynamicVariable(context.getTemplateData(), context.getSecrets());
        } else {
            ReferenceResolver.resolve(context.getTemplateData(), context.getSecrets(), context.getResolvedSystemProperties(), context.getResolvedEnvironmentVariables());
        }
    }

    static void resolveWithoutDynamicVariable(Map<String, Object> templateData, Map<String, String> secrets) throws ConfigParserException {
        ReferenceResolver.resolveSecrets(templateData, secrets);
        ReferenceResolver.resolveConfigReferences(templateData);
    }

    static void resolve(Map<String, Object> templateData, Map<String, String> secrets, Map<String, String> resolvedSystemProperties, Map<String, String> resolvedEnvironmentVariables) throws ConfigParserException {
        ReferenceResolver.resolveSecrets(templateData, secrets);
        ReferenceResolver.resolveSystemProperties(templateData, resolvedSystemProperties);
        ReferenceResolver.resolveEnvVariables(templateData, resolvedEnvironmentVariables);
        ReferenceResolver.resolveConfigReferences(templateData);
    }

    private static void resolveConfigReferences(Map<String, Object> context) throws ConfigParserException {
        LinkedHashMap<String, Set> unresolvedKeys = new LinkedHashMap<String, Set>();
        LinkedHashMap valuesToResolve = new LinkedHashMap();
        context.forEach((key, value) -> {
            if (value instanceof String) {
                ReferenceResolver.extractPlaceholdersFromString(key, (String)value, unresolvedKeys, valuesToResolve);
            } else if (value instanceof ArrayList) {
                for (Object elementItem : (ArrayList)value) {
                    if (!(elementItem instanceof String)) continue;
                    ReferenceResolver.extractPlaceholdersFromString(key, (String)elementItem, unresolvedKeys, valuesToResolve);
                }
            }
        });
        boolean atLeastOneResolved = true;
        while (!valuesToResolve.isEmpty() && atLeastOneResolved) {
            atLeastOneResolved = false;
            HashSet resolvedInIteration = new HashSet();
            for (Map.Entry entry2 : valuesToResolve.entrySet()) {
                if (unresolvedKeys.containsKey(entry2.getKey())) continue;
                ReferenceResolver.resolvePropertyPlaceholders(context, (String)entry2.getKey(), (Set)entry2.getValue());
                resolvedInIteration.add(entry2.getKey());
                atLeastOneResolved = true;
            }
            unresolvedKeys.forEach((key, value) -> value.removeIf(key1 -> !unresolvedKeys.containsKey(key1)));
            unresolvedKeys.keySet().removeIf(entry -> ((Set)unresolvedKeys.get(entry)).isEmpty());
            valuesToResolve.keySet().removeAll(resolvedInIteration);
        }
        if (!valuesToResolve.isEmpty()) {
            throw new ConfigParserException("References can't be resolved for " + StringUtils.join(unresolvedKeys.keySet(), (String)","));
        }
    }

    private static void extractPlaceholdersFromString(String key, String value, Map<String, Set<String>> unresolvedKeys, Map<String, Set<String>> valuesToResolve) {
        String[] fileRefs = StringUtils.substringsBetween((String)value, (String)CONF_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        if (fileRefs != null && fileRefs.length > 0) {
            for (String ref : fileRefs) {
                Set dependentKeys = valuesToResolve.getOrDefault(ref, new HashSet());
                Set keysUsed = unresolvedKeys.getOrDefault(key, new HashSet());
                dependentKeys.add(key);
                keysUsed.add(ref);
                valuesToResolve.put(ref, dependentKeys);
                unresolvedKeys.put(key, keysUsed);
            }
        }
    }

    private static void resolveSystemProperties(Map<String, Object> context, Map references) throws ConfigParserException {
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (entry.getValue() instanceof String) {
                context.replace(entry.getKey(), ReferenceResolver.resolveStringWithSysVarPlaceholders((String)entry.getValue(), references));
                continue;
            }
            if (entry.getValue() instanceof List) {
                ListIterator<String> listIterator = ((List)entry.getValue()).listIterator();
                while (listIterator.hasNext()) {
                    Object value = listIterator.next();
                    if (value instanceof String) {
                        listIterator.remove();
                        listIterator.add(ReferenceResolver.resolveStringWithSysVarPlaceholders((String)value, references));
                        continue;
                    }
                    if (!(value instanceof Map)) continue;
                    ReferenceResolver.resolveSystemProperties((Map)value, references);
                }
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            ReferenceResolver.resolveSystemProperties((Map)entry.getValue(), references);
        }
    }

    private static void resolveSecrets(Map<String, Object> context, Map secrets) throws ConfigParserException {
        boolean enabledSecret = false;
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                enabledSecret = enabledSecret || ReferenceResolver.resolveStringWithSecretPlaceHolders(value, secrets);
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object v : (List)value) {
                if (v instanceof String) {
                    enabledSecret = enabledSecret || ReferenceResolver.resolveStringWithSecretPlaceHolders(v, secrets);
                    continue;
                }
                if (!(v instanceof Map)) continue;
                Set entries = ((Map)v).entrySet();
                for (Map.Entry entrySet : entries) {
                    enabledSecret = enabledSecret || ReferenceResolver.resolveStringWithSecretPlaceHolders(entrySet.getValue(), secrets);
                }
            }
        }
        System.setProperty("secVault.enabled", String.valueOf(enabledSecret));
    }

    private static boolean resolveStringWithSecretPlaceHolders(Object value, Map secrets) throws ConfigParserException {
        String[] secretRefs;
        boolean exists = false;
        if (value instanceof String && (secretRefs = StringUtils.substringsBetween((String)((String)value), (String)SECRET_PROPERTY_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX)) != null) {
            for (String secretRef : secretRefs) {
                String[] secretArray;
                Object secretValue = secrets.get(secretRef);
                if (secretValue == null) {
                    throw new ConfigParserException("Secret references can't be resolved for " + secretRef);
                }
                if (secretValue instanceof String && !Boolean.getBoolean("encryptSecrets") && (secretArray = StringUtils.substringsBetween((String)((String)secretValue), (String)PLAIN_TEXT_VALUE_PLACE_HOLDER_PREFIX, (String)PLAIN_TEXT_VALUE_PLACE_HOLDER_SUFFIX)) != null && secretArray.length > 0) {
                    throw new ConfigParserException("Secret references can't be plain text for " + secretRef);
                }
                exists = true;
            }
        }
        return exists;
    }

    private static void resolveEnvVariables(Map<String, Object> context, Map<String, String> references) throws ConfigParserException {
        for (Map.Entry<String, Object> entry : context.entrySet()) {
            if (entry.getValue() instanceof String) {
                context.replace(entry.getKey(), ReferenceResolver.resolveStringWithEnvVarPlaceholders((String)entry.getValue(), references));
                continue;
            }
            if (entry.getValue() instanceof List) {
                ListIterator<String> values = ((List)entry.getValue()).listIterator();
                while (values.hasNext()) {
                    Object value = values.next();
                    if (value instanceof String) {
                        values.remove();
                        values.add(ReferenceResolver.resolveStringWithEnvVarPlaceholders((String)value, references));
                        continue;
                    }
                    if (!(value instanceof Map)) continue;
                    ReferenceResolver.resolveEnvVariables((Map)value, references);
                }
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            ReferenceResolver.resolveEnvVariables((Map)entry.getValue(), references);
        }
    }

    private static void resolvePropertyPlaceholders(Map<String, Object> context, String key, Set<String> dependentKeys) throws ConfigParserException {
        Object value = context.get(key);
        if (Objects.isNull(value)) {
            throw new ConfigParserException("Configuration with key " + key + " doesn't exist");
        }
        for (String k : dependentKeys) {
            Object existingValue = context.get(k);
            if (value instanceof List) {
                context.put(k, value);
                continue;
            }
            if (value instanceof Boolean) {
                context.put(k, value);
                continue;
            }
            if (existingValue instanceof String) {
                existingValue = ((String)existingValue).replaceAll(Pattern.quote(CONF_PLACEHOLDER_PREFIX + key + PLACEHOLDER_SUFFIX), Matcher.quoteReplacement(value.toString()));
                context.put(k, existingValue);
                continue;
            }
            if (!(existingValue instanceof ArrayList)) continue;
            ArrayList<String> modifiedValueList = new ArrayList<String>();
            for (String item : (ArrayList)existingValue) {
                item = item.replaceAll(Pattern.quote(CONF_PLACEHOLDER_PREFIX + key + PLACEHOLDER_SUFFIX), Matcher.quoteReplacement(value.toString()));
                modifiedValueList.add(item);
            }
            context.put(k, modifiedValueList);
        }
    }

    private static String resolveStringWithSysVarPlaceholders(String value, Map resolvedSystemProperties) throws ConfigParserException {
        String[] sysRefs = StringUtils.substringsBetween((String)value, (String)SYS_PROPERTY_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        if (sysRefs != null) {
            for (String ref : sysRefs) {
                String property = System.getProperty(ref);
                if (!StringUtils.isNotEmpty((String)property)) {
                    throw new ConfigParserException("Error while retrieving " + ref + " system property");
                }
                resolvedSystemProperties.put(ref, property);
                value = value.replaceAll(Pattern.quote(SYS_PROPERTY_PLACEHOLDER_PREFIX + ref + PLACEHOLDER_SUFFIX), property);
            }
        }
        return value;
    }

    private static String resolveStringWithEnvVarPlaceholders(String value, Map resolvedEnvironmentVariables) throws ConfigParserException {
        String[] envRefs = StringUtils.substringsBetween((String)value, (String)ENV_VAR_PLACEHOLDER_PREFIX, (String)PLACEHOLDER_SUFFIX);
        if (envRefs != null) {
            for (String ref : envRefs) {
                String resolvedValue = System.getenv(ref);
                if (resolvedValue == null) {
                    throw new ConfigParserException("Environment variable " + ref + " not defined in system");
                }
                resolvedEnvironmentVariables.put(ref, resolvedValue);
                value = value.replaceAll(Pattern.quote(ENV_VAR_PLACEHOLDER_PREFIX + ref + PLACEHOLDER_SUFFIX), resolvedValue);
            }
        }
        return value;
    }
}

