/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.config.mapper;

import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.wso2.config.mapper.ConfigParserException;
import org.wso2.config.mapper.model.Context;

class UnitResolver {
    private static final String DAY_SUFFIX = "d";
    private static final String HOUR_SUFFIX = "h";
    private static final String MINUTE_SUFFIX = "m";
    private static final String SECOND_SUFFIX = "s";
    private static final String MILLI_SECOND_SUFFIX = "ms";
    private static final String TIME = "time";
    private static Map<String, String> timeMapping;
    private static final Pattern REGEX;

    private UnitResolver() {
    }

    static void updateUnits(Context context, String unitConfigFilePath) throws ConfigParserException {
        UnitResolver.readConfiguration(unitConfigFilePath);
        UnitResolver.resolveTimeConfiguration(context.getTemplateData());
        timeMapping = null;
    }

    private static void readConfiguration(String configFile) throws ConfigParserException {
        Gson gson = new Gson();
        Map unitConfigs = null;
        try (FileInputStream fileInputStream = new FileInputStream(configFile);){
            Object timeConfigMapObj;
            InputStreamReader input = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
            unitConfigs = (Map)gson.fromJson((Reader)input, Map.class);
            if (unitConfigs.containsKey(TIME) && (timeConfigMapObj = unitConfigs.get(TIME)) instanceof Map) {
                timeMapping = (Map)timeConfigMapObj;
            }
        }
        catch (IOException e) {
            throw new ConfigParserException("Error while reading unit config file", e);
        }
    }

    private static void resolveTimeConfiguration(Map<String, Object> context) throws ConfigParserException {
        if (timeMapping != null) {
            for (Map.Entry<String, String> entry : timeMapping.entrySet()) {
                if (!context.containsKey(entry.getKey())) continue;
                context.put(entry.getKey(), UnitResolver.getResolvedValue(entry.getKey(), context.get(entry.getKey()), entry.getValue()));
            }
        }
    }

    private static String getResolvedValue(String key, Object value, String expectedUnit) throws ConfigParserException {
        if (value instanceof Integer || value instanceof Double || value instanceof Long) {
            return String.valueOf(value);
        }
        if (value == null) {
            throw new ConfigParserException(String.format("Invalid value for configuration key %s. Value is null", key));
        }
        if (!(value instanceof String)) {
            throw new ConfigParserException(String.format("Invalid value for configuration key %s. Value type is %s", key, value.getClass().getName()));
        }
        String stringValue = (String)value;
        Matcher matcher = REGEX.matcher(stringValue);
        if (matcher.find()) {
            Double numericValue = Double.valueOf(matcher.group(1));
            String unit = matcher.group(2);
            if (StringUtils.isEmpty((String)unit)) {
                return (String)value;
            }
            TimeUnit sourceUnit = UnitResolver.getTimeUnit(unit);
            TimeUnit destinationUnit = UnitResolver.getTimeUnit(expectedUnit);
            long convertedValue = destinationUnit.convert(numericValue.longValue(), sourceUnit);
            if (convertedValue == 0L && numericValue.longValue() != 0L) {
                throw new ConfigParserException(String.format("Converted value result in 0 for non zero source value. key: %s, value given = %s, converted value = 0 %s", key, stringValue, destinationUnit.toString()));
            }
            return String.valueOf(convertedValue);
        }
        throw new ConfigParserException(String.format("Invalid configuration value %s = %s", key, value));
    }

    private static TimeUnit getTimeUnit(String unit) throws ConfigParserException {
        switch (unit) {
            case "d": {
                return TimeUnit.DAYS;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
        }
        throw new ConfigParserException("Invalid unit : " + unit);
    }

    static {
        REGEX = Pattern.compile("(\\d+(?:\\.\\d+)?)\\s*(\\w*)");
    }
}

