/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.postexecutor;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.utils.ConfigMapHolder;

public class SFTPUploader {
    private static final Logger log = LogManager.getLogger(SFTPUploader.class);

    public void uploadFile(String zipFilePath, String zipFileName) {
        try {
            Map<String, Object> configMap = ConfigMapHolder.getInstance().getConfigMap();
            String sftpServer = configMap.get("sftp_uploader.host").toString();
            String sftpUser = configMap.get("sftp_uploader.username").toString();
            String sftpPassword = configMap.get("sftp_uploader.password").toString();
            int sftpPort = Integer.parseInt(configMap.get("sftp_uploader.port").toString());
            Object sftpDir = configMap.get("sftp_uploader.directory").toString();
            String knownHosts = configMap.get("sftp_uploader.known_hosts_path").toString();
            String strictHostKeyChecking = configMap.get("sftp_uploader.strict_host_key_checking").toString();
            JSch jsch = new JSch();
            if (StringUtils.isNotEmpty((CharSequence)knownHosts)) {
                jsch.setKnownHosts(knownHosts);
            }
            if (StringUtils.isEmpty((CharSequence)sftpServer) || StringUtils.isEmpty((CharSequence)sftpUser) || StringUtils.isEmpty((CharSequence)sftpPassword) || StringUtils.isEmpty((CharSequence)sftpDir) || sftpPort == 0) {
                log.info("SFTP server details are not provided. Hence skipping the SFTP upload.");
                return;
            }
            Session session = jsch.getSession(sftpUser, sftpServer, sftpPort);
            session.setPassword(sftpPassword);
            if (StringUtils.equals((CharSequence)strictHostKeyChecking, (CharSequence)"no")) {
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
            }
            session.connect();
            ChannelSftp sftpChannel = (ChannelSftp)session.openChannel("sftp");
            sftpChannel.connect();
            File zipFile = new File(zipFilePath + zipFileName);
            if (!((String)sftpDir).endsWith(File.separator)) {
                sftpDir = (String)sftpDir + File.separator;
            }
            String remoteFile = (String)sftpDir + zipFileName;
            sftpChannel.put((InputStream)new FileInputStream(zipFile), remoteFile);
            sftpChannel.exit();
            session.disconnect();
            log.info("Successfully uploaded the zip file to SFTP server at " + sftpServer + " to the directory " + (String)sftpDir);
        }
        catch (Exception e) {
            log.error("Error occurred while uploading the zip file to SFTP server.", (Throwable)e);
        }
    }
}

