/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.watchers.logwatcher;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.diagnostics.watchers.logwatcher.Interpreter;

public class LogWatcher
extends Thread {
    private static final Logger log = LogManager.getLogger(LogWatcher.class);
    private final File file;
    private final long delay;
    private final Interpreter interpreter;

    public LogWatcher(String filepath, Interpreter interpreter, double delay) {
        this.file = new File(filepath);
        this.delay = Math.round(delay * 1000.0);
        this.interpreter = interpreter;
    }

    @Override
    public void run() {
        try {
            RandomAccessFile reader = null;
            long position = 0L;
            StringBuilder logBuilder = new StringBuilder();
            while (reader == null) {
                try {
                    reader = new RandomAccessFile(this.file, "r");
                    log.info("Initiating LogWatcher for file: " + this.file.getPath());
                    position = this.file.length();
                    reader.seek(position);
                }
                catch (FileNotFoundException e) {
                    log.debug("Log file " + this.file.getPath() + " not found.");
                    Thread.sleep(this.delay);
                }
            }
            while (true) {
                long fileLength;
                if ((fileLength = this.file.length()) < position) {
                    log.info("Log file has been rotated. Reopening the file " + this.file.getPath());
                    try {
                        this.closeQuietly(reader);
                        reader = new RandomAccessFile(this.file, "r");
                        this.readLines(reader, logBuilder);
                        position = 0L;
                    }
                    catch (FileNotFoundException e) {
                        log.error("Log file " + this.file.getPath() + " not found.", (Throwable)e);
                    }
                    continue;
                }
                if (fileLength > position) {
                    this.readLines(reader, logBuilder);
                    position = fileLength;
                    reader.seek(fileLength);
                }
                Thread.sleep(this.delay);
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Error while tailing the log file: " + this.file.getPath(), (Throwable)e);
            return;
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            log.error("unable to close the file: " + this.file.getPath(), (Throwable)ioe);
        }
    }

    private void readLines(RandomAccessFile reader, StringBuilder logBuilder) throws IOException {
        String line;
        String errorLine = "";
        while ((line = reader.readLine()) != null) {
            if (line.contains("ERROR") || line.contains("WARN")) {
                if (logBuilder.length() == 0) {
                    errorLine = line;
                    logBuilder.append(line).append("\n");
                    continue;
                }
                this.interpreter.interpret(errorLine, logBuilder.toString());
                logBuilder.setLength(0);
                errorLine = line;
                logBuilder.append(line).append("\n");
                continue;
            }
            logBuilder.append(line).append("\n");
        }
    }
}

