/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.diagnostics.utils;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.consensys.cava.toml.Toml;
import net.consensys.cava.toml.TomlArray;
import net.consensys.cava.toml.TomlParseResult;
import net.consensys.cava.toml.TomlTable;

public class TomlParser {
    public static Map<String, Object> parse(String filePath) throws IOException {
        Path source = Paths.get(filePath, new String[0]);
        TomlParseResult result = Toml.parse((Path)source);
        result.errors().forEach(error -> System.err.println(error.toString()));
        return TomlParser.parseToml(result);
    }

    private static Map<String, Object> parseToml(TomlParseResult result) {
        LinkedHashMap<String, Object> templateContext = new LinkedHashMap<String, Object>();
        Set dottedKeySet = result.dottedKeySet();
        for (String dottedKey : dottedKeySet) {
            dottedKey = dottedKey.replaceAll("\"", "'");
            templateContext.put(dottedKey, TomlParser.getValue(result.get(dottedKey)));
        }
        return templateContext;
    }

    private static Object getValue(Object value) {
        Object returnValue = value instanceof TomlArray ? TomlParser.processTomlArray((TomlArray)value) : (value instanceof TomlTable ? TomlParser.processTomlMap((TomlTable)value) : value);
        return returnValue;
    }

    private static List<Object> processTomlArray(TomlArray value) {
        ArrayList<Object> finalList = new ArrayList<Object>();
        List tomlList = value.toList();
        for (Object obj : tomlList) {
            if (obj instanceof TomlArray) {
                finalList.add(TomlParser.processTomlArray((TomlArray)obj));
                continue;
            }
            if (obj instanceof TomlTable) {
                finalList.add(TomlParser.processTomlMap((TomlTable)obj));
                continue;
            }
            finalList.add(obj);
        }
        return finalList;
    }

    private static Map<String, Object> processTomlMap(TomlTable tomlTable) {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        Set dottedKeySet = tomlTable.dottedKeySet();
        for (String key : dottedKeySet) {
            Object value = tomlTable.get(key = key.replaceAll("\"", "'"));
            if (value instanceof TomlArray) {
                finalMap.put(key, TomlParser.processTomlArray((TomlArray)value));
                continue;
            }
            finalMap.put(key, tomlTable.get(key));
        }
        return finalMap;
    }
}

