/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.localentry;

import java.io.IOException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminException;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminServiceStub;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class LocalEntryAdminService {
    private static final Log log = LogFactory.getLog(LocalEntryAdminService.class);
    private final String serviceName = "LocalEntryAdmin";
    private LocalEntryAdminServiceStub localEntryAdminServiceStub;
    private String endPoint;

    public LocalEntryAdminService(String backEndUrl) throws AxisFault {
        this.endPoint = backEndUrl + "LocalEntryAdmin";
        this.localEntryAdminServiceStub = new LocalEntryAdminServiceStub(this.endPoint);
    }

    public void addLocalEntry(String sessionCookie, DataHandler dh) throws LocalEntryAdminException, IOException, XMLStreamException {
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.localEntryAdminServiceStub);
        XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(dh.getInputStream());
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement localEntryElem = builder.getDocumentElement();
        this.localEntryAdminServiceStub.addEntry(localEntryElem.toString());
    }

    public void deleteLocalEntry(String sessionCookie, String localEntryKey) throws LocalEntryAdminException, RemoteException {
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.localEntryAdminServiceStub);
        this.localEntryAdminServiceStub.deleteEntry(localEntryKey);
    }

    public OMElement getLocalEntry(String sessionCookie, String localEntryKey) throws LocalEntryAdminException, RemoteException {
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.localEntryAdminServiceStub);
        return (OMElement)this.localEntryAdminServiceStub.getEntry(localEntryKey);
    }
}

