/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.mediation;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.wso2.carbon.mediation.configadmin.stub.ConfigServiceAdminStub;
import org.wso2.carbon.mediation.configadmin.stub.types.carbon.ConfigurationInformation;
import org.wso2.carbon.mediation.configadmin.stub.types.carbon.ValidationError;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;
import org.xml.sax.SAXException;

public class SynapseConfigAdminClient {
    private static final Log log = LogFactory.getLog(SynapseConfigAdminClient.class);
    private final String serviceName = "ConfigServiceAdmin";
    private ConfigServiceAdminStub configServiceAdminStub;

    public SynapseConfigAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "ConfigServiceAdmin";
        this.configServiceAdminStub = new ConfigServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.configServiceAdminStub);
    }

    public SynapseConfigAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "ConfigServiceAdmin";
        this.configServiceAdminStub = new ConfigServiceAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.configServiceAdminStub);
    }

    private static OMElement createOMElement(String xml) throws ServletException, XMLStreamException {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public void activateService(String serviceName) throws RemoteException {
        this.configServiceAdminStub.activate(serviceName);
    }

    public void addExistingConfiguration(String serviceName) throws RemoteException {
        this.configServiceAdminStub.addExistingConfiguration(serviceName);
    }

    public void create(String serviceName, String description) throws RemoteException {
        this.configServiceAdminStub.create(serviceName, description);
    }

    public void deleteConfiguration(String serviceName) throws RemoteException {
        this.configServiceAdminStub.deleteConfiguration(serviceName);
    }

    public String getConfiguration() throws RemoteException {
        return this.configServiceAdminStub.getConfiguration();
    }

    public ConfigurationInformation[] getConfigurationList() throws RemoteException {
        return this.configServiceAdminStub.getConfigurationList();
    }

    public void saveConfigurationToDisk() throws RemoteException {
        this.configServiceAdminStub.saveConfigurationToDisk();
    }

    public boolean updateConfiguration(String configuration) throws XMLStreamException, ServletException, RemoteException {
        return this.configServiceAdminStub.updateConfiguration(SynapseConfigAdminClient.createOMElement(configuration));
    }

    public boolean updateConfiguration(File file) throws IOException, SAXException, ParserConfigurationException, TransformerException, XMLStreamException, ServletException {
        boolean success = false;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (file.exists()) {
            Document doc = docBuilder.parse(file);
            String fileContent = this.getStringFromDocument(doc);
            success = this.configServiceAdminStub.updateConfiguration(SynapseConfigAdminClient.createOMElement(fileContent));
        }
        return success;
    }

    public boolean updateConfiguration(OMElement configuration) throws XMLStreamException, ServletException, RemoteException {
        return this.configServiceAdminStub.updateConfiguration(configuration);
    }

    public ValidationError[] validateConfiguration(OMElement configuration) throws RemoteException {
        return this.configServiceAdminStub.validateConfiguration(configuration);
    }

    private String getStringFromDocument(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

