/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.registry;

import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.reporting.stub.ReportingAdminServiceStub;
import org.wso2.carbon.registry.reporting.stub.beans.xsd.ReportConfigurationBean;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class ReportAdminServiceClient {
    private static final Log log = LogFactory.getLog(ReportAdminServiceClient.class);
    private final String serviceName = "ReportingAdminService";
    private ReportingAdminServiceStub reportingAdminServiceStub;

    public ReportAdminServiceClient(String backendURL, String sessionCookie) throws AxisFault {
        String endPoint = backendURL + "ReportingAdminService";
        try {
            this.reportingAdminServiceStub = new ReportingAdminServiceStub(endPoint);
        }
        catch (AxisFault axisFault) {
            String err = "Stub initialization fail";
            log.error((Object)("Stub initialization fail" + axisFault.getMessage()));
            throw new AxisFault(err, (Throwable)axisFault);
        }
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.reportingAdminServiceStub);
    }

    public ReportAdminServiceClient(String backendURL, String userName, String password) throws AxisFault {
        String endPoint = backendURL + "ReportingAdminService";
        try {
            this.reportingAdminServiceStub = new ReportingAdminServiceStub(endPoint);
        }
        catch (AxisFault axisFault) {
            String err = "Stub initialization fail";
            log.error((Object)("Stub initialization fail" + axisFault.getMessage()));
            throw new AxisFault(err, (Throwable)axisFault);
        }
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.reportingAdminServiceStub);
    }

    public void saveReport(ReportConfigurationBean configuration) throws Exception {
        try {
            this.reportingAdminServiceStub.saveReport(configuration);
        }
        catch (Exception e) {
            String msg = "Unable to save report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public ReportConfigurationBean getSavedReport(String reportName) throws Exception {
        try {
            return this.reportingAdminServiceStub.getSavedReport(reportName);
        }
        catch (Exception e) {
            String msg = "Unable get saved report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public DataHandler getReportBytes(ReportConfigurationBean configuration) throws Exception {
        try {
            return this.reportingAdminServiceStub.getReportBytes(configuration);
        }
        catch (Exception e) {
            String msg = "Unable get Report in bytes";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public void deleteSavedReport(String name) throws Exception {
        try {
            this.reportingAdminServiceStub.deleteSavedReport(name);
        }
        catch (Exception e) {
            String msg = "Unable to delete saved report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public ReportConfigurationBean[] getSavedReports() throws Exception {
        try {
            return this.reportingAdminServiceStub.getSavedReports();
        }
        catch (Exception e) {
            String msg = "Unable to get saved report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public String[] getAttributeNames(String className) throws Exception {
        try {
            return this.reportingAdminServiceStub.getAttributeNames(className);
        }
        catch (Exception e) {
            String msg = "Unable to get attribute names";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public String[] getMandatoryAttributeNames(String className) throws Exception {
        try {
            return this.reportingAdminServiceStub.getMandatoryAttributeNames(className);
        }
        catch (Exception e) {
            String msg = "Unable to get mandatory attribute names";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public void copySavedReport(String saved, String copy) throws Exception {
        try {
            this.reportingAdminServiceStub.copySavedReport(saved, copy);
        }
        catch (Exception e) {
            String msg = "Unable to copy the report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public void scheduleReport(ReportConfigurationBean configuration) throws Exception {
        try {
            this.reportingAdminServiceStub.scheduleReport(configuration);
        }
        catch (Exception e) {
            String msg = "Unable to schedule the report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public void stopScheduledReport(String reportName) throws Exception {
        try {
            this.reportingAdminServiceStub.stopScheduledReport(reportName);
        }
        catch (Exception e) {
            String msg = "Unable to stop the scheduled report";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }
}

