/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.registry;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.properties.stub.PropertiesAdminServiceRegistryExceptionException;
import org.wso2.carbon.registry.properties.stub.PropertiesAdminServiceStub;
import org.wso2.carbon.registry.properties.stub.beans.xsd.PropertiesBean;
import org.wso2.carbon.registry.properties.stub.beans.xsd.RetentionBean;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class PropertiesAdminServiceClient {
    private static final Log log = LogFactory.getLog(PropertiesAdminServiceClient.class);
    private PropertiesAdminServiceStub propertiesAdminServiceStub;
    private final String serviceName = "PropertiesAdminService";

    public PropertiesAdminServiceClient(String backendURL, String sessionCookie) throws AxisFault {
        String endPoint = backendURL + "PropertiesAdminService";
        this.propertiesAdminServiceStub = new PropertiesAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.propertiesAdminServiceStub);
    }

    public PropertiesAdminServiceClient(String backendURL, String userName, String password) throws AxisFault {
        String endPoint = backendURL + "PropertiesAdminService";
        this.propertiesAdminServiceStub = new PropertiesAdminServiceStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.propertiesAdminServiceStub);
    }

    public void setRetentionProperties(String path, String mode, String fromDate, String toDate) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        RetentionBean retentionBean = new RetentionBean();
        retentionBean.setWriteLocked(mode.contains("write"));
        retentionBean.setDeleteLocked(mode.contains("delete"));
        retentionBean.setFromDate(fromDate);
        retentionBean.setToDate(toDate);
        try {
            this.propertiesAdminServiceStub.setRetentionProperties(path, retentionBean);
        }
        catch (RemoteException e) {
            log.error((Object)"Set retention properties failed ", (Throwable)e);
            throw new RemoteException("Set retention properties failed ", e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            log.error((Object)"Set retention lock failed ", (Throwable)e);
            throw new PropertiesAdminServiceRegistryExceptionException("Set retention properties failed ", (Throwable)e);
        }
    }

    public RetentionBean getRetentionProperties(String path) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        RetentionBean retentionBean = new RetentionBean();
        try {
            retentionBean = this.propertiesAdminServiceStub.getRetentionProperties(path);
        }
        catch (RemoteException e) {
            log.error((Object)"get retention properties failed ", (Throwable)e);
            throw new RemoteException("get retention properties failed ", e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            log.error((Object)"get retention properties failed ", (Throwable)e);
            throw new PropertiesAdminServiceRegistryExceptionException("get retention properties failed ", (Throwable)e);
        }
        return retentionBean;
    }

    public void setProperty(String path, String name, String value) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        try {
            this.propertiesAdminServiceStub.setProperty(path, name, value);
        }
        catch (RemoteException e) {
            String errMsg = "Adding property fails";
            log.error((Object)errMsg);
            throw new RemoteException(errMsg, e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            String errMsg = "Adding property fails";
            log.error((Object)errMsg);
            throw new PropertiesAdminServiceRegistryExceptionException(errMsg, (Throwable)e);
        }
    }

    public PropertiesBean getProperty(String path, String viewProps) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        try {
            return this.propertiesAdminServiceStub.getProperties(path, viewProps);
        }
        catch (RemoteException e) {
            String errMsg = "Getting property fails";
            log.error((Object)errMsg);
            throw new RemoteException(errMsg, e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            String errMsg = "Getting property fails";
            log.error((Object)errMsg);
            throw new PropertiesAdminServiceRegistryExceptionException(errMsg, (Throwable)e);
        }
    }

    public PropertiesBean getProperties(String path, String viewProps) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        try {
            return this.propertiesAdminServiceStub.getProperties(path, viewProps);
        }
        catch (RemoteException e) {
            String errMsg = "Getting properties fails";
            log.error((Object)errMsg);
            throw new RemoteException(errMsg, e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            String errMsg = "Getting properties fails";
            log.error((Object)errMsg);
            throw new PropertiesAdminServiceRegistryExceptionException(errMsg, (Throwable)e);
        }
    }

    public void updateProperty(String path, String name, String value, String oldValue) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        try {
            this.propertiesAdminServiceStub.updateProperty(path, name, value, oldValue);
        }
        catch (RemoteException e) {
            String errMsg = "Update properties fails";
            log.error((Object)errMsg);
            throw new RemoteException(errMsg, e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            String errMsg = "Update properties fails";
            log.error((Object)errMsg);
            throw new PropertiesAdminServiceRegistryExceptionException(errMsg, (Throwable)e);
        }
    }

    public void removeProperty(String path, String viewProps) throws RemoteException, PropertiesAdminServiceRegistryExceptionException {
        try {
            this.propertiesAdminServiceStub.removeProperty(path, viewProps);
        }
        catch (RemoteException e) {
            String errMsg = "Removing property fails";
            log.error((Object)errMsg);
            throw new RemoteException(errMsg, e);
        }
        catch (PropertiesAdminServiceRegistryExceptionException e) {
            String errMsg = "Removing property fails";
            log.error((Object)errMsg);
            throw new PropertiesAdminServiceRegistryExceptionException(errMsg, (Throwable)e);
        }
    }
}

