/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.jmsserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.JMSBrokerController;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfiguration;
import org.wso2.carbon.automation.extensions.servers.jmsserver.controller.config.JMSBrokerConfigurationProvider;

public class ActiveMQServerExtension
extends ExecutionListenerExtension {
    private static final Log log = LogFactory.getLog(ActiveMQServerExtension.class);
    private static JMSBrokerController activeMqBroker;

    public void initiate() throws AutomationFrameworkException {
        activeMqBroker = new JMSBrokerController("localhost", this.getJMSBrokerConfiguration());
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        if (!JMSBrokerController.isBrokerStarted()) {
            log.info((Object)"String JMS Broker...");
            activeMqBroker.start();
        }
    }

    public void onExecutionFinish() throws AutomationFrameworkException {
        if (activeMqBroker != null) {
            log.info((Object)"Stopping JMS broker...");
            activeMqBroker.stop();
        }
    }

    private JMSBrokerConfiguration getJMSBrokerConfiguration() {
        return JMSBrokerConfigurationProvider.getInstance().getBrokerConfiguration();
    }

    public static JMSBrokerController getJMSBrokerController() {
        return activeMqBroker;
    }

    public static void startMQServer() {
        activeMqBroker.start();
    }

    public static void stopMQServer() {
        activeMqBroker.stop();
    }

    public static boolean isMQServerStarted() {
        return activeMqBroker.isBrokerStarted();
    }
}

