/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;
import org.wso2.esb.integration.common.extensions.carbonserver.TestServerManager;

public class CarbonServerExtension
extends ExecutionListenerExtension {
    private static TestServerManager serverManager;
    private static final Log log;
    private String executionEnvironment;

    public void initiate() {
        try {
            this.getParameters().putIfAbsent("-DportOffset", "0");
            serverManager = new TestServerManager(this.getAutomationContext(), null, this.getParameters()){};
            this.executionEnvironment = this.getAutomationContext().getConfigurationValue("//executionEnvironment/text()");
        }
        catch (XPathExpressionException e) {
            CarbonServerExtension.handleException("Error while initiating test environment", e);
        }
    }

    public void onExecutionStart() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                String carbonHome = serverManager.startServer();
                System.setProperty("carbon.home", carbonHome);
            }
        }
        catch (Exception e) {
            CarbonServerExtension.handleException("Fail to start carbon server ", e);
        }
    }

    public void onExecutionFinish() {
        try {
            if (this.executionEnvironment.equalsIgnoreCase(ExecutionEnvironment.STANDALONE.name())) {
                serverManager.stopServer();
            }
        }
        catch (Exception e) {
            log.error((Object)"Fail to stop carbon server ", (Throwable)e);
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }

    public static void restartServer() {
        try {
            serverManager.restartServer();
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while restarting the server", e);
        }
    }

    public static void restartServer(Map<String, String> commandMap) {
        try {
            serverManager.restartServer(commandMap);
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while restarting the server", e);
        }
    }

    public static void startServer() {
        try {
            serverManager.startMIServer();
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while starting the MI server", e);
        }
    }

    public static void shutdownServer() {
        try {
            serverManager.stopServer();
        }
        catch (AutomationFrameworkException e) {
            throw new RuntimeException("Exception occurred while shutdown the server", e);
        }
    }

    static {
        log = LogFactory.getLog(CarbonServerExtension.class);
    }
}

