/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.aspects.flow.statistics.publishing.PublishingPayload;
import org.testng.Assert;
import org.wso2.carbon.endpoint.stub.types.EndpointAdminEndpointAdminException;
import org.wso2.carbon.inbound.stub.types.carbon.InboundEndpointDTO;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminException;
import org.wso2.carbon.mediation.library.stub.MediationLibraryAdminServiceException;
import org.wso2.carbon.mediation.library.stub.upload.types.carbon.LibraryFileItem;
import org.wso2.carbon.proxyadmin.stub.ProxyServiceAdminProxyAdminException;
import org.wso2.carbon.rest.api.stub.RestApiAdminAPIException;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.carbon.task.stub.TaskManagementException;
import org.wso2.esb.integration.common.clients.connector.MediationLibraryAdminServiceClient;
import org.wso2.esb.integration.common.clients.connector.MediationLibraryUploaderClient;
import org.wso2.esb.integration.common.clients.endpoint.EndPointAdminClient;
import org.wso2.esb.integration.common.clients.executor.PriorityMediationAdminClient;
import org.wso2.esb.integration.common.clients.inbound.endpoint.InboundAdminClient;
import org.wso2.esb.integration.common.clients.localentry.LocalEntriesAdminClient;
import org.wso2.esb.integration.common.clients.mediation.MessageProcessorClient;
import org.wso2.esb.integration.common.clients.mediation.MessageStoreAdminClient;
import org.wso2.esb.integration.common.clients.proxy.admin.ProxyServiceAdminClient;
import org.wso2.esb.integration.common.clients.rest.api.RestApiAdminClient;
import org.wso2.esb.integration.common.clients.sequences.SequenceAdminServiceClient;
import org.wso2.esb.integration.common.clients.service.mgt.ServiceAdminClient;
import org.wso2.esb.integration.common.clients.tasks.TaskAdminClient;
import org.wso2.esb.integration.common.clients.template.EndpointTemplateAdminServiceClient;
import org.wso2.esb.integration.common.clients.template.SequenceTemplateAdminServiceClient;
import org.wso2.esb.integration.common.utils.common.TestConfigurationProvider;

public class ESBTestCaseUtils {
    protected Log log = LogFactory.getLog(this.getClass());
    private static int SERVICE_DEPLOYMENT_DELAY = TestConfigurationProvider.getServiceDeploymentDelay();
    private static final String PROXY = "proxy";
    private static final String LOCAL_ENTRY = "localEntry";
    private static final String ENDPOINT = "endpoint";
    private static final String SEQUENCE = "sequence";
    private static final String MESSAGE_STORE = "messageStore";
    private static final String MESSAGE_PROCESSOR = "messageProcessor";
    private static final String TEMPLATE = "template";
    private static final String API = "api";
    private static final String PRIORITY_EXECUTOR = "priorityExecutor";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String TASK = "task";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement loadResource(String path) throws FileNotFoundException, XMLStreamException {
        OMElement documentElement = null;
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        path = TestConfigurationProvider.getResourceLocation() + path;
        File file = new File(path);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                builder = new StAXOMBuilder(parser);
                documentElement = builder.getDocumentElement().cloneOMElement();
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException e) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        throw new FileNotFoundException("File Not Exist at " + path);
        return documentElement;
    }

    public void loadESBConfigurationFrom(String synapseFilePath, String backendURL, String sessionCookie) throws Exception {
        OMElement configElement = this.loadResource(synapseFilePath);
        this.updateESBConfiguration(configElement, backendURL, sessionCookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement loadESBSampleConfiguration(int number) throws Exception {
        String filePath = Paths.get(TestConfigurationProvider.getResourceLocation("ESB"), "samples", "synapse_sample_" + number + ".xml").toString();
        File configFile = new File(filePath);
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        OMElement documentElement = null;
        try {
            inputStream = new FileInputStream(configFile.getAbsolutePath());
            parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            builder = new StAXOMBuilder(parser);
            documentElement = builder.getDocumentElement().cloneOMElement();
        }
        finally {
            if (builder != null) {
                builder.close();
            }
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (XMLStreamException e) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return documentElement;
    }

    public void updateESBConfiguration(OMElement synapseConfig, String backendURL, String sessionCookie) throws Exception {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backendURL, sessionCookie);
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backendURL, sessionCookie);
        SequenceAdminServiceClient sequenceAdminClient = new SequenceAdminServiceClient(backendURL, sessionCookie);
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backendURL, sessionCookie);
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backendURL, sessionCookie);
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backendURL, sessionCookie);
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backendURL, sessionCookie);
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backendURL, sessionCookie);
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backendURL, sessionCookie);
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backendURL, sessionCookie);
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backendURL, sessionCookie);
        TaskAdminClient taskAdminClient = new TaskAdminClient(backendURL, sessionCookie);
        Iterator localEntries = synapseConfig.getChildrenWithLocalName(LOCAL_ENTRY);
        while (localEntries.hasNext()) {
            OMElement localEntry = (OMElement)localEntries.next();
            String le = localEntry.getAttributeValue(new QName(KEY));
            if (ArrayUtils.contains((Object[])localEntryAdminServiceClient.getEntryNames(), (Object)le)) {
                Assert.assertTrue((boolean)localEntryAdminServiceClient.deleteLocalEntry(le), (String)(le + " Local Entry deletion failed"));
                Assert.assertTrue((boolean)this.isLocalEntryUnDeployed(backendURL, sessionCookie, le), (String)(le + " Local Entry undeployment failed"));
            }
            Assert.assertTrue((boolean)localEntryAdminServiceClient.addLocalEntry(localEntry), (String)" Local Entry addition failed");
            Assert.assertTrue((boolean)this.isLocalEntryDeployed(backendURL, sessionCookie, le), (String)" Local Entry deployment failed");
            this.log.info((Object)(le + " LocalEntry Uploaded"));
        }
        Iterator endpoints = synapseConfig.getChildrenWithLocalName(ENDPOINT);
        while (endpoints.hasNext()) {
            OMElement endpoint = (OMElement)endpoints.next();
            String ep = endpoint.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])endPointAdminClient.getEndpointNames(), (Object)ep)) {
                Assert.assertTrue((boolean)endPointAdminClient.deleteEndpoint(ep), (String)(ep + " Endpoint deletion failed"));
                Assert.assertTrue((boolean)this.isEndpointUnDeployed(backendURL, sessionCookie, ep), (String)(ep + " Endpoint undeployment failed"));
            }
            Assert.assertTrue((boolean)endPointAdminClient.addEndPoint(endpoint), (String)" Endpoint addition failed");
            Assert.assertTrue((boolean)this.isEndpointDeployed(backendURL, sessionCookie, ep), (String)" Endpoint deployment failed");
            this.log.info((Object)(ep + " Endpoint Uploaded"));
        }
        Iterator sequences = synapseConfig.getChildrenWithLocalName(SEQUENCE);
        while (sequences.hasNext()) {
            OMElement sequence = (OMElement)sequences.next();
            String sqn = sequence.getAttributeValue(new QName(NAME));
            boolean isSequenceExist = ArrayUtils.contains((Object[])sequenceAdminClient.getSequences(), (Object)sqn);
            if (("main".equalsIgnoreCase(sqn) || "fault".equalsIgnoreCase(sqn)) && isSequenceExist) {
                sequenceAdminClient.updateSequence(sequence);
            } else {
                if (isSequenceExist) {
                    sequenceAdminClient.deleteSequence(sqn);
                    Assert.assertTrue((boolean)this.isSequenceUnDeployed(backendURL, sessionCookie, sqn), (String)(sqn + " Sequence undeployment failed"));
                }
                sequenceAdminClient.addSequence(sequence);
                Assert.assertTrue((boolean)this.isSequenceDeployed(backendURL, sessionCookie, sqn), (String)" Sequence deployment failed");
            }
            this.log.info((Object)(sqn + " Sequence Uploaded"));
        }
        Iterator proxies = synapseConfig.getChildrenWithLocalName(PROXY);
        while (proxies.hasNext()) {
            OMElement proxy = (OMElement)proxies.next();
            String proxyName = proxy.getAttributeValue(new QName(NAME));
            if (adminServiceService.isServiceExists(proxyName)) {
                proxyAdmin.deleteProxy(proxyName);
                Assert.assertTrue((boolean)this.isProxyUnDeployed(backendURL, sessionCookie, proxyName), (String)(proxyName + " Undeployment failed"));
            }
            proxyAdmin.addProxyService(proxy);
            Assert.assertTrue((boolean)this.isProxyDeployed(backendURL, sessionCookie, proxyName), (String)(proxyName + " deployment failed"));
            this.log.info((Object)(proxyName + " Proxy Uploaded"));
        }
        Iterator messageStores = synapseConfig.getChildrenWithLocalName(MESSAGE_STORE);
        while (messageStores.hasNext()) {
            OMElement messageStore = (OMElement)messageStores.next();
            String mStore = messageStore.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])messageStoreAdminClient.getMessageStores(), (Object)mStore)) {
                messageStoreAdminClient.deleteMessageStore(mStore);
                Assert.assertTrue((boolean)this.isMessageStoreUnDeployed(backendURL, sessionCookie, mStore), (String)(mStore + " Message Store undeployment failed"));
            }
            messageStoreAdminClient.addMessageStore(messageStore);
            Assert.assertTrue((boolean)this.isMessageStoreDeployed(backendURL, sessionCookie, mStore), (String)" Message Store deployment failed");
            this.log.info((Object)(mStore + " Message Store Uploaded"));
        }
        Iterator messageProcessors = synapseConfig.getChildrenWithLocalName(MESSAGE_PROCESSOR);
        while (messageProcessors.hasNext()) {
            OMElement messageProcessor = (OMElement)messageProcessors.next();
            String mProcessor = messageProcessor.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])messageProcessorClient.getMessageProcessorNames(), (Object)mProcessor)) {
                messageProcessorClient.deleteMessageProcessor(mProcessor);
                Assert.assertTrue((boolean)this.isMessageProcessorUnDeployed(backendURL, sessionCookie, mProcessor), (String)(mProcessor + " Message Processor undeployment failed"));
            }
            messageProcessorClient.addMessageProcessor(messageProcessor);
            Assert.assertTrue((boolean)this.isMessageProcessorDeployed(backendURL, sessionCookie, mProcessor), (String)" Message Processor  deployment failed");
            this.log.info((Object)(mProcessor + " Message Processor Uploaded"));
        }
        Iterator templates = synapseConfig.getChildrenWithLocalName(TEMPLATE);
        while (templates.hasNext()) {
            OMElement template = (OMElement)templates.next();
            String templateName = template.getAttributeValue(new QName(NAME));
            if (template.getFirstChildWithName(new QName(template.getNamespace().getNamespaceURI(), SEQUENCE)) != null) {
                if (ArrayUtils.contains((Object[])sequenceTemplateAdminServiceClient.getSequenceTemplates(), (Object)templateName)) {
                    sequenceTemplateAdminServiceClient.deleteTemplate(templateName);
                    Assert.assertTrue((boolean)this.isSequenceTemplateUnDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Sequence Template undeployment failed"));
                }
                sequenceTemplateAdminServiceClient.addSequenceTemplate(template);
                Assert.assertTrue((boolean)this.isSequenceTemplateDeployed(backendURL, sessionCookie, templateName), (String)" Sequence  Template  deployment  failed");
            } else {
                if (ArrayUtils.contains((Object[])endpointTemplateAdminServiceClient.getEndpointTemplates(), (Object)templateName)) {
                    endpointTemplateAdminServiceClient.deleteEndpointTemplate(templateName);
                    Assert.assertTrue((boolean)this.isEndpointTemplateUnDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Endpoint Template undeployment failed"));
                }
                endpointTemplateAdminServiceClient.addEndpointTemplate(template);
                Assert.assertTrue((boolean)this.isEndpointTemplateDeployed(backendURL, sessionCookie, templateName), (String)" Endpoint  Template  deployment  failed");
            }
            this.log.info((Object)(templateName + " Template Uploaded"));
        }
        Iterator apiElements = synapseConfig.getChildrenWithLocalName(API);
        while (apiElements.hasNext()) {
            OMElement api = (OMElement)apiElements.next();
            String apiName = api.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])apiAdminClient.getApiNames(), (Object)apiName)) {
                apiAdminClient.deleteApi(apiName);
                Assert.assertTrue((boolean)this.isApiUnDeployed(backendURL, sessionCookie, apiName), (String)(apiName + " Api undeployment failed"));
            }
            apiAdminClient.add(api);
            Assert.assertTrue((boolean)this.isApiDeployed(backendURL, sessionCookie, apiName), (String)" Api deployment failed");
            this.log.info((Object)(apiName + " API Uploaded"));
        }
        Iterator priorityExecutorList = synapseConfig.getChildrenWithLocalName(PRIORITY_EXECUTOR);
        while (priorityExecutorList.hasNext()) {
            OMElement executor = (OMElement)priorityExecutorList.next();
            String executorName = executor.getAttributeValue(new QName(NAME));
            if (ArrayUtils.contains((Object[])priorityMediationAdminClient.getExecutorList(), (Object)executorName)) {
                priorityMediationAdminClient.remove(executorName);
                Assert.assertTrue((boolean)this.isPriorityExecutorUnDeployed(backendURL, sessionCookie, executorName), (String)(executorName + " Priority Executor undeployment failed"));
            }
            priorityMediationAdminClient.addPriorityMediator(executorName, executor);
            Assert.assertTrue((boolean)this.isPriorityExecutorDeployed(backendURL, sessionCookie, executorName), (String)" Priority Executor failed");
            this.log.info((Object)(executorName + " Priority Executor Uploaded"));
        }
        Iterator taskList = synapseConfig.getChildrenWithLocalName(TASK);
        while (taskList.hasNext()) {
            OMElement task = (OMElement)taskList.next();
            String taskName = task.getAttributeValue(new QName(NAME));
            if (taskAdminClient.getScheduleTaskList().contains(taskName)) {
                taskAdminClient.updateTask(task);
                continue;
            }
            taskAdminClient.addTask(task);
            Assert.assertTrue((boolean)this.isScheduleTaskDeployed(backendURL, sessionCookie, taskName), (String)" Task deployment failed");
            this.log.info((Object)(taskName + " Task Uploaded"));
        }
        Thread.sleep(1000L);
        this.verifySynapseDeployment(synapseConfig, backendURL, sessionCookie);
        this.log.info((Object)"Synapse configuration  Deployed");
    }

    public void addProxyService(String backEndUrl, String sessionCookie, OMElement proxyConfig) throws Exception {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backEndUrl, sessionCookie);
        proxyAdmin.addProxyService(proxyConfig);
        String proxyName = proxyConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isProxyDeployed(backEndUrl, sessionCookie, proxyName), (String)"Proxy Deployment failed or time out");
    }

    public void addInboundEndpoint(String backEndUrl, String sessionCookie, OMElement inboundEndpoint) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        inboundAdmin.addInboundEndpoint(inboundEndpoint.toString());
        this.isInboundEndpointDeployed(backEndUrl, sessionCookie, inboundEndpoint.getAttributeValue(new QName(NAME)));
    }

    public void addInboundEndpointFromParams(String backEndUrl, String sessionCookie, OMElement inboundEndpoint) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        Map<String, String> mParams = this.generateParameterMap(inboundEndpoint);
        inboundAdmin.addInboundEndpoint(inboundEndpoint.getAttribute(new QName(NAME)).getAttributeValue(), inboundEndpoint.getAttribute(new QName(SEQUENCE)).getAttributeValue(), inboundEndpoint.getAttribute(new QName("onError")).getAttributeValue(), inboundEndpoint.getAttribute(new QName("protocol")).getAttributeValue(), null, mParams);
        this.isInboundEndpointDeployed(backEndUrl, sessionCookie, inboundEndpoint.getAttributeValue(new QName(NAME)));
    }

    public void updateInboundEndpoint(String backEndUrl, String sessionCookie, OMElement inboundEndpoint) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        Map<String, String> mParams = this.generateParameterMap(inboundEndpoint);
        if (inboundEndpoint.getAttribute(new QName("protocol")).getAttributeValue() != null) {
            inboundAdmin.updateInboundEndpoint(inboundEndpoint.getAttribute(new QName(NAME)).getAttributeValue(), inboundEndpoint.getAttribute(new QName(SEQUENCE)).getAttributeValue(), inboundEndpoint.getAttribute(new QName("onError")).getAttributeValue(), inboundEndpoint.getAttribute(new QName("protocol")).getAttributeValue(), null, mParams);
        } else {
            inboundAdmin.updateInboundEndpoint(inboundEndpoint.getAttribute(new QName(NAME)).getAttributeValue(), inboundEndpoint.getAttribute(new QName(SEQUENCE)).getAttributeValue(), inboundEndpoint.getAttribute(new QName("onError")).getAttributeValue(), null, inboundEndpoint.getAttribute(new QName("classImpl")).getAttributeValue(), mParams);
        }
        this.isInboundEndpointDeployed(backEndUrl, sessionCookie, inboundEndpoint.getAttributeValue(new QName(NAME)));
    }

    private Map<String, String> generateParameterMap(OMElement element) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        OMElement params = element.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "parameters"));
        if (params != null) {
            Iterator iterator = params.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
            while (iterator.hasNext()) {
                OMElement parametreElement = (OMElement)iterator.next();
                String nameAttr = parametreElement.getAttribute(new QName(NAME)).getAttributeValue();
                String valueAttr = parametreElement.getText();
                paramMap.put(nameAttr, valueAttr);
            }
        }
        return paramMap;
    }

    public void isInboundEndpointDeployed(String backEndUrl, String sessionCookie, String name) throws Exception {
        long time;
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        InboundEndpointDTO inboundEndpointDTO = null;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Inbound Endpoint " + name));
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            inboundEndpointDTO = inboundAdmin.getInboundEndpointbyName(name);
            if (inboundEndpointDTO != null) {
                this.log.info((Object)(name + "Inbound Endpoint Found in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        Assert.assertNotNull(inboundEndpointDTO);
    }

    public void isInboundEndpointUndeployed(String backEndUrl, String sessionCookie, String name) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        InboundEndpointDTO inboundEndpointDTO = inboundAdmin.getInboundEndpointbyName(name);
        Assert.assertNull((Object)inboundEndpointDTO);
    }

    public void deleteInboundEndpointDeployed(String backEndUrl, String sessionCookie, String name) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        inboundAdmin.removeInboundEndpoint(name);
        InboundEndpointDTO inboundEndpointDTO = inboundAdmin.getInboundEndpointbyName(name);
        Assert.assertNull((Object)inboundEndpointDTO);
    }

    public InboundEndpointDTO[] getAllInboundEndpoints(String backEndUrl, String sessionCookie) throws Exception {
        InboundAdminClient inboundAdmin = new InboundAdminClient(backEndUrl, sessionCookie);
        return inboundAdmin.getAllInboundEndpointNames();
    }

    public void uploadConnector(String backEndUrl, String sessionCookie, LibraryFileItem[] fileItems) throws RemoteException {
        MediationLibraryUploaderClient mediationLibraryUploaderClient = new MediationLibraryUploaderClient(backEndUrl, sessionCookie);
        mediationLibraryUploaderClient.uploadConnector(fileItems);
    }

    public void updateConnectorStatus(String backEndUrl, String sessionCookie, String libQName, String libName, String packageName, String status) throws RemoteException {
        MediationLibraryAdminServiceClient mediationLibraryAdminServiceClient = new MediationLibraryAdminServiceClient(backEndUrl, sessionCookie);
        mediationLibraryAdminServiceClient.updateStatus(libQName, libName, packageName, status);
    }

    public String[] getAllImports(String backEndUrl, String sessionCookie) throws RemoteException {
        MediationLibraryAdminServiceClient mediationLibraryAdminServiceClient = new MediationLibraryAdminServiceClient(backEndUrl, sessionCookie);
        return mediationLibraryAdminServiceClient.getAllImports();
    }

    public void deleteLibrary(String backEndUrl, String sessionCookie, String liqQualifiedname) throws RemoteException, MediationLibraryAdminServiceException {
        MediationLibraryAdminServiceClient mediationLibraryAdminServiceClient = new MediationLibraryAdminServiceClient(backEndUrl, sessionCookie);
        mediationLibraryAdminServiceClient.deleteLibrary(liqQualifiedname);
    }

    public void addEndpoint(String backEndUrl, String sessionCookie, OMElement endpointConfig) throws Exception {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        endPointAdminClient.addEndPoint(endpointConfig);
        String ep = endpointConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isEndpointDeployed(backEndUrl, sessionCookie, ep), (String)(ep + "Endpoint deployment not found or time out"));
    }

    public void addLocalEntry(String backEndUrl, String sessionCookie, OMElement localEntryConfig) throws Exception {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        boolean value = localEntryAdminServiceClient.addLocalEntry(localEntryConfig);
        Assert.assertTrue((boolean)value, (String)"LocalEntry Addition failed");
        if (value) {
            String le = localEntryConfig.getAttributeValue(new QName(KEY));
            Assert.assertTrue((boolean)this.isLocalEntryDeployed(backEndUrl, sessionCookie, le), (String)(le + "LocalEntry deployment not found or time out"));
        }
    }

    public void addSequence(String backEndUrl, String sessionCookie, OMElement sequenceConfig) throws Exception {
        SequenceAdminServiceClient sequenceAdminClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        sequenceAdminClient.addSequence(sequenceConfig);
        String sqn = sequenceConfig.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isSequenceDeployed(backEndUrl, sessionCookie, sqn), (String)(sqn + "Sequence deployment not found or time out"));
    }

    public void addMessageStore(String backEndUrl, String sessionCookie, OMElement messageStore) throws Exception {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        messageStoreAdminClient.addMessageStore(messageStore);
        String mStoreName = messageStore.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isMessageStoreDeployed(backEndUrl, sessionCookie, mStoreName), (String)"Message Store Deployment failed");
    }

    public void addMessageProcessor(String backEndUrl, String sessionCookie, OMElement messageProcessor) throws Exception {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        messageProcessorClient.addMessageProcessor(messageProcessor);
        String mProcessorName = messageProcessor.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isMessageProcessorDeployed(backEndUrl, sessionCookie, mProcessorName), (String)"Message Processor deployment failed");
    }

    public void addSequenceTemplate(String backEndUrl, String sessionCookie, OMElement sequenceTemplate) throws RemoteException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        sequenceTemplateAdminServiceClient.addSequenceTemplate(sequenceTemplate);
        String seqTmpName = sequenceTemplate.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isSequenceTemplateDeployed(backEndUrl, sessionCookie, seqTmpName), (String)"Sequence Template deployment failed");
    }

    public void addEndpointTemplate(String backEndUrl, String sessionCookie, OMElement endpointTemplate) throws RemoteException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        endpointTemplateAdminServiceClient.addEndpointTemplate(endpointTemplate);
        String endpointTmpName = endpointTemplate.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isEndpointTemplateDeployed(backEndUrl, sessionCookie, endpointTmpName), (String)"Endpoint Template deployment failed");
    }

    public void addAPI(String backEndUrl, String sessionCookie, OMElement api) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        apiAdminClient.add(api);
        String apiName = api.getAttributeValue(new QName(NAME));
        Assert.assertTrue((boolean)this.isApiDeployed(backEndUrl, sessionCookie, apiName), (String)"Rest Api deployment failed");
    }

    public void addPriorityExecutor(String backEndUrl, String sessionCookie, OMElement priorityExecutor) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        String executorName = priorityExecutor.getAttributeValue(new QName(NAME));
        priorityMediationAdminClient.addPriorityMediator(executorName, priorityExecutor);
        Assert.assertTrue((boolean)this.isPriorityExecutorDeployed(backEndUrl, sessionCookie, executorName), (String)"Priority Executor deployment failed");
    }

    public void addScheduleTask(String backEndUrl, String sessionCookie, OMElement taskDescription) throws TaskManagementException, RemoteException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        taskAdminClient.addTask(taskDescription);
        Assert.assertTrue((boolean)this.isScheduleTaskDeployed(backEndUrl, sessionCookie, taskDescription.getAttributeValue(new QName(NAME))), (String)"ScheduleTask deployment failed");
    }

    public boolean isProxyDeployed(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Proxy deployment " + proxyName));
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (adminServiceService.isServiceExists(proxyName)) {
                isServiceDeployed = true;
                this.log.info((Object)(proxyName + " Proxy Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        return isServiceDeployed;
    }

    public boolean isEndpointDeployed(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Endpoint " + endpointName));
        boolean isEndpointExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] endpoints = endPointAdminClient.getEndpointNames();
            if (endpoints != null && endpoints.length > 0) {
                for (String endpoint : endpoints) {
                    if (!endpointName.equals(endpoint)) continue;
                    isEndpointExist = true;
                    this.log.info((Object)(endpointName + " Endpoint Found in " + time + " millis"));
                    break;
                }
            }
            if (isEndpointExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isEndpointExist;
    }

    public boolean isMessageProcessorDeployed(String backEndUrl, String sessionCookie, String messageProcessorName) throws SequenceEditorException, RemoteException {
        long time;
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Message Processor " + messageProcessorName));
        boolean isMessageStoreExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] messageProcessors = messageProcessorClient.getMessageProcessorNames();
            if (messageProcessors != null && messageProcessors.length > 0) {
                for (String mp : messageProcessors) {
                    if (!mp.equals(messageProcessorName)) continue;
                    isMessageStoreExist = true;
                    this.log.info((Object)(messageProcessorName + " Message Processor Found in " + time + " millis"));
                    break;
                }
            }
            if (isMessageStoreExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isMessageStoreExist;
    }

    public boolean isSequenceDeployed(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        long time;
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Sequence " + sequenceName));
        boolean isSequenceExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] sequences = sequenceAdminServiceClient.getSequences();
            if (sequences != null && sequences.length > 0) {
                for (String sequence : sequences) {
                    if (!sequence.equals(sequenceName)) continue;
                    isSequenceExist = true;
                    this.log.info((Object)(sequenceName + " Sequence Found in " + time + " millis"));
                    break;
                }
            }
            if (isSequenceExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isSequenceExist;
    }

    public boolean isMessageStoreDeployed(String backEndUrl, String sessionCookie, String messageStoreName) throws SequenceEditorException, RemoteException {
        long time;
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Message Store " + messageStoreName));
        boolean isMessageStoreExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] messageStores = messageStoreAdminClient.getMessageStores();
            if (messageStores != null && messageStores.length > 0) {
                for (String ms : messageStores) {
                    if (!ms.equals(messageStoreName)) continue;
                    isMessageStoreExist = true;
                    this.log.info((Object)(messageStoreName + " Message Store Found in " + time + " millis"));
                    break;
                }
            }
            if (isMessageStoreExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isMessageStoreExist;
    }

    public boolean isSequenceTemplateDeployed(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws RemoteException {
        long time;
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Sequence Template " + sequenceTemplateName));
        boolean isSequenceTmpFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] templates = sequenceTemplateAdminServiceClient.getSequenceTemplates();
            if (templates != null && templates.length > 0) {
                for (String tmpl : templates) {
                    if (!tmpl.equals(sequenceTemplateName)) continue;
                    isSequenceTmpFound = true;
                    this.log.info((Object)(sequenceTemplateName + " Sequence Template Found in " + time + " millis"));
                    break;
                }
            }
            if (isSequenceTmpFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isSequenceTmpFound;
    }

    public boolean isEndpointTemplateDeployed(String backEndUrl, String sessionCookie, String endpointTemplateName) throws RemoteException {
        long time;
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Endpoint Template " + endpointTemplateName));
        boolean isEndpointTmpFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] templates = endpointTemplateAdminServiceClient.getEndpointTemplates();
            if (templates != null && templates.length > 0) {
                for (String tmpl : templates) {
                    if (!tmpl.equals(endpointTemplateName)) continue;
                    isEndpointTmpFound = true;
                    this.log.info((Object)(endpointTemplateName + " Endpoint Template Found in " + time + " millis"));
                    break;
                }
            }
            if (isEndpointTmpFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isEndpointTmpFound;
    }

    public boolean isApiDeployed(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        long time;
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for API " + apiName));
        boolean isApiFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] apiList = apiAdminClient.getApiNames();
            if (apiList != null && apiList.length > 0) {
                for (String restApi : apiList) {
                    if (!restApi.equals(apiName)) continue;
                    isApiFound = true;
                    this.log.info((Object)(apiName + " API Found in " + time + " millis"));
                    break;
                }
            }
            if (isApiFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isApiFound;
    }

    public boolean isPriorityExecutorDeployed(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        long time;
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Priority Executor " + executorName));
        boolean isExecutorFound = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] executorList = priorityMediationAdminClient.getExecutorList();
            if (executorList != null && executorList.length > 0) {
                for (String executor : executorList) {
                    if (!executor.equals(executorName)) continue;
                    isExecutorFound = true;
                    this.log.info((Object)(executorName + " Priority Executor Found in " + time + " millis"));
                    break;
                }
            }
            if (isExecutorFound) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isExecutorFound;
    }

    public boolean isScheduleTaskDeployed(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Task deployment " + taskName));
        boolean isTaskDeployed = false;
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (taskAdminClient.getScheduleTaskList().contains(taskName)) {
                isTaskDeployed = true;
                this.log.info((Object)(taskName + " Task Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        return isTaskDeployed;
    }

    public boolean isProxyServiceExist(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceExists(proxyName);
    }

    public boolean isLocalEntryExist(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        Object[] localEntries = localEntryAdminServiceClient.getEntryNames();
        if (localEntries == null || localEntries.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])localEntries, (Object)localEntryName);
    }

    public boolean isSequenceExist(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        Object[] sequences = sequenceAdminServiceClient.getSequences();
        if (sequences == null || sequences.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])sequences, (Object)sequenceName);
    }

    public boolean isEndpointExist(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        Object[] endpoints = endPointAdminClient.getEndpointNames();
        if (endpoints == null || endpoints.length == 0) {
            return false;
        }
        return ArrayUtils.contains((Object[])endpoints, (Object)endpointName);
    }

    public boolean isMessageStoreExist(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])messageStoreAdminClient.getMessageStores(), (Object)messageProcessor);
    }

    public boolean isMessageProcessorExist(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])messageProcessorClient.getMessageProcessorNames(), (Object)messageProcessor);
    }

    public boolean isSequenceTemplateExist(String backEndUrl, String sessionCookie, String sequenceTemplate) throws RemoteException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])sequenceTemplateAdminServiceClient.getSequenceTemplates(), (Object)sequenceTemplate);
    }

    public boolean isEndpointTemplateExist(String backEndUrl, String sessionCookie, String endpointTemplate) throws RemoteException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])endpointTemplateAdminServiceClient.getEndpointTemplates(), (Object)endpointTemplate);
    }

    public boolean isApiExist(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])apiAdminClient.getApiNames(), (Object)apiName);
    }

    public boolean isPriorityExecutorExist(String backEndUrl, String sessionCookie, String priorityExecutorName) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        return ArrayUtils.contains((Object[])priorityMediationAdminClient.getExecutorList(), (Object)priorityExecutorName);
    }

    public boolean isScheduleTaskExist(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        return taskAdminClient.getScheduleTaskList().contains(taskName);
    }

    public void deleteProxyService(String backEndUrl, String sessionCookie, String proxyServiceName) throws ProxyServiceAdminProxyAdminException, RemoteException {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backEndUrl, sessionCookie);
        proxyAdmin.deleteProxy(proxyServiceName);
        Assert.assertTrue((boolean)this.isProxyUnDeployed(backEndUrl, sessionCookie, proxyServiceName), (String)"Proxy service undeployment failed");
    }

    public void deleteLocalEntry(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        Assert.assertTrue((boolean)localEntryAdminServiceClient.deleteLocalEntry(localEntryName), (String)"LocalEntry Deletion failed");
        Assert.assertTrue((boolean)this.isLocalEntryUnDeployed(backEndUrl, sessionCookie, localEntryName), (String)"LocalEntry undeployment failed");
    }

    public void deleteEndpoint(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        Assert.assertTrue((boolean)endPointAdminClient.deleteEndpoint(endpointName), (String)"Endpoint deletion failed");
        Assert.assertTrue((boolean)this.isEndpointUnDeployed(backEndUrl, sessionCookie, endpointName), (String)"Endpoint undeployment failed");
    }

    public void deleteSequence(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        sequenceAdminServiceClient.deleteSequence(sequenceName);
        Assert.assertTrue((boolean)this.isSequenceUnDeployed(backEndUrl, sessionCookie, sequenceName), (String)"Sequence undeployment failed");
    }

    public void deleteMessageStore(String backEndUrl, String sessionCookie, String messageStore) throws RemoteException, SequenceEditorException {
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        messageStoreAdminClient.deleteMessageStore(messageStore);
        Assert.assertTrue((boolean)this.isMessageStoreUnDeployed(backEndUrl, sessionCookie, messageStore), (String)"Message Store undeployment failed");
    }

    public void deleteMessageProcessor(String backEndUrl, String sessionCookie, String messageProcessor) throws RemoteException, SequenceEditorException {
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        messageProcessorClient.deleteMessageProcessor(messageProcessor);
        Assert.assertTrue((boolean)this.isMessageProcessorUnDeployed(backEndUrl, sessionCookie, messageProcessor), (String)"Message Processor undeployment failed");
    }

    public void deleteEndpointTemplate(String backEndUrl, String sessionCookie, String endpointTemplate) throws RemoteException, SequenceEditorException, EndpointAdminEndpointAdminException {
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        endpointTemplateAdminServiceClient.deleteEndpointTemplate(endpointTemplate);
        Assert.assertTrue((boolean)this.isEndpointTemplateUnDeployed(backEndUrl, sessionCookie, endpointTemplate), (String)"Endpoint Template undeployment failed");
    }

    public void deleteSequenceTemplate(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws RemoteException, SequenceEditorException, EndpointAdminEndpointAdminException {
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        sequenceTemplateAdminServiceClient.deleteTemplate(sequenceTemplateName);
        Assert.assertTrue((boolean)this.isSequenceTemplateUnDeployed(backEndUrl, sessionCookie, sequenceTemplateName), (String)"Sequence Template undeployment failed");
    }

    public void deleteApi(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        apiAdminClient.deleteApi(apiName);
        Assert.assertTrue((boolean)this.isApiUnDeployed(backEndUrl, sessionCookie, apiName), (String)"API undeployment failed");
    }

    public void deletePriorityExecutor(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        priorityMediationAdminClient.remove(executorName);
        Assert.assertTrue((boolean)this.isPriorityExecutorUnDeployed(backEndUrl, sessionCookie, executorName), (String)"Priority Executor undeployment failed");
    }

    public void deleteScheduleTask(String backEndUrl, String sessionCookie, String taskName, String group) throws TaskManagementException, RemoteException {
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        taskAdminClient.deleteTask(taskName, group);
        Assert.assertTrue((boolean)this.isScheduleTaskUnDeployed(backEndUrl, sessionCookie, taskName), (String)"ScheduleTask deployment failed");
    }

    public boolean isProxyUnDeployed(String backEndUrl, String sessionCookie, String proxyName) throws RemoteException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Proxy undeployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!adminServiceService.isServiceExists(proxyName)) {
                isServiceDeleted = true;
                this.log.info((Object)(proxyName + " Proxy undeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isServiceDeleted;
    }

    public boolean isMessageStoreUnDeployed(String backEndUrl, String sessionCookie, String messageStoreName) throws SequenceEditorException, RemoteException {
        long time;
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Message Store " + messageStoreName));
        boolean isMessageStoreDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] mStores = messageStoreAdminClient.getMessageStores();
            if (!ArrayUtils.contains((Object[])mStores, (Object)messageStoreName)) {
                isMessageStoreDeleted = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isMessageStoreDeleted;
    }

    public boolean isMessageProcessorUnDeployed(String backEndUrl, String sessionCookie, String messageProcessorName) throws SequenceEditorException, RemoteException {
        long time;
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Message Processor " + messageProcessorName));
        boolean isMessageProcessorDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] mProcessors = messageProcessorClient.getMessageProcessorNames();
            if (!ArrayUtils.contains((Object[])mProcessors, (Object)messageProcessorName)) {
                isMessageProcessorDeleted = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isMessageProcessorDeleted;
    }

    public boolean isLocalEntryDeployed(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        long time;
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for LocalEntry " + localEntryName));
        boolean isLocalEntryExist = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            String[] localEntries = localEntryAdminServiceClient.getEntryNames();
            if (localEntries != null && localEntries.length > 0) {
                for (String localEntry : localEntries) {
                    if (!localEntryName.equals(localEntry)) continue;
                    isLocalEntryExist = true;
                    this.log.info((Object)(localEntryName + " LocalEntry Found in " + time + " millis"));
                    break;
                }
            }
            if (isLocalEntryExist) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isLocalEntryExist;
    }

    public boolean isLocalEntryUnDeployed(String backEndUrl, String sessionCookie, String localEntryName) throws LocalEntryAdminException, RemoteException {
        long time;
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment LocalEntry " + localEntryName));
        boolean isLocalEntryUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] localEntries = localEntryAdminServiceClient.getEntryNames();
            if (!ArrayUtils.contains((Object[])localEntries, (Object)localEntryName)) {
                isLocalEntryUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isLocalEntryUnDeployed;
    }

    public boolean isSequenceUnDeployed(String backEndUrl, String sessionCookie, String sequenceName) throws SequenceEditorException, RemoteException {
        long time;
        SequenceAdminServiceClient sequenceAdminServiceClient = new SequenceAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Sequence " + sequenceName));
        boolean isSequenceUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] sequences = sequenceAdminServiceClient.getSequences();
            if (!ArrayUtils.contains((Object[])sequences, (Object)sequenceName)) {
                isSequenceUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isSequenceUnDeployed;
    }

    public boolean isEndpointUnDeployed(String backEndUrl, String sessionCookie, String endpointName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Endpoint " + endpointName));
        boolean isEndpointUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] endpoints = endPointAdminClient.getEndpointNames();
            if (!ArrayUtils.contains((Object[])endpoints, (Object)endpointName)) {
                isEndpointUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isEndpointUnDeployed;
    }

    public boolean isEndpointTemplateUnDeployed(String backEndUrl, String sessionCookie, String endpointTemplateName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        EndpointTemplateAdminServiceClient endpointTemplateAdminServiceClient = new EndpointTemplateAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Endpoint Template " + endpointTemplateName));
        boolean isEndpointTemplateUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] endpointTemplates = endpointTemplateAdminServiceClient.getEndpointTemplates();
            if (!ArrayUtils.contains((Object[])endpointTemplates, (Object)endpointTemplateName)) {
                isEndpointTemplateUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isEndpointTemplateUnDeployed;
    }

    public boolean isSequenceTemplateUnDeployed(String backEndUrl, String sessionCookie, String sequenceTemplateName) throws EndpointAdminEndpointAdminException, RemoteException {
        long time;
        SequenceTemplateAdminServiceClient sequenceTemplateAdminServiceClient = new SequenceTemplateAdminServiceClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Sequence Template " + sequenceTemplateName));
        boolean isSequenceTemplateUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] sequenceTemplates = sequenceTemplateAdminServiceClient.getSequenceTemplates();
            if (!ArrayUtils.contains((Object[])sequenceTemplates, (Object)sequenceTemplateName)) {
                isSequenceTemplateUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isSequenceTemplateUnDeployed;
    }

    public boolean isApiUnDeployed(String backEndUrl, String sessionCookie, String apiName) throws RemoteException, RestApiAdminAPIException {
        long time;
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment API " + apiName));
        boolean isApiUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] apiList = apiAdminClient.getApiNames();
            if (!ArrayUtils.contains((Object[])apiList, (Object)apiName)) {
                isApiUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isApiUnDeployed;
    }

    public boolean isPriorityExecutorUnDeployed(String backEndUrl, String sessionCookie, String executorName) throws RemoteException {
        long time;
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backEndUrl, sessionCookie);
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Undeployment Priority Executor " + executorName));
        boolean isExecutorUnDeployed = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            Object[] executorList = priorityMediationAdminClient.getExecutorList();
            if (!ArrayUtils.contains((Object[])executorList, (Object)executorName)) {
                isExecutorUnDeployed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        return isExecutorUnDeployed;
    }

    public boolean isScheduleTaskUnDeployed(String backEndUrl, String sessionCookie, String taskName) throws RemoteException, TaskManagementException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for Task Undeployment " + taskName));
        boolean isTaskUnDeployed = false;
        TaskAdminClient taskAdminClient = new TaskAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!taskAdminClient.getScheduleTaskList().contains(taskName)) {
                isTaskUnDeployed = true;
                this.log.info((Object)(taskName + " Task UnDeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        return isTaskUnDeployed;
    }

    public void verifySynapseDeployment(OMElement synapseConfig, String backendURL, String sessionCookie) throws LocalEntryAdminException, RemoteException, EndpointAdminEndpointAdminException, SequenceEditorException, RestApiAdminAPIException {
        Iterator localEntries = synapseConfig.getChildrenWithLocalName(LOCAL_ENTRY);
        while (localEntries.hasNext()) {
            String le = ((OMElement)localEntries.next()).getAttributeValue(new QName(KEY));
            Assert.assertTrue((boolean)this.isLocalEntryDeployed(backendURL, sessionCookie, le), (String)(le + " LocalEntry deployment not found or time out"));
        }
        Iterator endpoints = synapseConfig.getChildrenWithLocalName(ENDPOINT);
        while (endpoints.hasNext()) {
            String ep = ((OMElement)endpoints.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isEndpointDeployed(backendURL, sessionCookie, ep), (String)(ep + " Endpoint deployment not found or time out"));
        }
        Iterator sequences = synapseConfig.getChildrenWithLocalName(SEQUENCE);
        while (sequences.hasNext()) {
            String sqn = ((OMElement)sequences.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isSequenceDeployed(backendURL, sessionCookie, sqn), (String)(sqn + " Sequence deployment not found or time out"));
        }
        Iterator proxies = synapseConfig.getChildrenWithLocalName(PROXY);
        while (proxies.hasNext()) {
            String proxy = ((OMElement)proxies.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isProxyDeployed(backendURL, sessionCookie, proxy), (String)(proxy + " Proxy Deployment not found or time out"));
        }
        Iterator messageStores = synapseConfig.getChildrenWithLocalName(MESSAGE_STORE);
        while (messageStores.hasNext()) {
            String mStore = ((OMElement)messageStores.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isMessageStoreDeployed(backendURL, sessionCookie, mStore), (String)(mStore + " Message Store Deployment not found or time out"));
        }
        Iterator messageProcessor = synapseConfig.getChildrenWithLocalName(MESSAGE_PROCESSOR);
        while (messageProcessor.hasNext()) {
            String mProcessor = ((OMElement)messageProcessor.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isMessageProcessorDeployed(backendURL, sessionCookie, mProcessor), (String)(mProcessor + " Message Processor Deployment not found or time out"));
        }
        Iterator templates = synapseConfig.getChildrenWithLocalName(TEMPLATE);
        while (templates.hasNext()) {
            OMElement template = (OMElement)templates.next();
            String templateName = template.getAttributeValue(new QName(NAME));
            if (template.getFirstChildWithName(new QName(template.getNamespace().getNamespaceURI(), SEQUENCE)) != null) {
                Assert.assertTrue((boolean)this.isSequenceTemplateDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Sequence Template Deployment not found or time out"));
            } else {
                Assert.assertTrue((boolean)this.isEndpointTemplateDeployed(backendURL, sessionCookie, templateName), (String)(templateName + " Endpoint Template Deployment not found or time out"));
            }
            this.log.info((Object)"Template Uploaded");
        }
        Iterator apiList = synapseConfig.getChildrenWithLocalName(API);
        while (apiList.hasNext()) {
            String apiName = ((OMElement)apiList.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isApiDeployed(backendURL, sessionCookie, apiName), (String)(apiName + " API Deployment not found or time out"));
        }
        Iterator executorList = synapseConfig.getChildrenWithLocalName(PRIORITY_EXECUTOR);
        while (executorList.hasNext()) {
            String executorName = ((OMElement)executorList.next()).getAttributeValue(new QName(NAME));
            Assert.assertTrue((boolean)this.isPriorityExecutorDeployed(backendURL, sessionCookie, executorName), (String)(executorName + " Priority Executor Deployment not found or time out"));
        }
    }

    public void deleteArtifact(OMElement synapseConfig, String backendURL, String sessionCookie) throws Exception {
        ProxyServiceAdminClient proxyAdmin = new ProxyServiceAdminClient(backendURL, sessionCookie);
        EndPointAdminClient endPointAdminClient = new EndPointAdminClient(backendURL, sessionCookie);
        SequenceAdminServiceClient sequenceAdminClient = new SequenceAdminServiceClient(backendURL, sessionCookie);
        LocalEntriesAdminClient localEntryAdminServiceClient = new LocalEntriesAdminClient(backendURL, sessionCookie);
        MessageProcessorClient messageProcessorClient = new MessageProcessorClient(backendURL, sessionCookie);
        MessageStoreAdminClient messageStoreAdminClient = new MessageStoreAdminClient(backendURL, sessionCookie);
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backendURL, sessionCookie);
        RestApiAdminClient apiAdminClient = new RestApiAdminClient(backendURL, sessionCookie);
        PriorityMediationAdminClient priorityMediationAdminClient = new PriorityMediationAdminClient(backendURL, sessionCookie);
        Iterator localEntries = synapseConfig.getChildrenWithLocalName(LOCAL_ENTRY);
        while (localEntries.hasNext()) {
            OMElement localEntry = (OMElement)localEntries.next();
            String le = localEntry.getAttributeValue(new QName(KEY));
            if (!ArrayUtils.contains((Object[])localEntryAdminServiceClient.getEntryNames(), (Object)le)) continue;
            Assert.assertTrue((boolean)localEntryAdminServiceClient.deleteLocalEntry(le), (String)(le + " Local Entry deletion failed"));
            Assert.assertTrue((boolean)this.isLocalEntryUnDeployed(backendURL, sessionCookie, le), (String)(le + " Local Entry undeployment failed"));
        }
        Iterator endpoints = synapseConfig.getChildrenWithLocalName(ENDPOINT);
        while (endpoints.hasNext()) {
            OMElement endpoint = (OMElement)endpoints.next();
            String ep = endpoint.getAttributeValue(new QName(NAME));
            if (!ArrayUtils.contains((Object[])endPointAdminClient.getEndpointNames(), (Object)ep)) continue;
            Assert.assertTrue((boolean)endPointAdminClient.deleteEndpoint(ep), (String)(ep + " Endpoint deletion failed"));
            Assert.assertTrue((boolean)this.isEndpointUnDeployed(backendURL, sessionCookie, ep), (String)(ep + " Endpoint undeployment failed"));
        }
        Iterator sequences = synapseConfig.getChildrenWithLocalName(SEQUENCE);
        while (sequences.hasNext()) {
            OMElement sequence = (OMElement)sequences.next();
            String sqn = sequence.getAttributeValue(new QName(NAME));
            if (sqn.equalsIgnoreCase("fault") || sqn.equalsIgnoreCase("main") || !ArrayUtils.contains((Object[])sequenceAdminClient.getSequences(), (Object)sqn)) continue;
            sequenceAdminClient.deleteSequence(sqn);
            Assert.assertTrue((boolean)this.isSequenceUnDeployed(backendURL, sessionCookie, sqn), (String)(sqn + " Sequence undeployment failed"));
        }
        Iterator proxies = synapseConfig.getChildrenWithLocalName(PROXY);
        while (proxies.hasNext()) {
            OMElement proxy = (OMElement)proxies.next();
            String proxyName = proxy.getAttributeValue(new QName(NAME));
            if (!adminServiceService.isServiceExists(proxyName)) continue;
            proxyAdmin.deleteProxy(proxyName);
            Assert.assertTrue((boolean)this.isProxyUnDeployed(backendURL, sessionCookie, proxyName), (String)(proxyName + " Undeployment failed"));
        }
        Iterator messageStores = synapseConfig.getChildrenWithLocalName(MESSAGE_STORE);
        while (messageStores.hasNext()) {
            OMElement messageStore = (OMElement)messageStores.next();
            String mStore = messageStore.getAttributeValue(new QName(NAME));
            if (!ArrayUtils.contains((Object[])messageStoreAdminClient.getMessageStores(), (Object)mStore)) continue;
            messageStoreAdminClient.deleteMessageStore(mStore);
            Assert.assertTrue((boolean)this.isMessageStoreUnDeployed(backendURL, sessionCookie, mStore), (String)(mStore + " Message Store undeployment failed"));
        }
        Iterator messageProcessors = synapseConfig.getChildrenWithLocalName(MESSAGE_PROCESSOR);
        while (messageProcessors.hasNext()) {
            OMElement messageProcessor = (OMElement)messageProcessors.next();
            String mProcessor = messageProcessor.getAttributeValue(new QName(NAME));
            if (!ArrayUtils.contains((Object[])messageProcessorClient.getMessageProcessorNames(), (Object)mProcessor)) continue;
            messageProcessorClient.deleteMessageProcessor(mProcessor);
            Assert.assertTrue((boolean)this.isMessageProcessorUnDeployed(backendURL, sessionCookie, mProcessor), (String)(mProcessor + " Message Processor undeployment failed"));
        }
        Iterator templates = synapseConfig.getChildrenWithLocalName(TEMPLATE);
        while (templates.hasNext()) {
            OMElement template = (OMElement)templates.next();
            String templateName = template.getAttributeValue(new QName(NAME));
            if (template.getFirstChildWithName(new QName(template.getNamespace().getNamespaceURI(), SEQUENCE)) != null) {
                this.deleteSequenceTemplate(backendURL, sessionCookie, templateName);
            } else {
                this.deleteEndpointTemplate(backendURL, sessionCookie, templateName);
            }
            this.log.info((Object)"Template UnUploaded");
        }
        Iterator apiList = synapseConfig.getChildrenWithLocalName(API);
        while (apiList.hasNext()) {
            OMElement api = (OMElement)apiList.next();
            String apiName = api.getAttributeValue(new QName(NAME));
            if (!ArrayUtils.contains((Object[])apiAdminClient.getApiNames(), (Object)apiName)) continue;
            apiAdminClient.deleteApi(apiName);
            Assert.assertTrue((boolean)this.isApiUnDeployed(backendURL, sessionCookie, apiName), (String)(apiName + " API undeployment failed"));
        }
        Iterator executorList = synapseConfig.getChildrenWithLocalName(PRIORITY_EXECUTOR);
        while (executorList.hasNext()) {
            OMElement executor = (OMElement)executorList.next();
            String executorName = executor.getAttributeValue(new QName(NAME));
            if (!ArrayUtils.contains((Object[])priorityMediationAdminClient.getExecutorList(), (Object)executorName)) continue;
            priorityMediationAdminClient.remove(executorName);
            Assert.assertTrue((boolean)this.isPriorityExecutorUnDeployed(backendURL, sessionCookie, executorName), (String)(executorName + " Priority Executor undeployment failed"));
        }
        this.log.info((Object)"Synapse configuration  unDeployed");
    }

    public void deploySynapseArtifactsFromFileSystem(String directoryPath, String backendURL, String sessionCookie) throws Exception {
        File[] fileList = new File(directoryPath).listFiles();
        HashMap<String, File[]> fileStructure = new HashMap<String, File[]>();
        for (int x = 0; x <= fileList.length - 1; ++x) {
            File FileName = fileList[x];
            fileStructure.put(FileName.getName(), FileName.listFiles());
        }
        Iterator i$ = fileStructure.entrySet().iterator();
        while (i$.hasNext()) {
            String[] filePathArr;
            Map.Entry stringEntry;
            Map.Entry entry = stringEntry = i$.next();
            File[] fileArr = (File[])entry.getValue();
            if (entry.getKey().equals(API)) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement apiOmElement = this.loadResource(filePathArr[1]);
                    String apiName = apiOmElement.getAttributeValue(new QName(NAME));
                    if (this.isApiExist(backendURL, sessionCookie, apiName)) {
                        this.deleteApi(backendURL, sessionCookie, apiName);
                    }
                    this.addAPI(backendURL, sessionCookie, apiOmElement);
                    Assert.assertTrue((boolean)this.isApiDeployed(backendURL, sessionCookie, apiName), (String)("api " + apiName + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("endpoints")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement endpointOmElement = this.loadResource(filePathArr[1]);
                    String endpointName = endpointOmElement.getAttributeValue(new QName(NAME));
                    if (this.isEndpointExist(backendURL, sessionCookie, endpointName)) {
                        this.deleteEndpoint(backendURL, sessionCookie, endpointName);
                    }
                    this.addEndpoint(backendURL, sessionCookie, endpointOmElement);
                    Assert.assertTrue((boolean)this.isEndpointDeployed(backendURL, sessionCookie, endpointName), (String)("endpoint " + endpointName + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("priority-executors")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement priorityExecutorsOmElement = this.loadResource(filePathArr[1]);
                    String proxyExecutorName = priorityExecutorsOmElement.getAttributeValue(new QName(NAME));
                    if (this.isPriorityExecutorExist(backendURL, sessionCookie, proxyExecutorName)) {
                        this.deletePriorityExecutor(backendURL, sessionCookie, proxyExecutorName);
                    }
                    this.addPriorityExecutor(backendURL, sessionCookie, priorityExecutorsOmElement);
                    Assert.assertTrue((boolean)this.isPriorityExecutorDeployed(backendURL, sessionCookie, proxyExecutorName), (String)("priority-executor " + proxyExecutorName + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("sequences")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement sequencesOmElement = this.loadResource(filePathArr[1]);
                    String sequenceName = sequencesOmElement.getAttributeValue(new QName(NAME));
                    if (this.isSequenceExist(backendURL, sessionCookie, sequenceName)) {
                        this.deleteSequence(backendURL, sessionCookie, sequenceName);
                    }
                    this.addSequence(backendURL, sessionCookie, sequencesOmElement);
                    Assert.assertTrue((boolean)this.isSequenceDeployed(backendURL, sessionCookie, sequenceName), (String)("sequence " + sequenceName + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("proxy-services")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement proxyServicesOmElement = this.loadResource(filePathArr[1]);
                    String proxyServiceName = proxyServicesOmElement.getAttributeValue(new QName(NAME));
                    if (this.isProxyServiceExist(backendURL, sessionCookie, proxyServiceName)) {
                        this.deleteProxyService(backendURL, sessionCookie, proxyServiceName);
                    }
                    this.addProxyService(backendURL, sessionCookie, proxyServicesOmElement);
                    Assert.assertTrue((boolean)this.isProxyDeployed(backendURL, sessionCookie, proxyServiceName), (String)("proxy-service " + proxyServiceName + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("local-entries")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement localEntriesOmElement = this.loadResource(filePathArr[1]);
                    String localEntryKey = localEntriesOmElement.getAttributeValue(new QName(KEY));
                    if (this.isLocalEntryExist(backendURL, sessionCookie, localEntryKey)) {
                        this.deleteLocalEntry(backendURL, sessionCookie, localEntryKey);
                    }
                    this.addLocalEntry(backendURL, sessionCookie, localEntriesOmElement);
                    Assert.assertTrue((boolean)this.isLocalEntryDeployed(backendURL, sessionCookie, localEntryKey), (String)("local-entry " + localEntryKey + "deployment failure"));
                }
                continue;
            }
            if (entry.getKey().equals("tasks")) {
                for (File aFileArr : fileArr) {
                    filePathArr = aFileArr.getAbsolutePath().split(TestConfigurationProvider.getResourceLocation());
                    OMElement taskOmElement = this.loadResource(filePathArr[1]);
                    if (taskOmElement.getNamespace().getPrefix().equals("")) {
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        OMNamespace omNs = fac.createOMNamespace("http://www.wso2.org/products/wso2commons/tasks", TASK);
                        taskOmElement.setNamespace(omNs);
                        Iterator it = taskOmElement.getChildElements();
                        while (it.hasNext()) {
                            ((OMElement)it.next()).setNamespace(omNs);
                        }
                    }
                    String taskName = taskOmElement.getAttributeValue(new QName(NAME));
                    String taskGroup = taskOmElement.getAttributeValue(new QName("group"));
                    if (this.isScheduleTaskExist(backendURL, sessionCookie, taskName)) {
                        this.deleteScheduleTask(backendURL, sessionCookie, taskName, taskGroup);
                    }
                    this.addScheduleTask(backendURL, sessionCookie, taskOmElement);
                    Assert.assertTrue((boolean)this.isScheduleTaskDeployed(backendURL, sessionCookie, taskName), (String)("task " + taskName + "deployment failure"));
                }
                continue;
            }
            this.log.info((Object)(entry.getKey() + " was not deployed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String sourceUri, String destUri) throws IOException {
        File sourceFile = new File(sourceUri);
        File destFile = new File(destUri);
        if (destFile.exists()) {
            destFile.delete();
        }
        destFile.createNewFile();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(sourceFile);
            fileOutputStream = new FileOutputStream(destFile);
            FileChannel source = fileInputStream.getChannel();
            FileChannel destination = fileOutputStream.getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public boolean isFileEmpty(String fullPath) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fullPath));
            if (br.readLine() == null) {
                return true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.info((Object)("Synapse config file cannot be found in " + fullPath + " copying Backup Config to the location."));
            return true;
        }
        catch (IOException ioException) {
            this.log.info((Object)("Couldn't read the synapse config from the location " + fullPath));
        }
        return false;
    }

    public static Map<String, Object> decompress(String str) {
        ByteArrayInputStream byteInputStream = null;
        GZIPInputStream gzipInputStream = null;
        try {
            ThreadLocal<Kryo> kryoTL = new ThreadLocal<Kryo>(){

                @Override
                protected Kryo initialValue() {
                    Kryo kryo = new Kryo();
                    kryo.register(HashMap.class, 111);
                    kryo.register(ArrayList.class, 222);
                    kryo.register(PublishingPayload.class, 333);
                    return kryo;
                }
            };
            byteInputStream = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)str));
            gzipInputStream = new GZIPInputStream(byteInputStream);
            byte[] unzippedBytes = IOUtils.toByteArray((InputStream)gzipInputStream);
            Input input = new Input(unzippedBytes);
            Map map = (Map)((Kryo)kryoTL.get()).readObjectOrNull(input, HashMap.class);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Error occured while decompressing events string: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteInputStream != null) {
                    byteInputStream.close();
                }
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

