/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients.rabbitmqclient;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;

public class RabbitMQProducerClient {
    private ConnectionFactory factory = new ConnectionFactory();
    private Connection connection = null;
    private Channel channel = null;
    private String exchangeName;
    private String routeKey;

    public RabbitMQProducerClient(String host, int port, String username, String password) {
        this.factory.setHost(host);
        this.factory.setPort(port);
        this.factory.setUsername(username);
        this.factory.setPassword(password);
    }

    public void declareAndConnect(String exchangeName, String routeKey) throws IOException {
        this.connection = this.factory.newConnection();
        this.channel = this.connection.createChannel();
        this.exchangeName = exchangeName;
        this.routeKey = routeKey;
        try {
            this.channel.exchangeDeclarePassive(exchangeName);
        }
        catch (IOException e) {
            if (!this.channel.isOpen()) {
                this.channel = this.connection.createChannel();
            }
            this.channel.exchangeDeclare(exchangeName, "direct");
        }
        try {
            this.channel.queueDeclarePassive(routeKey);
        }
        catch (IOException e) {
            if (!this.channel.isOpen()) {
                this.channel = this.connection.createChannel();
            }
            this.channel.queueDeclare(routeKey, false, false, false, null);
        }
        this.channel.queueBind(routeKey, exchangeName, routeKey);
    }

    public void sendMessage(String message, String contentType) throws IOException {
        this.channel.basicPublish(this.exchangeName, this.routeKey, new AMQP.BasicProperties.Builder().contentType(contentType).build(), message.getBytes());
    }

    public void disconnect() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.connection.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

