/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.clients;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class SimpleHttpClient {
    private DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());

    public SimpleHttpClient() {
        HttpParams params = this.client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)30000);
        this.client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException e, int i, HttpContext httpContext) {
                return false;
            }
        });
    }

    public HttpResponse doGet(String url, Map<String, String> headers) throws IOException {
        HttpGet request = new HttpGet(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        return this.client.execute((HttpUriRequest)request);
    }

    public HttpResponse doPost(String url, Map<String, String> headers, final String payload, String contentType) throws IOException {
        HttpPost request = new HttpPost(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        HttpEntityEnclosingRequest entityEncReq = (HttpEntityEnclosingRequest)request;
        final boolean zip = headers != null && "gzip".equals(headers.get("Content-Encoding"));
        EntityTemplate ent = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outputStream) throws IOException {
                OutputStream out = outputStream;
                if (zip) {
                    out = new GZIPOutputStream(outputStream);
                }
                out.write(payload.getBytes());
                out.flush();
                out.close();
            }
        });
        ent.setContentType(contentType);
        if (zip) {
            ent.setContentEncoding("gzip");
        }
        entityEncReq.setEntity((HttpEntity)ent);
        return this.client.execute((HttpUriRequest)request);
    }

    public String getResponsePayload(HttpResponse response) throws IOException {
        if (response.getEntity() != null) {
            int length;
            InputStream in = response.getEntity().getContent();
            byte[] tmp = new byte[2048];
            StringBuilder buffer = new StringBuilder();
            while ((length = in.read(tmp)) != -1) {
                buffer.append(new String(tmp, 0, length));
            }
            return buffer.toString();
        }
        return null;
    }

    public HttpResponse doPatch(String url, Map<String, String> headers, final String payload, String contentType) throws IOException {
        HttpPatch request = new HttpPatch(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        HttpEntityEnclosingRequest entityEncReq = (HttpEntityEnclosingRequest)request;
        final boolean zip = headers != null && "gzip".equals(headers.get("Content-Encoding"));
        EntityTemplate ent = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outputStream) throws IOException {
                OutputStream out = outputStream;
                if (zip) {
                    out = new GZIPOutputStream(outputStream);
                }
                out.write(payload.getBytes());
                out.flush();
                out.close();
            }
        });
        ent.setContentType(contentType);
        if (zip) {
            ent.setContentEncoding("gzip");
        }
        entityEncReq.setEntity((HttpEntity)ent);
        return this.client.execute((HttpUriRequest)request);
    }

    public HttpResponse doOptions(String url, Map<String, String> headers, final String payload, String contentType) throws IOException {
        HttpOptions request = new HttpOptions(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        if (payload != null) {
            HttpEntityEnclosingRequest entityEncReq = (HttpEntityEnclosingRequest)request;
            final boolean zip = headers != null && "gzip".equals(headers.get("Content-Encoding"));
            EntityTemplate ent = new EntityTemplate(new ContentProducer(){

                public void writeTo(OutputStream outputStream) throws IOException {
                    OutputStream out = outputStream;
                    if (zip) {
                        out = new GZIPOutputStream(outputStream);
                    }
                    out.write(payload.getBytes());
                    out.flush();
                    out.close();
                }
            });
            ent.setContentType(contentType);
            if (zip) {
                ent.setContentEncoding("gzip");
            }
            entityEncReq.setEntity((HttpEntity)ent);
        }
        return this.client.execute((HttpUriRequest)request);
    }

    public HttpResponse doHead(String url, Map<String, String> headers) throws IOException {
        HttpHead request = new HttpHead(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        return this.client.execute((HttpUriRequest)request);
    }

    public HttpResponse doDelete(String url, Map<String, String> headers) throws IOException {
        HttpDelete request = new HttpDelete(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        return this.client.execute((HttpUriRequest)request);
    }

    public HttpResponse doPut(String url, Map<String, String> headers, final String payload, String contentType) throws IOException {
        HttpPut request = new HttpPut(url);
        this.setHeaders(headers, (HttpUriRequest)request);
        HttpEntityEnclosingRequest entityEncReq = (HttpEntityEnclosingRequest)request;
        final boolean zip = headers != null && "gzip".equals(headers.get("Content-Encoding"));
        EntityTemplate ent = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outputStream) throws IOException {
                OutputStream out = outputStream;
                if (zip) {
                    out = new GZIPOutputStream(outputStream);
                }
                out.write(payload.getBytes());
                out.flush();
                out.close();
            }
        });
        ent.setContentType(contentType);
        if (zip) {
            ent.setContentEncoding("gzip");
        }
        entityEncReq.setEntity((HttpEntity)ent);
        return this.client.execute((HttpUriRequest)request);
    }

    private void setHeaders(Map<String, String> headers, HttpUriRequest request) {
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.setHeader(header.getKey(), header.getValue());
            }
        }
    }
}

