/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.ServerAdminClient;
import org.wso2.carbon.integration.common.utils.ClientConnectionUtil;
import org.wso2.carbon.integration.common.utils.FileManager;
import org.wso2.carbon.integration.common.utils.LoginLogoutClient;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.server.admin.stub.ServerAdminException;

public class ServerConfigurationManager {
    private static final long TIME_OUT = 600000L;
    private File originalConfig;
    private File backUpConfig;
    private int port;
    private String hostname;
    private String backEndUrl;
    private AutomationContext autoCtx;
    private String sessionCookie;
    private LoginLogoutClient loginLogoutClient;
    private List<ConfigData> configDatas = new ArrayList<ConfigData>();

    public ServerConfigurationManager(String productGroup, TestUserMode userMode) throws AutomationUtilException, XPathExpressionException, MalformedURLException {
        this.autoCtx = new AutomationContext(productGroup, userMode);
        this.loginLogoutClient = new LoginLogoutClient(this.autoCtx);
        this.backEndUrl = this.autoCtx.getContextUrls().getBackEndUrl();
        this.port = new URL(this.backEndUrl).getPort();
        this.hostname = new URL(this.backEndUrl).getHost();
    }

    public ServerConfigurationManager(AutomationContext autoCtx) throws AutomationUtilException, XPathExpressionException, MalformedURLException {
        this.loginLogoutClient = new LoginLogoutClient(autoCtx);
        this.autoCtx = autoCtx;
        this.backEndUrl = autoCtx.getContextUrls().getBackEndUrl();
        this.port = new URL(this.backEndUrl).getPort();
        this.hostname = new URL(this.backEndUrl).getHost();
    }

    private void backupConfiguration(String fileName) throws IOException {
        String carbonHome = System.getProperty("carbon.home");
        String confDir = Paths.get(carbonHome, "conf").toString();
        String AXIS2_XML = "axis2";
        if (fileName.contains(AXIS2_XML)) {
            confDir = Paths.get(confDir, "axis2").toString();
        }
        this.originalConfig = Paths.get(confDir, fileName).toFile();
        this.backUpConfig = Paths.get(confDir, fileName + ".backup").toFile();
        Files.move(this.originalConfig.toPath(), this.backUpConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.originalConfig.exists()) {
            throw new IOException("Failed to rename file from " + this.originalConfig.getName() + "to" + this.backUpConfig.getName());
        }
        this.configDatas.add(new ConfigData(this.backUpConfig, this.originalConfig));
    }

    private void backupConfiguration(File file) throws IOException {
        this.originalConfig = file;
        this.backUpConfig = new File(file.getAbsolutePath() + ".backup");
        Files.move(this.originalConfig.toPath(), this.backUpConfig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.originalConfig.exists()) {
            throw new IOException("Failed to rename file from " + this.originalConfig.getName() + "to" + this.backUpConfig.getName());
        }
        this.configDatas.add(new ConfigData(this.backUpConfig, this.originalConfig));
    }

    public static String getCarbonHome() {
        return System.getProperty("carbon.home");
    }

    public void applyConfigurationWithoutRestart(File sourceFile, File targetFile, boolean backup) throws IOException {
        FileChannel source = null;
        FileChannel destination = null;
        if (backup) {
            this.backupConfiguration(targetFile);
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(this.originalConfig).getChannel();
        } else {
            if (!targetFile.exists() && !targetFile.createNewFile()) {
                throw new IOException("File " + targetFile + "creation fails");
            }
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(targetFile).getChannel();
        }
        destination.transferFrom(source, 0L, source.size());
        if (source != null) {
            source.close();
        }
        if (destination != null) {
            destination.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfiguration(File sourceFile, File targetFile, boolean backupConfigFile, boolean restartServer) throws AutomationUtilException, IOException {
        AbstractInterruptibleChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            if (backupConfigFile) {
                this.backupConfiguration(targetFile);
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(this.originalConfig).getChannel();
            } else {
                if (!targetFile.exists() && !targetFile.createNewFile()) {
                    throw new IOException("File " + targetFile + "creation fails");
                }
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(targetFile).getChannel();
            }
            ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            if (restartServer) {
                this.restartGracefully();
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void restoreToLastConfiguration() throws IOException, AutomationUtilException {
        this.restoreToLastConfiguration(true);
    }

    public void restoreToLastConfiguration(boolean isRestartRequired) throws AutomationUtilException, IOException {
        for (ConfigData data : this.configDatas) {
            Files.move(data.getBackupConfig().toPath(), data.getOriginalConfig().toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (!data.getBackupConfig().exists()) continue;
            throw new IOException("File rename from " + data.getBackupConfig() + "to " + data.getOriginalConfig() + "fails");
        }
        if (isRestartRequired) {
            this.restartGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfiguration(File newConfig) throws AutomationUtilException, IOException {
        this.backupConfiguration(newConfig.getName());
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(newConfig), StandardCharsets.UTF_8);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.originalConfig), StandardCharsets.UTF_8);
        try {
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.restartGracefully();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfigurationWithoutRestart(File newConfig) throws IOException {
        this.backupConfiguration(newConfig.getName());
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(newConfig), StandardCharsets.UTF_8);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.originalConfig), StandardCharsets.UTF_8);
        try {
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyConfiguration(File sourceFile, File targetFile) throws AutomationUtilException, IOException {
        this.backupConfiguration(targetFile.getName());
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(sourceFile), StandardCharsets.UTF_8);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.originalConfig), StandardCharsets.UTF_8);
        try {
            int c;
            while ((c = in.read()) != -1) {
                out.write(c);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.restartGracefully();
    }

    public void restartGracefully() throws AutomationUtilException {
        this.restartGracefully(600000L);
    }

    public void restartGracefully(long timeout) throws AutomationUtilException {
        try {
            this.sessionCookie = this.loginLogoutClient.login();
            ServerAdminClient serverAdmin = new ServerAdminClient(this.backEndUrl, this.sessionCookie);
            serverAdmin.restartGracefully();
            try {
                Thread.sleep(25000L);
                ClientConnectionUtil.waitForPort((int)this.port, (long)timeout, (boolean)true, (String)this.hostname);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ClientConnectionUtil.waitForLogin((AutomationContext)this.autoCtx);
        }
        catch (MalformedURLException | RemoteException | LoginAuthenticationExceptionException | ServerAdminException e) {
            throw new AutomationUtilException("Error while gracefully restarting the server ", e);
        }
    }

    public void restartGracefully(String sessionCookie) throws AutomationUtilException {
        try {
            ServerAdminClient serverAdmin = new ServerAdminClient(this.backEndUrl, sessionCookie);
            serverAdmin.restartGracefully();
            try {
                Thread.sleep(20000L);
                ClientConnectionUtil.waitForPort((int)this.port, (long)600000L, (boolean)true, (String)this.hostname);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ClientConnectionUtil.waitForLogin((AutomationContext)this.autoCtx);
        }
        catch (RemoteException e) {
            throw new AutomationUtilException("Error while gracefully restarting the server ", (Throwable)e);
        }
        catch (ServerAdminException e) {
            throw new AutomationUtilException("Error while gracefully restarting the server ", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new AutomationUtilException("Error while gracefully restarting the server ", (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            throw new AutomationUtilException("Error while gracefully restarting the server ", (Throwable)e);
        }
    }

    public void restartForcefully() throws AutomationUtilException {
        try {
            this.sessionCookie = this.loginLogoutClient.login();
            ServerAdminClient serverAdmin = new ServerAdminClient(this.backEndUrl, this.sessionCookie);
            serverAdmin.restart();
            try {
                Thread.sleep(20000L);
                ClientConnectionUtil.waitForPort((int)this.port, (long)600000L, (boolean)true, (String)this.hostname);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ClientConnectionUtil.waitForLogin((AutomationContext)this.autoCtx);
        }
        catch (RemoteException e) {
            throw new AutomationUtilException("Error while forcefully restarting the server ", (Throwable)e);
        }
        catch (ServerAdminException e) {
            throw new AutomationUtilException("Error while forcefully restarting the server ", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new AutomationUtilException("Error while forcefully restarting the server ", (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            throw new AutomationUtilException("Error while forcefully restarting the server ", (Throwable)e);
        }
    }

    public void copyToComponentLib(File jar) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String lib = Paths.get(carbonHome, "lib").toString();
        FileManager.copyJarFile((File)jar, (String)lib);
    }

    public void removeFromComponentLib(String fileName) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String filePath = Paths.get(carbonHome, "lib", fileName).toString();
        FileManager.deleteFile((String)filePath);
        fileName = fileName.replace("-", "_");
        fileName = fileName.replace(".jar", "_1.0.0.jar");
        this.removeFromComponentDropins(fileName);
    }

    public void copyToComponentDropins(File jar) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        String lib = Paths.get(carbonHome, "dropins").toString();
        FileManager.copyJarFile((File)jar, (String)lib);
    }

    public void removeFromComponentDropins(String fileName) throws IOException, URISyntaxException {
        String carbonHome = System.getProperty("carbon.home");
        URI filePath = Paths.get(carbonHome, "dropins", fileName).toUri();
        File file = Paths.get(filePath).toFile();
        if (file.exists()) {
            FileManager.deleteFile((String)file.getAbsolutePath());
        }
    }

    public void reInitializeConfigData() {
        this.configDatas = new ArrayList<ConfigData>();
    }

    private static class ConfigData {
        private File backupConfig;
        private File originalConfig;

        public ConfigData(File backupConfig, File originalConfig) {
            this.backupConfig = backupConfig;
            this.originalConfig = originalConfig;
        }

        public File getBackupConfig() {
            return this.backupConfig;
        }

        public File getOriginalConfig() {
            return this.originalConfig;
        }
    }
}

