/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.businessprocess.utils.migration.deployment;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.wso2.carbon.humantask.HumanInteractionsDocument;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentException;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnitBuilder;
import org.wso2.carbon.humantask.core.deployment.HumanTaskWSDLLocator;
import org.wso2.carbon.humantask.core.deployment.config.HTDeploymentConfigDocument;
import org.wso2.carbon.humantask.core.utils.FileUtils;
import org.xml.sax.SAXException;

public class ArchiveBasedHumanTaskDeploymentUnitBuilder
extends HumanTaskDeploymentUnitBuilder {
    private static final FileFilter wsdlFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.getName().endsWith(".wsdl") && path.isFile();
        }
    };
    private static final FileFilter xsdFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.getName().endsWith(".xsd") && path.isFile();
        }
    };
    private static final FileFilter humantaskFilter = new FileFilter(){

        @Override
        public boolean accept(File path) {
            return path.getName().endsWith(".ht") && path.isFile();
        }
    };
    private File humantaskDir;
    private String fileName;
    private long version;
    private String md5sum;
    private List<Definition> wsdlDefinitions = new ArrayList<Definition>();
    private InputStream hiDefinition;
    private InputStream hiConfiguration;
    private File humanTaskDefinitionFile;
    private Map<String, InputStream> schemasMap = new HashMap<String, InputStream>();

    public ArchiveBasedHumanTaskDeploymentUnitBuilder(String BPS_HOME, File hiArchiveZip, int tenantId, long version, String md5sum) throws HumanTaskDeploymentException {
        String hiArchiveZipName = hiArchiveZip.getName();
        this.fileName = FilenameUtils.removeExtension((String)hiArchiveZipName);
        this.version = version;
        this.md5sum = md5sum;
        this.humantaskDir = ArchiveBasedHumanTaskDeploymentUnitBuilder.extractHumanTaskArchive(hiArchiveZip, tenantId, version, BPS_HOME);
        this.buildHumanInteractionDocuments();
        this.buildDeploymentConfiguration();
        this.buildWSDLs();
        this.buildSchemas();
    }

    public ArchiveBasedHumanTaskDeploymentUnitBuilder(File extractedTaskArchive, int tenantId, long version, String packageName, String md5sum) throws HumanTaskDeploymentException {
        this.fileName = packageName;
        this.version = version;
        this.humantaskDir = extractedTaskArchive;
        this.md5sum = md5sum;
        this.buildHumanInteractionDocuments();
        this.buildDeploymentConfiguration();
        this.buildWSDLs();
        this.buildSchemas();
    }

    public static Definition readInTheWSDLFile(InputStream in, String entryName, boolean fromRegistry) throws WSDLException {
        Document doc;
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        try {
            doc = XMLUtils.newDocument((InputStream)in);
        }
        catch (ParserConfigurationException e) {
            throw new WSDLException("PARSER_ERROR", "Parser Configuration Error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSDLException("PARSER_ERROR", "Parser SAX Error", (Throwable)e);
        }
        catch (IOException e) {
            throw new WSDLException("INVALID_WSDL", "IO Error", (Throwable)e);
        }
        if (fromRegistry) {
            throw new UnsupportedOperationException("This operation is not currently supported in this version of WSO2 BPS.");
        }
        Definition def = reader.readWSDL(entryName, doc.getDocumentElement());
        def.setDocumentBaseURI(entryName);
        return def;
    }

    public static File extractHumanTaskArchive(File archiveFile, int tenantId, long version, String BPS_HOME) throws HumanTaskDeploymentException {
        ZipInputStream zipStream = null;
        try {
            ZipEntry entry;
            String humanTaskExtractionLocation = BPS_HOME + File.separator + "repository" + File.separator + "humantasks" + File.separator + tenantId + File.separator + FilenameUtils.removeExtension((String)archiveFile.getName()) + "-" + version;
            zipStream = new ZipInputStream(new FileInputStream(archiveFile));
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    if (new File(humanTaskExtractionLocation, entry.getName()).mkdirs() || new File(humanTaskExtractionLocation, entry.getName()).exists()) continue;
                    throw new HumanTaskDeploymentException("Archive extraction failed. Cannot create directory: " + new File(humanTaskExtractionLocation, entry.getName()).getAbsolutePath() + ".");
                }
                File destFile = new File(humanTaskExtractionLocation, entry.getName());
                if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
                    throw new HumanTaskDeploymentException("Archive extraction failed. Cannot create directory: " + destFile.getParentFile().getAbsolutePath());
                }
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destFile));
                ArchiveBasedHumanTaskDeploymentUnitBuilder.copyInputStream(zipStream, outputStream);
            }
            File file = new File(humanTaskExtractionLocation);
            return file;
        }
        catch (IOException e) {
            String errMsg = "Error occurred during extracting the archive: " + archiveFile;
            System.out.println(errMsg);
            throw new HumanTaskDeploymentException(errMsg, (Throwable)e);
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {
                    String errMsg = "Error occurred during extracting the archive: " + archiveFile;
                    System.out.println(errMsg + e);
                    throw new HumanTaskDeploymentException(errMsg, (Throwable)e);
                }
            }
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.close();
    }

    public void buildHumanInteractionDocuments() throws HumanTaskDeploymentException {
        if (this.hiDefinition == null) {
            List hiDefinitionFiles = FileUtils.directoryEntriesInPath((File)this.humantaskDir, (FileFilter)humantaskFilter);
            if (hiDefinitionFiles.size() != 1) {
                String errMsg = hiDefinitionFiles.size() == 0 ? "No human task definition files were found in " + this.fileName : hiDefinitionFiles.size() + " human task definition files were found in " + this.fileName;
                System.out.println(errMsg);
                throw new HumanTaskDeploymentException(errMsg);
            }
            try {
                this.hiDefinition = new FileInputStream((File)hiDefinitionFiles.get(0));
                this.humanTaskDefinitionFile = (File)hiDefinitionFiles.get(0);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive; " + this.fileName, (Throwable)e);
            }
        }
    }

    public void buildDeploymentConfiguration() throws HumanTaskDeploymentException {
        if (this.hiConfiguration == null) {
            File humantaskConfFile = new File(this.humantaskDir, "htconfig.xml");
            if (!humantaskConfFile.exists()) {
                String errMsg = "htconfig.xml file not found for the " + this.fileName;
                System.out.println(errMsg);
                throw new HumanTaskDeploymentException(errMsg);
            }
            try {
                this.hiConfiguration = new FileInputStream(humantaskConfFile);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive: " + this.fileName, (Throwable)e);
            }
        }
    }

    public void buildWSDLs() throws HumanTaskDeploymentException {
        URI baseUri = this.humantaskDir.toURI();
        for (File file : FileUtils.directoryEntriesInPath((File)this.humantaskDir, (FileFilter)wsdlFilter)) {
            try {
                File f;
                URI abUri;
                URI uri = baseUri.relativize(file.toURI());
                if (!uri.isAbsolute() && (abUri = (f = new File(baseUri.getPath() + File.separator + uri.getPath())).toURI()).isAbsolute()) {
                    uri = abUri;
                }
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                reader.setFeature("javax.wsdl.importDocuments", true);
                Definition definition = reader.readWSDL((WSDLLocator)new HumanTaskWSDLLocator(uri));
                this.wsdlDefinitions.add(definition);
            }
            catch (WSDLException e) {
                System.out.println("Error processing wsdl " + file.getName());
                throw new HumanTaskDeploymentException(" Error processing wsdl ", (Throwable)e);
            }
            catch (URISyntaxException e) {
                System.out.println("Invalid uri in reading wsdl ");
                throw new HumanTaskDeploymentException(" Invalid uri in reading wsdl ", (Throwable)e);
            }
        }
    }

    public void buildSchemas() throws HumanTaskDeploymentException {
        for (File file : FileUtils.directoryEntriesInPath((File)this.humantaskDir, (FileFilter)xsdFilter)) {
            FileInputStream is;
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                throw new HumanTaskDeploymentException("Error building humantask archive: " + this.fileName, (Throwable)e);
            }
            this.schemasMap.put(file.getName(), is);
        }
    }

    public HumanInteractionsDocument getHumanInteractionsDocument() throws HumanTaskDeploymentException {
        HumanInteractionsDocument hiDoc;
        try {
            hiDoc = HumanInteractionsDocument.Factory.parse((InputStream)this.hiDefinition);
        }
        catch (Exception e) {
            String errMsg = "Error occurred while parsing the human interaction definition";
            System.out.println(errMsg);
            throw new HumanTaskDeploymentException(errMsg, (Throwable)e);
        }
        return hiDoc;
    }

    public HTDeploymentConfigDocument getHTDeploymentConfigDocument() throws HumanTaskDeploymentException {
        HTDeploymentConfigDocument hiConf;
        try {
            hiConf = HTDeploymentConfigDocument.Factory.parse((InputStream)this.hiConfiguration);
        }
        catch (Exception e) {
            String errMsg = "Error occurred while parsing the human interaction configuration file: htconfig.xml";
            System.out.println(errMsg);
            throw new HumanTaskDeploymentException(errMsg, (Throwable)e);
        }
        return hiConf;
    }

    public String getArchiveName() {
        return this.fileName;
    }

    public List<Definition> getWsdlDefinitions() throws HumanTaskDeploymentException {
        return this.wsdlDefinitions;
    }

    public long getVersion() {
        return this.version;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public File getHumanTaskDefinitionFile() {
        return this.humanTaskDefinitionFile;
    }
}

