package org.wso2.esb.integration.services.jaxrs.coffeesample.bean;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "PaymentStatus")
public class PaymentStatus {

    /**
     * If XmlElement wasn't there, the generated element name will be simple letters, 'status'
     * Here, we modified it to 'Status'
     *
     * name is of type String, and required is of type boolean
     *
     * Since the required attribute is set to true, no get method for this variable
     */
    @XmlElement(name = "Status", required = true)
    private String status;

    /**
     * Since Payment class is also a bean, the JSON content generated by this bean
     * will be wrapped in to PaymentStatus bean
     * ex.
     * {
     * "PaymentStatus":
     * {
     *  "Payment":{"amount":50,"cardNumber":"1234 2345 3456 4567","expiryDate":"01-01-2015","name":"Kasun Gajasinghe"},
     *  "Status":"Payment Accepted"
     *  }
     * }
     *
     */
    @XmlElement(name = "Payment", required = true)
    private Payment payment;

    public PaymentStatus(String status, Payment payment) {
        this.setStatus(status);
        this.setPayment(payment);
    }

    /**
     * A no-arg default constructor is needed for proper operation of JAX-RS
     */
    public PaymentStatus() {

    }

//    public String getStatus() {
//        return status;
//    }
//
//    public Payment getPayment() {
//        return payment;
//    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setPayment(Payment payment) {
        this.payment = payment;
    }
}
