/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.security.pox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultCodeImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultCodeImpl;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12FaultSubCodeImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.w3c.dom.Document;
import org.wso2.micro.integrator.core.services.CarbonServerConfigurationService;

public class POXSecurityHandler
implements Handler {
    public static final String POX_CACHE_MANAGER = "POX_CACHE_MANAGER";
    public static final String POX_ENABLED = "pox-security";
    private static Log log = LogFactory.getLog(POXSecurityHandler.class);
    private static String POX_SECURITY_MODULE = "POXSecurityModule";
    private HandlerDescription description;
    private static final String MESSAGE_TYPE = "messageType";

    public void cleanup() {
    }

    public void init(HandlerDescription description) {
        this.description = description;
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        Parameter serviceParameter;
        if (msgCtx != null && !msgCtx.isEngaged(POX_SECURITY_MODULE)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        AxisService service = null;
        if (msgCtx == null) {
            throw new AxisFault("Error in Axis message context.");
        }
        service = msgCtx.getAxisService();
        if (service == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service not dispatched");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String isAdminService = (String)service.getParameterValue("adminService");
        if (isAdminService != null && JavaUtils.isTrueExplicitly((String)isAdminService)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        String isHiddenService = (String)service.getParameterValue("hiddenService");
        if (isHiddenService != null && JavaUtils.isTrueExplicitly((String)isHiddenService)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        String isReverseProxy = System.getProperty("reverseProxyMode");
        if (isReverseProxy != null && JavaUtils.isTrueExplicitly((String)isReverseProxy)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        boolean isBasicAuth = false;
        Parameter configParameter = msgCtx.getConfigurationContext().getAxisConfiguration().getParameter("enableBasicAuth");
        if (configParameter != null && configParameter.getValue() != null) {
            isBasicAuth = Boolean.parseBoolean(configParameter.getValue().toString());
        }
        if ((serviceParameter = msgCtx.getAxisService().getParameter("enableBasicAuth")) != null && serviceParameter.getValue() != null) {
            isBasicAuth = Boolean.parseBoolean(serviceParameter.getValue().toString());
        }
        if (msgCtx.isFault() && Integer.valueOf(4).equals(msgCtx.getFLOW()) && isBasicAuth) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SOAP Fault occurred and message flow equals to out fault flow. SOAP fault :" + msgCtx.getEnvelope().toString()));
            }
            try {
                String scenarioID = null;
                if (service.getPolicySubject().getAttachedPolicyComponent("UTOverTransport") != null) {
                    scenarioID = "scenario1";
                }
                if (scenarioID != null && scenarioID.equals("scenario1")) {
                    boolean authenticationError = false;
                    String faultCode = null;
                    SOAPFaultCode faultCodeObject = msgCtx.getEnvelope().getBody().getFault().getCode();
                    if (faultCodeObject instanceof SOAP11FaultCodeImpl) {
                        faultCode = ((SOAP11FaultCodeImpl)faultCodeObject).getTextContent();
                    } else if (faultCodeObject instanceof SOAP12FaultCodeImpl) {
                        faultCode = null != ((SOAP12FaultCodeImpl)faultCodeObject).getSubCode() ? ((SOAP12FaultSubCodeImpl)((SOAP12FaultCodeImpl)faultCodeObject).getSubCode()).getTextContent() : ((SOAP12FaultCodeImpl)faultCodeObject).getTextContent();
                    }
                    if (faultCode != null && faultCode.contains("FailedAuthentication")) {
                        authenticationError = true;
                    }
                    if (authenticationError) {
                        SOAPFault soapFault;
                        this.setAuthHeaders(msgCtx);
                        if (msgCtx.isDoingREST() && (soapFault = msgCtx.getEnvelope().getBody().getFault()) != null) {
                            Iterator itr = soapFault.getChildren();
                            while (itr.hasNext()) {
                                OMNode omNode = (OMNode)itr.next();
                                if (omNode == null) continue;
                                itr.remove();
                            }
                        }
                    }
                    return Handler.InvocationResponse.CONTINUE;
                }
            }
            catch (Exception e) {
                throw new AxisFault("System error", (Throwable)msgCtx.getFailureReason());
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgCtx.getIncomingTransportName() == null) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!StringUtils.equals((String)"https", (String)msgCtx.getIncomingTransportName()) && !StringUtils.equals((String)"http", (String)msgCtx.getIncomingTransportName())) {
            return Handler.InvocationResponse.CONTINUE;
        }
        String basicAuthHeader = this.getBasicAuthHeaders(msgCtx);
        boolean soapWithoutSecHeader = this.isSOAPWithoutSecHeader(msgCtx);
        if (!msgCtx.isDoingREST() && soapWithoutSecHeader && basicAuthHeader == null && !isBasicAuth) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (msgCtx.isDoingREST() && !isBasicAuth) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (!soapWithoutSecHeader) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Admin service check failed OR cache miss");
        }
        try {
            if (service.getPolicySubject().getAttachedPolicyComponent("UTOverTransport") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Processing POX security");
                }
            } else {
                return Handler.InvocationResponse.CONTINUE;
            }
            String username = null;
            String password = null;
            if (basicAuthHeader != null && basicAuthHeader.startsWith("Basic ")) {
                int i = (basicAuthHeader = new String(Base64.decode((String)basicAuthHeader.substring(6)))).indexOf(58);
                username = i == -1 ? basicAuthHeader : basicAuthHeader.substring(0, i);
                if (i != -1 && StringUtils.equals((String)"", (String)(password = basicAuthHeader.substring(i + 1)))) {
                    password = null;
                }
            }
            if (username == null || password == null || password.trim().length() == 0 || username.trim().length() == 0) {
                this.setAuthHeaders(msgCtx);
                return Handler.InvocationResponse.ABORT;
            }
            Document doc = null;
            SOAPEnvelope soapEnvelop = msgCtx.getEnvelope();
            if (msgCtx.getEnvelope().getHeader() == null) {
                SOAPFactory omFac = (SOAPFactory)soapEnvelop.getOMFactory();
                SOAPEnvelope newEnvelop = omFac.getDefaultEnvelope();
                Iterator itr = soapEnvelop.getBody().getChildren();
                while (itr.hasNext()) {
                    OMNode omNode = (OMNode)itr.next();
                    if (omNode == null) continue;
                    itr.remove();
                    newEnvelop.getBody().addChild(omNode);
                }
                doc = Axis2Util.getDocumentFromSOAPEnvelope((SOAPEnvelope)newEnvelop, (boolean)true);
            } else {
                doc = Axis2Util.getDocumentFromSOAPEnvelope((SOAPEnvelope)soapEnvelop, (boolean)true);
            }
            WSSecHeader secHeader = new WSSecHeader();
            secHeader.insertSecurityHeader(doc);
            WSSecUsernameToken utBuilder = new WSSecUsernameToken();
            utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            utBuilder.setUserInfo(username, password);
            utBuilder.build(doc, secHeader);
            WSSecTimestamp tsBuilder = new WSSecTimestamp();
            tsBuilder.build(doc, secHeader);
            msgCtx.setEnvelope(Axis2Util.getSOAPEnvelopeFromDOMDocument((Document)doc, (boolean)false));
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (WSSecurityException wssEx) {
            throw new AxisFault("WSDoAllReceiver: Error in converting to Document", (Throwable)wssEx);
        }
        catch (Exception e) {
            throw new AxisFault("System error", (Throwable)e);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setAuthHeaders(MessageContext msgCtx) throws IOException {
        MessageContext originalContext;
        String serverName = CarbonServerConfigurationService.getInstance().getFirstProperty("Name");
        if (serverName == null || serverName.trim().length() == 0) {
            serverName = "WSO2 Carbon";
        }
        HttpServletResponse response = (HttpServletResponse)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (msgCtx.isFault() && response == null && (originalContext = (MessageContext)msgCtx.getProperty("axis2.inMsgContext")) != null) {
            response = (HttpServletResponse)originalContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        }
        if (response != null) {
            if (msgCtx.getProperty(MESSAGE_TYPE) != null) {
                response.setContentType(String.valueOf(msgCtx.getProperty(MESSAGE_TYPE)));
            }
            response.setStatus(401);
            response.addHeader("WWW-Authenticate", "BASIC realm=\"" + serverName + "\"");
            response.flushBuffer();
        } else {
            msgCtx.getEnvelope().buildWithAttachments();
            msgCtx.setProperty("NIO-ACK-Requested", (Object)"true");
            msgCtx.setProperty("HTTP_SC", (Object)401);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("WWW-Authenticate", "BASIC realm=\"" + serverName + "\"");
            msgCtx.setProperty("TRANSPORT_HEADERS", responseHeaders);
        }
    }

    private boolean isSOAPWithoutSecHeader(MessageContext msgCtx) {
        SOAPHeader soapHeader = msgCtx.getEnvelope().getHeader();
        if (soapHeader == null) {
            return true;
        }
        ArrayList headerBlocks = soapHeader.getHeaderBlocksWithNSURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (headerBlocks != null) {
            for (Object o : headerBlocks) {
                SOAPHeaderBlock elem = null;
                OMElement element = null;
                if (o instanceof SOAPHeaderBlock) {
                    try {
                        elem = (SOAPHeaderBlock)o;
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while casting to soap header block", (Throwable)e);
                    }
                } else {
                    element = ((OMElement)o).cloneOMElement();
                }
                if (elem != null && "Security".equals(elem.getLocalName())) {
                    return false;
                }
                if (element == null || !"Security".equals(element.getLocalName())) continue;
                return false;
            }
        }
        return true;
    }

    private String getBasicAuthHeaders(MessageContext msgCtx) {
        Map map = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (map == null) {
            return null;
        }
        String tmp = (String)map.get("Authorization");
        if (tmp == null) {
            tmp = (String)map.get("authorization");
        }
        if (tmp != null && tmp.trim().startsWith("Basic ")) {
            return tmp;
        }
        return null;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.description;
    }

    public String getName() {
        return "REST/POX Security handler";
    }

    public Parameter getParameter(String name) {
        return this.description.getParameter(name);
    }
}

