/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.connector.integration.test.base;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.TransportUtils;
import org.jaxen.JaxenException;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.w3c.dom.Document;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.mediation.library.stub.MediationLibraryAdminServiceStub;
import org.wso2.carbon.sequences.stub.types.SequenceEditorException;
import org.wso2.connector.integration.test.base.RestResponse;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;
import org.wso2.esb.integration.common.clients.sequences.SequenceAdminServiceClient;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.clients.axis2client.ConfigurationContextProvider;
import org.xml.sax.SAXException;

public abstract class ConnectorIntegrationTestBase
extends ESBIntegrationTest {
    private String connectorName;
    private static final float SLEEP_TIMER_PROGRESSION_FACTOR = 0.5f;
    private String repoLocation;
    private MediationLibraryAdminServiceStub mediationLibraryAdminServiceStub;
    protected Properties connectorProperties;
    private String pathToProxiesDirectory;
    private String pathToRequestsDirectory;
    private String pathToSequencesDirectory;
    protected String proxyUrl;
    protected String pathToResourcesDirectory;
    protected static final int MULTIPART_TYPE_RELATED = 100001;

    protected void init(String connectorName) throws Exception {
        super.init();
        ConfigurationContextProvider configurationContextProvider = ConfigurationContextProvider.getInstance();
        ConfigurationContext cc = configurationContextProvider.getConfigurationContext();
        this.mediationLibraryAdminServiceStub = new MediationLibraryAdminServiceStub(cc, this.contextUrls.getBackEndUrl() + "MediationLibraryAdminService");
        AuthenticateStub.authenticateStub((String)"admin", (String)"admin", (Stub)this.mediationLibraryAdminServiceStub);
        this.repoLocation = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getProperty("connector_repo").replace("\\", "/") : System.getProperty("connector_repo").replace("/", "/");
        this.uploadConnector(this.repoLocation, connectorName);
        this.connectorName = connectorName = connectorName.split("-")[0];
        int maxAttempts = 3;
        int sleepTimer = 30000;
        for (int attemptCount = 0; attemptCount < maxAttempts; attemptCount = (int)((byte)(attemptCount + 1))) {
            this.log.info((Object)("Sleeping for " + sleepTimer / 1000 + " seconds for connector to upload."));
            Thread.sleep(sleepTimer);
            String[] libraries = this.mediationLibraryAdminServiceStub.getAllLibraries();
            if (Arrays.asList(libraries).contains("{org.wso2.carbon.connector}" + connectorName)) break;
            this.log.info((Object)"Connector upload incomplete. Waiting...");
            sleepTimer = (int)((float)sleepTimer * 0.5f);
        }
        this.updateConnectorStatus("{org.wso2.carbon.connector}" + connectorName, connectorName, "org.wso2.carbon.connector", "enabled");
        this.connectorProperties = this.getConnectorConfigProperties(connectorName);
        String resourceLocation = FrameworkPathUtil.getSystemResourceLocation();
        this.pathToProxiesDirectory = resourceLocation + this.connectorProperties.getProperty("proxyDirectoryRelativePath");
        this.pathToRequestsDirectory = resourceLocation + this.connectorProperties.getProperty("requestDirectoryRelativePath");
        this.pathToResourcesDirectory = resourceLocation + this.connectorProperties.getProperty("resourceDirectoryRelativePath");
        File folder = new File(this.pathToProxiesDirectory);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            String fileName;
            if (!listOfFiles[i].isFile() || !(fileName = listOfFiles[i].getName()).endsWith(".xml") && !fileName.endsWith(".XML")) continue;
            this.addProxyService(this.esbUtils.loadResource(this.connectorProperties.getProperty("proxyDirectoryRelativePath") + fileName));
        }
        String sequenceDirectoryRelativePath = this.connectorProperties.getProperty("sequenceDirectoryRelativePath");
        if (sequenceDirectoryRelativePath != null && !sequenceDirectoryRelativePath.isEmpty()) {
            this.pathToSequencesDirectory = this.repoLocation + sequenceDirectoryRelativePath;
            SequenceAdminServiceClient sequenceAdmin = new SequenceAdminServiceClient(this.contextUrls.getBackEndUrl(), this.getSessionCookie());
            File sequenceFolder = new File(this.pathToSequencesDirectory);
            File[] listOfSequenceFiles = sequenceFolder.listFiles();
            for (int i = 0; i < listOfSequenceFiles.length; ++i) {
                String fileName;
                if (!listOfSequenceFiles[i].isFile() || !(fileName = listOfSequenceFiles[i].getName()).endsWith(".xml") && !fileName.endsWith(".XML")) continue;
                sequenceAdmin.addSequence(new DataHandler(new URL("file:///" + this.pathToSequencesDirectory + fileName)));
            }
        }
        this.proxyUrl = this.getProxyServiceURLHttp(connectorName);
    }

    public void uploadSequences() throws MalformedURLException, SequenceEditorException, IOException, XMLStreamException {
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpEsb() throws Exception {
        this.deleteProxyService(this.connectorName);
    }

    protected RestResponse<JSONObject> sendJsonRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap) throws IOException, JSONException {
        return this.sendJsonRestRequest(endPoint, httpMethod, headersMap, null, null);
    }

    protected RestResponse<OMElement> sendXmlRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap) throws IOException, XMLStreamException {
        return this.sendXmlRestRequest(endPoint, httpMethod, headersMap, null, null);
    }

    protected RestResponse<JSONObject> sendJsonRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName) throws IOException, JSONException {
        return this.sendJsonRestRequest(endPoint, httpMethod, headersMap, requestFileName, null);
    }

    protected RestResponse<OMElement> sendXmlRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName) throws IOException, XMLStreamException {
        return this.sendXmlRestRequest(endPoint, httpMethod, headersMap, requestFileName, null);
    }

    protected RestResponse<JSONObject> sendJsonRestRequestHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, JSONException {
        return this.sendJsonRestRequestHTTPS(endPoint, httpMethod, headersMap, requestFileName, parametersMap, false);
    }

    protected RestResponse<OMElement> sendXmlRestRequestHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, XMLStreamException {
        return this.sendXmlRestRequestHTTPS(endPoint, httpMethod, headersMap, requestFileName, parametersMap, false);
    }

    protected RestResponse<JSONObject> sendJsonRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, JSONException {
        HttpURLConnection httpConnection = this.writeRequest(endPoint, httpMethod, (byte)1, headersMap, requestFileName, parametersMap);
        String responseString = this.readResponse(httpConnection);
        RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
        restResponse.setHttpStatusCode(httpConnection.getResponseCode());
        restResponse.setHeadersMap(httpConnection.getHeaderFields());
        if (responseString != null) {
            JSONObject jsonObject = null;
            if (this.isValidJSON(responseString)) {
                jsonObject = new JSONObject(responseString);
            } else {
                jsonObject = new JSONObject();
                jsonObject.put("output", (Object)responseString);
            }
            restResponse.setBody(jsonObject);
        }
        return restResponse;
    }

    protected RestResponse<JSONObject> sendJsonRestRequestHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap, boolean isIgnoreHostVerification) throws IOException, JSONException {
        HttpsURLConnection httpsConnection = this.writeRequestHTTPS(endPoint, httpMethod, (byte)1, headersMap, requestFileName, parametersMap, isIgnoreHostVerification);
        String responseString = this.readResponseHTTPS(httpsConnection);
        RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
        restResponse.setHttpStatusCode(httpsConnection.getResponseCode());
        restResponse.setHeadersMap(httpsConnection.getHeaderFields());
        if (responseString != null) {
            JSONObject jsonObject = null;
            if (this.isValidJSON(responseString)) {
                jsonObject = new JSONObject(responseString);
            } else {
                jsonObject = new JSONObject();
                jsonObject.put("output", (Object)responseString);
            }
            restResponse.setBody(jsonObject);
        }
        return restResponse;
    }

    protected RestResponse<OMElement> sendXmlRestRequest(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, XMLStreamException {
        HttpURLConnection httpConnection = this.writeRequest(endPoint, httpMethod, (byte)2, headersMap, requestFileName, parametersMap);
        String responseString = this.readResponse(httpConnection);
        RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
        restResponse.setHttpStatusCode(httpConnection.getResponseCode());
        restResponse.setHeadersMap(httpConnection.getHeaderFields());
        if (responseString != null) {
            if (!this.isValidXML(responseString)) {
                responseString = "<output>" + responseString + "</output>";
            }
            restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
        }
        return restResponse;
    }

    protected RestResponse<OMElement> sendXmlRestRequestHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap, boolean isIgnoreHostVerification) throws IOException, XMLStreamException {
        HttpsURLConnection httpsConnection = this.writeRequestHTTPS(endPoint, httpMethod, (byte)2, headersMap, requestFileName, parametersMap, isIgnoreHostVerification);
        String responseString = this.readResponseHTTPS(httpsConnection);
        RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
        restResponse.setHttpStatusCode(httpsConnection.getResponseCode());
        restResponse.setHeadersMap(httpsConnection.getHeaderFields());
        if (responseString != null) {
            if (!this.isValidXML(responseString)) {
                responseString = "<output>" + responseString + "</output>";
            }
            restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
        }
        return restResponse;
    }

    protected SOAPEnvelope sendSOAPRequest(String endpoint, String soapRequestFileName) throws XMLStreamException, IOException {
        return this.sendSOAPRequest(endpoint, soapRequestFileName, null);
    }

    @Deprecated
    protected SOAPEnvelope sendSOAPRequest(String endpoint, String soapRequestFileName, Map<String, String> parametersMap) throws XMLStreamException, IOException {
        OMElement requestEnvelope = AXIOMUtil.stringToOM((String)this.loadRequestFromFile(soapRequestFileName, parametersMap));
        OperationClient mepClient = this.buildMEPClient(new EndpointReference(endpoint), requestEnvelope);
        mepClient.execute(true);
        return mepClient.getMessageContext("In").getEnvelope();
    }

    @Deprecated
    protected SOAPEnvelope sendSOAPRequest(String endpoint, String soapRequestFileName, Map<String, String> parametersMap, Map<String, String> attachmentMap) throws XMLStreamException, IOException {
        OMElement requestEnvelope = AXIOMUtil.stringToOM((String)this.loadRequestFromFile(soapRequestFileName, parametersMap));
        HashMap<String, DataHandler> dataHandlerMap = new HashMap<String, DataHandler>();
        for (String contentId : attachmentMap.keySet()) {
            dataHandlerMap.put(contentId, new DataHandler((DataSource)new FileDataSource(new File(this.pathToRequestsDirectory + attachmentMap.get(contentId)))));
        }
        OperationClient mepClient = this.buildMEPClient(new EndpointReference(endpoint), requestEnvelope, dataHandlerMap);
        mepClient.execute(true);
        return mepClient.getMessageContext("In").getEnvelope();
    }

    protected SOAPEnvelope sendSOAPRequest(String endpoint, String soapRequestFileName, Map<String, String> parametersMap, String action, String xpathHeaderExp, String xpathBodyExp) throws XMLStreamException, IOException, JaxenException {
        OMElement requestEnvelope = AXIOMUtil.stringToOM((String)this.loadRequestFromFile(soapRequestFileName, parametersMap));
        OperationClient mepClient = this.buildMEPClient(new EndpointReference(endpoint), requestEnvelope, action, xpathHeaderExp, xpathBodyExp);
        mepClient.execute(true);
        return mepClient.getMessageContext("In").getEnvelope();
    }

    protected SOAPEnvelope sendSOAPRequest(String endpoint, String soapRequestFileName, Map<String, String> parametersMap, Map<String, String> attachmentMap, String action, String xpathHeaderExp, String xpathBodyExp) throws XMLStreamException, IOException, JaxenException {
        OMElement requestEnvelope = AXIOMUtil.stringToOM((String)this.loadRequestFromFile(soapRequestFileName, parametersMap));
        HashMap<String, DataHandler> dataHandlerMap = new HashMap<String, DataHandler>();
        for (String contentId : attachmentMap.keySet()) {
            dataHandlerMap.put(contentId, new DataHandler((DataSource)new FileDataSource(new File(this.pathToRequestsDirectory + attachmentMap.get(contentId)))));
        }
        OperationClient mepClient = this.buildMEPClient(new EndpointReference(endpoint), requestEnvelope, dataHandlerMap, action, xpathHeaderExp, xpathBodyExp);
        mepClient.execute(true);
        return mepClient.getMessageContext("In").getEnvelope();
    }

    protected InputStream processForInputStream(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, JSONException {
        HttpURLConnection httpConnection = this.writeRequest(endPoint, httpMethod, (byte)1, headersMap, requestFileName, parametersMap);
        InputStream responseStream = null;
        responseStream = httpConnection.getResponseCode() >= 400 ? httpConnection.getErrorStream() : httpConnection.getInputStream();
        return responseStream;
    }

    protected InputStream processForInputStreamHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException, JSONException {
        return this.processForInputStreamHTTPS(endPoint, httpMethod, headersMap, requestFileName, parametersMap, false);
    }

    protected InputStream processForInputStreamHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap, boolean isIgnoreHostVerification) throws IOException, JSONException {
        HttpsURLConnection httpsConnection = this.writeRequestHTTPS(endPoint, httpMethod, (byte)1, headersMap, requestFileName, parametersMap, isIgnoreHostVerification);
        InputStream responseStream = null;
        responseStream = httpsConnection.getResponseCode() >= 400 ? httpsConnection.getErrorStream() : httpsConnection.getInputStream();
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection writeRequest(String endPoint, String httpMethod, byte responseType, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap) throws IOException {
        String requestData = "";
        if (requestFileName != null && !requestFileName.isEmpty()) {
            requestData = this.loadRequestFromFile(requestFileName, parametersMap);
        } else if (responseType == 1) {
            requestData = "{}";
        }
        OutputStream output = null;
        URL url = new URL(endPoint);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setInstanceFollowRedirects(false);
        httpConnection.setRequestMethod(httpMethod);
        for (String key : headersMap.keySet()) {
            httpConnection.setRequestProperty(key, headersMap.get(key));
        }
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            httpConnection.setDoOutput(true);
            try {
                output = httpConnection.getOutputStream();
                output.write(requestData.getBytes(Charset.defaultCharset()));
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException logOrIgnore) {
                        this.log.error((Object)"Error while closing the connection");
                    }
                }
            }
        }
        return httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection writeRequestHTTPS(String endPoint, String httpMethod, byte responseType, Map<String, String> headersMap, String requestFileName, Map<String, String> parametersMap, boolean isIgnoreHostVerification) throws IOException {
        String requestData = "";
        if (requestFileName != null && !requestFileName.isEmpty()) {
            requestData = this.loadRequestFromFile(requestFileName, parametersMap);
        } else if (responseType == 1) {
            requestData = "{}";
        }
        OutputStream output = null;
        URL url = new URL(endPoint);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
        httpsConnection.setInstanceFollowRedirects(false);
        httpsConnection.setRequestMethod(httpMethod);
        if (isIgnoreHostVerification) {
            httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        for (String key : headersMap.keySet()) {
            httpsConnection.setRequestProperty(key, headersMap.get(key));
        }
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            httpsConnection.setDoOutput(true);
            try {
                output = httpsConnection.getOutputStream();
                output.write(requestData.getBytes(Charset.defaultCharset()));
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException logOrIgnore) {
                        this.log.error((Object)"Error while closing the connection");
                    }
                }
            }
        }
        return httpsConnection;
    }

    private String loadRequestFromFile(String requestFileName, Map<String, String> parametersMap) throws IOException {
        String requestFilePath = this.pathToRequestsDirectory + requestFileName;
        String requestData = this.getFileContent(requestFilePath);
        Properties prop = (Properties)this.connectorProperties.clone();
        if (parametersMap != null) {
            prop.putAll(parametersMap);
        }
        Matcher matcher = Pattern.compile("%s\\(([A-Za-z0-9]*)\\)", 32).matcher(requestData);
        while (matcher.find()) {
            String key = matcher.group(1);
            requestData = requestData.replaceAll("%s\\(" + key + "\\)", Matcher.quoteReplacement(prop.getProperty(key)));
        }
        return requestData;
    }

    private String readResponse(HttpURLConnection con) throws IOException {
        InputStream responseStream = null;
        String responseString = null;
        responseStream = con.getResponseCode() >= 400 ? con.getErrorStream() : con.getInputStream();
        if (responseStream != null) {
            int len;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(responseStream));
            StringBuilder stringBuilder = new StringBuilder();
            char[] chars = new char[1024];
            while ((len = bufferedReader.read(chars)) != -1) {
                stringBuilder.append(new String(chars, 0, len));
            }
            if (!stringBuilder.toString().trim().isEmpty()) {
                responseString = stringBuilder.toString();
            }
        }
        return responseString;
    }

    private String readResponseHTTPS(HttpsURLConnection con) throws IOException {
        InputStream responseStream = null;
        String responseString = null;
        responseStream = con.getResponseCode() >= 400 ? con.getErrorStream() : con.getInputStream();
        if (responseStream != null) {
            int len;
            StringBuilder stringBuilder = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((len = responseStream.read(bytes)) != -1) {
                stringBuilder.append(new String(bytes, 0, len));
            }
            if (!stringBuilder.toString().trim().isEmpty()) {
                responseString = stringBuilder.toString();
            }
        }
        return responseString;
    }

    protected Object loadObjectFromFile(String fileName) throws IOException {
        return this.loadObjectFromFile(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadObjectFromFile(String fileName, Map<String, String> paramMap) throws IOException {
        String filePath = this.pathToRequestsDirectory + fileName;
        if (filePath == null || filePath.isEmpty()) {
            throw new IOException("File path cannot be null or empty.");
        }
        Object retObj = null;
        BufferedInputStream bi = null;
        XMLDecoder decoder = null;
        try {
            bi = new BufferedInputStream(new FileInputStream(filePath));
            byte[] buf = new byte[bi.available()];
            bi.read(buf);
            String content = new String(buf);
            if (this.connectorProperties != null) {
                Properties prop = (Properties)this.connectorProperties.clone();
                if (paramMap != null) {
                    prop.putAll(paramMap);
                }
                Matcher matcher = Pattern.compile("%s\\(([A-Za-z0-9]*)\\)", 32).matcher(content);
                while (matcher.find()) {
                    String key = matcher.group(1);
                    content = content.replaceAll("%s\\(" + key + "\\)", Matcher.quoteReplacement(prop.getProperty(key)));
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(Charset.defaultCharset()));
            decoder = new XMLDecoder(in);
            retObj = decoder.readObject();
        }
        finally {
            if (bi != null) {
                bi.close();
            }
            if (decoder != null) {
                decoder.close();
            }
        }
        return retObj;
    }

    @Deprecated
    private OperationClient buildMEPClient(EndpointReference endpoint, OMElement request, Map<String, DataHandler> attachmentMap) throws AxisFault {
        ServiceClient serviceClient = new ServiceClient();
        Options serviceOptions = new Options();
        serviceOptions.setProperty("enableSwA", (Object)"true");
        serviceOptions.setTo(endpoint);
        serviceOptions.setAction("mediate");
        serviceClient.setOptions(serviceOptions);
        MessageContext messageContext = new MessageContext();
        SOAPEnvelope soapEnvelope = TransportUtils.createSOAPEnvelope((OMElement)request);
        messageContext.setEnvelope(soapEnvelope);
        for (String contentId : attachmentMap.keySet()) {
            messageContext.addAttachment(contentId, attachmentMap.get(contentId));
        }
        OperationClient mepClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        mepClient.addMessageContext(messageContext);
        return mepClient;
    }

    @Deprecated
    private OperationClient buildMEPClient(EndpointReference endpoint, OMElement request) throws AxisFault {
        ServiceClient serviceClient = new ServiceClient();
        Options serviceOptions = new Options();
        serviceOptions.setTo(endpoint);
        serviceOptions.setAction("mediate");
        serviceClient.setOptions(serviceOptions);
        MessageContext messageContext = new MessageContext();
        SOAPEnvelope soapEnvelope = TransportUtils.createSOAPEnvelope((OMElement)request);
        messageContext.setEnvelope(soapEnvelope);
        OperationClient mepClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        mepClient.addMessageContext(messageContext);
        return mepClient;
    }

    private OperationClient buildMEPClient(EndpointReference endpoint, OMElement request, String action, String xpathHeaderExp, String xpathBodyExp) throws AxisFault, JaxenException {
        ServiceClient serviceClient = new ServiceClient();
        Options serviceOptions = new Options();
        serviceOptions.setTo(endpoint);
        serviceOptions.setAction(action);
        serviceClient.setOptions(serviceOptions);
        MessageContext messageContext = new MessageContext();
        SOAPEnvelope soapEnvelope = this.createSOAPEnvelope(request, xpathHeaderExp, xpathBodyExp);
        messageContext.setEnvelope(soapEnvelope);
        OperationClient mepClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        mepClient.addMessageContext(messageContext);
        return mepClient;
    }

    private OperationClient buildMEPClient(EndpointReference endpoint, OMElement request, Map<String, DataHandler> attachmentMap, String action, String xpathHeaderExp, String xpathBodyExp) throws AxisFault, JaxenException {
        ServiceClient serviceClient = new ServiceClient();
        Options serviceOptions = new Options();
        serviceOptions.setProperty("enableSwA", (Object)"true");
        serviceOptions.setTo(endpoint);
        serviceOptions.setAction(action);
        serviceClient.setOptions(serviceOptions);
        MessageContext messageContext = new MessageContext();
        SOAPEnvelope soapEnvelope = this.createSOAPEnvelope(request, xpathHeaderExp, xpathBodyExp);
        messageContext.setEnvelope(soapEnvelope);
        for (String contentId : attachmentMap.keySet()) {
            messageContext.addAttachment(contentId, attachmentMap.get(contentId));
        }
        OperationClient mepClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        mepClient.addMessageContext(messageContext);
        return mepClient;
    }

    private SOAPEnvelope createSOAPEnvelope(OMElement request, String xpathHeaderExp, String xpathBodyExp) throws JaxenException {
        AXIOMXPath xpathHeader = new AXIOMXPath(request, xpathHeaderExp);
        AXIOMXPath xpathBody = new AXIOMXPath(request, xpathBodyExp);
        List headerOMElements = xpathHeader.selectNodes((Object)request);
        List bodyOMElements = xpathBody.selectNodes((Object)request);
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        for (OMElement omElement : headerOMElements) {
            soapEnvelope.getHeader().addChild((OMNode)omElement);
        }
        for (OMElement omElement : bodyOMElements) {
            soapEnvelope.getBody().addChild((OMNode)omElement);
        }
        return soapEnvelope;
    }

    private Properties getConnectorConfigProperties(String connectorName) {
        String connectorConfigFile = null;
        try {
            connectorConfigFile = FrameworkPathUtil.getSystemSettingsLocation() + "artifacts" + File.separator + "ESB" + File.separator + "connector" + File.separator + "config" + File.separator + connectorName + ".properties";
            File connectorPropertyFile = new File(connectorConfigFile);
            FileInputStream inputStream = null;
            if (connectorPropertyFile.exists()) {
                inputStream = new FileInputStream(connectorPropertyFile);
            }
            if (inputStream != null) {
                Properties prop = new Properties();
                prop.load(inputStream);
                ((InputStream)inputStream).close();
                return prop;
            }
        }
        catch (IOException ignored) {
            this.log.error((Object)"automation.properties file not found, please check your configuration");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContent(String path) throws IOException {
        String fileContent = null;
        try (BufferedInputStream bfist = new BufferedInputStream(new FileInputStream(path));){
            byte[] buf = new byte[bfist.available()];
            bfist.read(buf);
            fileContent = new String(buf);
        }
        return fileContent;
    }

    private boolean isValidJSON(String json) {
        try {
            new JSONObject(json);
            return true;
        }
        catch (JSONException ex) {
            return false;
        }
    }

    private boolean isValidXML(String xml) {
        return xml != null && xml.trim().length() > 0 && xml.trim().startsWith("<");
    }

    protected void cleanup() {
        this.axis2Client.destroy();
    }

    public String getValueByExpression(String xPathExpression, OMElement element) throws XMLStreamException, SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document xmlDocument = builder.parse(new ByteArrayInputStream(element.toString().getBytes()));
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.compile(xPathExpression).evaluate(xmlDocument);
    }

    protected Object xPathEvaluate(OMElement element, String xPathExp, Map<String, String> nameSpaceMap) throws JaxenException {
        AXIOMXPath xpath = new AXIOMXPath(element, xPathExp);
        xpath.addNamespaces(element);
        if (nameSpaceMap != null) {
            for (String prefix : nameSpaceMap.keySet()) {
                xpath.addNamespace(prefix, nameSpaceMap.get(prefix));
            }
        }
        return xpath.evaluate((Object)element);
    }

    protected RestResponse<JSONObject> sendBinaryContentForJsonResponse(String endPoint, String httpMethod, Map<String, String> headersMap, String fileName) throws IOException, JSONException {
        HttpURLConnection httpConnection = this.writeRequest(endPoint, httpMethod, (byte)1, headersMap, fileName, true);
        String responseString = this.readResponse(httpConnection);
        RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
        restResponse.setHttpStatusCode(httpConnection.getResponseCode());
        restResponse.setHeadersMap(httpConnection.getHeaderFields());
        if (responseString != null) {
            JSONObject jsonObject = null;
            if (this.isValidJSON(responseString)) {
                jsonObject = new JSONObject(responseString);
            } else {
                jsonObject = new JSONObject();
                jsonObject.put("output", (Object)responseString);
            }
            restResponse.setBody(jsonObject);
        }
        return restResponse;
    }

    protected RestResponse<OMElement> sendBinaryContentForXmlResponse(String endPoint, String httpMethod, Map<String, String> headersMap, String fileName) throws IOException, XMLStreamException {
        HttpURLConnection httpConnection = this.writeRequest(endPoint, httpMethod, (byte)2, headersMap, fileName, true);
        String responseString = this.readResponse(httpConnection);
        RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
        restResponse.setHttpStatusCode(httpConnection.getResponseCode());
        restResponse.setHeadersMap(httpConnection.getHeaderFields());
        if (responseString != null) {
            restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
        }
        return restResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection writeRequest(String endPoint, String httpMethod, byte responseType, Map<String, String> headersMap, String fileName, boolean isBinaryContent) throws IOException {
        OutputStream output = null;
        URL url = new URL(endPoint);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setInstanceFollowRedirects(false);
        httpConnection.setRequestMethod(httpMethod);
        FileInputStream fileInputStream = null;
        File file = new File(this.pathToResourcesDirectory, fileName);
        byte[] byteArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byteArray);
        fileInputStream.close();
        for (String key : headersMap.keySet()) {
            httpConnection.setRequestProperty(key, headersMap.get(key));
        }
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            httpConnection.setDoOutput(true);
            try {
                output = httpConnection.getOutputStream();
                output.write(byteArray);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException logOrIgnore) {
                        this.log.error((Object)"Error while closing the connection");
                    }
                }
            }
        }
        return httpConnection;
    }

    protected RestResponse<JSONObject> sendBinaryContentForJsonResponseHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String fileName) throws IOException, JSONException {
        HttpsURLConnection httpsConnection = this.writeRequestHTTPS(endPoint, httpMethod, (byte)1, headersMap, fileName, true);
        String responseString = this.readResponse(httpsConnection);
        RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
        restResponse.setHttpStatusCode(httpsConnection.getResponseCode());
        restResponse.setHeadersMap(httpsConnection.getHeaderFields());
        if (responseString != null) {
            JSONObject jsonObject = null;
            if (this.isValidJSON(responseString)) {
                jsonObject = new JSONObject(responseString);
            } else {
                jsonObject = new JSONObject();
                jsonObject.put("output", (Object)responseString);
            }
            restResponse.setBody(jsonObject);
        }
        return restResponse;
    }

    protected RestResponse<OMElement> sendBinaryContentForXmlResponseHTTPS(String endPoint, String httpMethod, Map<String, String> headersMap, String fileName) throws IOException, XMLStreamException {
        HttpsURLConnection httpsConnection = this.writeRequestHTTPS(endPoint, httpMethod, (byte)2, headersMap, fileName, true);
        String responseString = this.readResponse(httpsConnection);
        RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
        restResponse.setHttpStatusCode(httpsConnection.getResponseCode());
        restResponse.setHeadersMap(httpsConnection.getHeaderFields());
        if (responseString != null) {
            restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
        }
        return restResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsURLConnection writeRequestHTTPS(String endPoint, String httpMethod, byte responseType, Map<String, String> headersMap, String fileName, boolean isBinaryContent) throws IOException {
        OutputStream output = null;
        URL url = new URL(endPoint);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
        httpsConnection.setInstanceFollowRedirects(false);
        httpsConnection.setRequestMethod(httpMethod);
        FileInputStream fileInputStream = null;
        File file = new File(this.pathToResourcesDirectory, fileName);
        byte[] byteArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byteArray);
        fileInputStream.close();
        for (String key : headersMap.keySet()) {
            httpsConnection.setRequestProperty(key, headersMap.get(key));
        }
        if (httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT")) {
            httpsConnection.setDoOutput(true);
            try {
                output = httpsConnection.getOutputStream();
                output.write(byteArray);
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException logOrIgnore) {
                        this.log.error((Object)"Error while closing the connection");
                    }
                }
            }
        }
        return httpsConnection;
    }

    protected class MultipartFormdataProcessor {
        private final String boundary = "----=_wso2IntegTest" + System.currentTimeMillis();
        OutputStream httpStream;
        HttpURLConnection httpURLConnection;
        final String LINE_FEED = "\r\n";

        public MultipartFormdataProcessor(String endPointUrl) throws IOException {
            this.init(endPointUrl, Charset.defaultCharset().toString(), null);
        }

        public MultipartFormdataProcessor(String endPointUrl, Map<String, String> httpHeaders) throws IOException {
            this.init(endPointUrl, Charset.defaultCharset().toString(), httpHeaders);
        }

        public MultipartFormdataProcessor(String endPointUrl, String charSet, Map<String, String> httpHeaders) throws IOException {
            this.init(endPointUrl, charSet, httpHeaders);
        }

        public MultipartFormdataProcessor(String endPointUrl, String Charset2) throws IOException {
            this.init(endPointUrl, Charset2, null);
        }

        public MultipartFormdataProcessor(String endPointUrl, Map<String, String> httpHeaders, int multipartType) throws IOException {
            this.init(endPointUrl, httpHeaders, multipartType);
        }

        private void init(String endPointUrl, String Charset2, Map<String, String> httpHeaders) throws IOException {
            URL endpoint = new URL(endPointUrl);
            this.httpURLConnection = (HttpURLConnection)endpoint.openConnection();
            this.httpURLConnection.setDoInput(true);
            this.httpURLConnection.setDoOutput(true);
            this.httpURLConnection.setUseCaches(false);
            this.httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=\"" + this.boundary + "\"");
            this.httpURLConnection.setRequestProperty("User-Agent", "Wso2ESB intergration test");
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                Set<String> headerKeys = httpHeaders.keySet();
                String key2 = null;
                String value = null;
                for (String key2 : headerKeys) {
                    value = httpHeaders.get(key2);
                    this.httpURLConnection.setRequestProperty(key2, value);
                }
            }
            this.httpStream = this.httpURLConnection.getOutputStream();
        }

        private void init(String endPointUrl, Map<String, String> httpHeaders, int multipartType) throws IOException {
            URL endpoint = new URL(endPointUrl);
            this.httpURLConnection = (HttpURLConnection)endpoint.openConnection();
            this.httpURLConnection.setDoInput(true);
            this.httpURLConnection.setDoOutput(true);
            this.httpURLConnection.setUseCaches(false);
            switch (multipartType) {
                case 100001: {
                    this.httpURLConnection.setRequestProperty("Content-Type", "multipart/related; boundary=\"" + this.boundary + "\"");
                    break;
                }
                default: {
                    this.httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=\"" + this.boundary + "\"");
                }
            }
            this.httpURLConnection.setRequestProperty("User-Agent", "Wso2ESB intergration test");
            if (httpHeaders != null && !httpHeaders.isEmpty()) {
                httpHeaders.remove("Content-Type");
                Set<String> headerKeys = httpHeaders.keySet();
                String key2 = null;
                String value = null;
                for (String key2 : headerKeys) {
                    value = httpHeaders.get(key2);
                    this.httpURLConnection.setRequestProperty(key2, value);
                }
            }
            this.httpStream = this.httpURLConnection.getOutputStream();
        }

        public void addMetadataToMultipartRelatedRequest(String filename, String contentType, String charset, Map<String, String> parametersMap) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("\r\n");
            builder.append("--").append(this.boundary).append("\r\n");
            builder.append("Content-Type: " + contentType + "; charset=" + charset).append("\r\n").append("\r\n");
            builder.append(ConnectorIntegrationTestBase.this.loadRequestFromFile(filename, parametersMap));
            builder.append("\r\n");
            this.httpStream.write(builder.toString().getBytes());
            this.httpStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFileToMultipartRelatedRequest(String fileName, String contentId) throws IOException {
            File file = null;
            try (InputStream inputStream = null;){
                fileName = ConnectorIntegrationTestBase.this.pathToResourcesDirectory + fileName;
                file = new File(fileName);
                inputStream = new FileInputStream(file);
                String contentType = HttpURLConnection.guessContentTypeFromName(fileName);
                inputStream.close();
                this.addFileToMultipartRelatedRequest(fileName, file, contentType, contentId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFileToMultipartRelatedRequest(String fileName, File file, String contentType, String contentId) throws IOException {
            try (FileInputStream inputStream = null;){
                StringBuilder builder = new StringBuilder();
                builder.append("--").append(this.boundary).append("\r\n");
                builder.append("Content-Disposition: attachment; filename=\"" + fileName + "\"").append("\r\n");
                builder.append("Content-Type: " + contentType).append("\r\n");
                builder.append("content-id: <" + contentId + ">").append("\r\n").append("\r\n");
                this.httpStream.write(builder.toString().getBytes());
                this.httpStream.flush();
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[0xA00000];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    this.httpStream.write(buffer, 0, bytesRead);
                }
                this.httpStream.flush();
                inputStream.close();
            }
        }

        public void addFormDataToRequest(String fieldName, String fieldValue) throws IOException {
            this.addFormDataToRequest(fieldName, fieldValue, Charset.defaultCharset().toString());
        }

        public void addFormDataToRequest(String fieldName, String fieldValue, String charset) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("\r\n");
            builder.append("--").append(this.boundary).append("\r\n");
            builder.append("Content-Type: text/plain; charset=" + charset).append("\r\n");
            builder.append("Content-Disposition: form-data; name=\"" + fieldName + "\"").append("\r\n");
            builder.append("\r\n");
            builder.append(fieldValue).append("\r\n");
            this.httpStream.write(builder.toString().getBytes());
            this.httpStream.flush();
        }

        public void addFileToRequest(String fieldName, String fileName, String contentType) throws IOException {
            fileName = ConnectorIntegrationTestBase.this.pathToResourcesDirectory + fileName;
            File file = new File(fileName);
            this.addFileToRequest(fieldName, file, contentType);
        }

        public void addFileToRequest(String fieldName, String fileName, String contentType, String targetFileName) throws IOException {
            fileName = ConnectorIntegrationTestBase.this.pathToResourcesDirectory + fileName;
            File file = new File(fileName);
            if (contentType == null) {
                contentType = URLConnection.guessContentTypeFromName(file.getName());
            }
            this.addFileToRequest(fieldName, file, contentType, targetFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFileToRequest(String fieldName, String fileName) throws IOException {
            File file = null;
            try (InputStream inputStream = null;){
                fileName = ConnectorIntegrationTestBase.this.pathToResourcesDirectory + fileName;
                file = new File(fileName);
                inputStream = new FileInputStream(file);
                String contentType = HttpURLConnection.guessContentTypeFromStream(inputStream);
                inputStream.close();
                this.addFileToRequest(fieldName, file, contentType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFileToRequest(String fieldName, File file) throws IOException {
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(file);
                String contentType = HttpURLConnection.guessContentTypeFromStream(inputStream);
                ((InputStream)inputStream).close();
                this.addFileToRequest(fieldName, file, contentType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFileToRequest(String fieldName, File file, String contentType, String fileName) throws IOException {
            try (FileInputStream inputStream = null;){
                StringBuilder builder = new StringBuilder();
                builder.append("--").append(this.boundary).append("\r\n");
                builder.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append("\r\n");
                builder.append("Content-Type: " + contentType).append("\r\n");
                builder.append("Content-Transfer-Encoding: binary").append("\r\n").append("\r\n");
                this.httpStream.write(builder.toString().getBytes());
                this.httpStream.flush();
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[0xA00000];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    this.httpStream.write(buffer, 0, bytesRead);
                }
                this.httpStream.flush();
                inputStream.close();
                this.httpStream.write("\r\n".getBytes());
                this.httpStream.flush();
            }
        }

        public void addFileToRequest(String fieldName, File file, String contentType) throws IOException {
            this.addFileToRequest(fieldName, file, contentType, file.getName());
        }

        public String processForStringResponse() throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append("--").append(this.boundary).append("--").append("\r\n");
            this.httpStream.write(builder.toString().getBytes());
            this.httpStream.flush();
            return ConnectorIntegrationTestBase.this.readResponse(this.httpURLConnection);
        }

        public RestResponse<JSONObject> processForJsonResponse() throws IOException, JSONException {
            StringBuilder builder = new StringBuilder();
            builder.append("--").append(this.boundary).append("--").append("\r\n");
            this.httpStream.write(builder.toString().getBytes());
            this.httpStream.flush();
            String responseString = ConnectorIntegrationTestBase.this.readResponse(this.httpURLConnection);
            RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
            restResponse.setHttpStatusCode(this.httpURLConnection.getResponseCode());
            restResponse.setHeadersMap(this.httpURLConnection.getHeaderFields());
            if (responseString != null) {
                JSONObject jsonObject = null;
                if (ConnectorIntegrationTestBase.this.isValidJSON(responseString)) {
                    jsonObject = new JSONObject(responseString);
                } else {
                    jsonObject = new JSONObject();
                    jsonObject.put("output", (Object)responseString);
                }
                restResponse.setBody(jsonObject);
            }
            return restResponse;
        }

        public RestResponse<OMElement> processForXmlResponse() throws IOException, XMLStreamException {
            StringBuilder builder = new StringBuilder();
            builder.append("--").append(this.boundary).append("--").append("\r\n");
            this.httpStream.write(builder.toString().getBytes());
            this.httpStream.flush();
            String responseString = ConnectorIntegrationTestBase.this.readResponse(this.httpURLConnection);
            RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
            restResponse.setHttpStatusCode(this.httpURLConnection.getResponseCode());
            restResponse.setHeadersMap(this.httpURLConnection.getHeaderFields());
            if (responseString != null) {
                restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
            }
            return restResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFiletoRequestBody(File file) throws IOException {
            try (FileInputStream inputStream = null;){
                inputStream = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    this.httpStream.write(buffer, 0, bytesRead);
                }
                this.httpStream.flush();
                inputStream.close();
            }
        }

        public void addChunckedFiletoRequestBody(byte[] bytesPortion) throws IOException {
            this.httpStream.write(bytesPortion);
            this.httpStream.flush();
        }

        public RestResponse<JSONObject> processAttachmentForJsonResponse() throws IOException, JSONException {
            String responseString = ConnectorIntegrationTestBase.this.readResponse(this.httpURLConnection);
            RestResponse<JSONObject> restResponse = new RestResponse<JSONObject>();
            restResponse.setHttpStatusCode(this.httpURLConnection.getResponseCode());
            restResponse.setHeadersMap(this.httpURLConnection.getHeaderFields());
            if (responseString != null) {
                JSONObject jsonObject = null;
                if (ConnectorIntegrationTestBase.this.isValidJSON(responseString)) {
                    jsonObject = new JSONObject(responseString);
                } else {
                    jsonObject = new JSONObject();
                    jsonObject.put("output", (Object)responseString);
                }
                restResponse.setBody(jsonObject);
            }
            return restResponse;
        }

        public RestResponse<OMElement> processAttachmentForXmlResponse() throws IOException, XMLStreamException {
            String responseString = ConnectorIntegrationTestBase.this.readResponse(this.httpURLConnection);
            RestResponse<OMElement> restResponse = new RestResponse<OMElement>();
            restResponse.setHttpStatusCode(this.httpURLConnection.getResponseCode());
            restResponse.setHeadersMap(this.httpURLConnection.getHeaderFields());
            if (responseString != null) {
                restResponse.setBody(AXIOMUtil.stringToOM((String)responseString));
            }
            return restResponse;
        }
    }
}

