/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.wso2.aws.client.util.ApiGatewayClientManager;
import org.wso2.aws.client.util.GatewayUtil;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.OperationPolicy;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.deployer.exceptions.DeployerException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.Authorizer;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.Deployment;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.Op;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMode;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;

public class AWSAPIUtil {
    private static final Log log = LogFactory.getLog(AWSAPIUtil.class);

    public static String importRestAPI(API api, Environment environment) throws DeployerException {
        String openAPI = api.getSwaggerDefinition();
        ApiGatewayClient apiGatewayClient = null;
        String apiId = null;
        HashMap<String, String> authorizers = new HashMap<String, String>();
        HashMap<String, String> pathToArnMapping = new HashMap<String, String>();
        try {
            String region = (String)environment.getAdditionalProperties().get("region");
            String accessKey = (String)environment.getAdditionalProperties().get("access_key");
            String secretAccessKey = (String)environment.getAdditionalProperties().get("secret_key");
            apiGatewayClient = ApiGatewayClientManager.getClient(region, accessKey, secretAccessKey);
            ImportRestApiRequest importApiRequest = (ImportRestApiRequest)ImportRestApiRequest.builder().body(SdkBytes.fromUtf8String((String)openAPI)).failOnWarnings(Boolean.valueOf(false)).build();
            ImportRestApiResponse importApiResponse = apiGatewayClient.importRestApi(importApiRequest);
            apiId = importApiResponse.id();
            GetResourcesRequest getResourcesRequest = (GetResourcesRequest)GetResourcesRequest.builder().restApiId(apiId).build();
            GetResourcesResponse getResourcesResponse = apiGatewayClient.getResources(getResourcesRequest);
            String lambdaArnAPI = null;
            String invokeRoleArn = null;
            List apiPolicies = api.getApiPolicies();
            if (apiPolicies != null) {
                for (OperationPolicy policy : apiPolicies) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    lambdaArnAPI = policy.getParameters().get("lambdaARN").toString();
                    invokeRoleArn = policy.getParameters().get("invokeRoleArn").toString();
                    break;
                }
            }
            if (lambdaArnAPI != null) {
                pathToArnMapping.put("API", lambdaArnAPI);
                authorizers.put(lambdaArnAPI, GatewayUtil.getAuthorizer(apiId, lambdaArnAPI.substring(lambdaArnAPI.lastIndexOf(58) + 1), lambdaArnAPI, invokeRoleArn, region, apiGatewayClient).id());
            }
            for (URITemplate resource : api.getUriTemplates()) {
                String resourceLambdaARN = null;
                String invokeRoleArnResource = null;
                for (OperationPolicy policy : resource.getOperationPolicies()) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    resourceLambdaARN = policy.getParameters().get("lambdaARN").toString();
                    invokeRoleArnResource = policy.getParameters().get("invokeRoleArn").toString();
                    break;
                }
                if (resourceLambdaARN == null || authorizers.containsKey(resourceLambdaARN)) continue;
                pathToArnMapping.put(resource.getUriTemplate().toLowerCase() + "|" + resource.getHTTPVerb().toLowerCase(), resourceLambdaARN);
                authorizers.put(resourceLambdaARN, GatewayUtil.getAuthorizer(apiId, resourceLambdaARN.substring(resourceLambdaARN.lastIndexOf(58) + 1), resourceLambdaARN, invokeRoleArnResource, region, apiGatewayClient).id());
            }
            JSONParser parser = new JSONParser();
            String endpointConfig = api.getEndpointConfig();
            JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
            JSONObject prodEndpoints = (JSONObject)endpointConfigJson.get((Object)"production_endpoints");
            String productionEndpoint = (String)prodEndpoints.get((Object)"url");
            productionEndpoint = productionEndpoint.charAt(productionEndpoint.length() - 1) == '/' ? productionEndpoint.substring(0, productionEndpoint.length() - 1) : productionEndpoint;
            List resources = getResourcesResponse.items();
            for (Resource resource : resources) {
                Map resourceMethods = resource.resourceMethods();
                if (resourceMethods.isEmpty()) continue;
                GatewayUtil.configureOptionsCallForCORS(apiId, resource, apiGatewayClient);
                for (Map.Entry entry : resourceMethods.entrySet()) {
                    PutIntegrationRequest putIntegrationRequest = (PutIntegrationRequest)PutIntegrationRequest.builder().httpMethod(entry.getKey().toString()).integrationHttpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(apiId).type(IntegrationType.HTTP).uri(productionEndpoint + resource.path()).build();
                    PutIntegrationResponse putIntegrationResponse = apiGatewayClient.putIntegration(putIntegrationRequest);
                    String integrationURI = putIntegrationResponse.uri();
                    PutIntegrationResponseRequest putIntegrationResponseRequest = (PutIntegrationResponseRequest)PutIntegrationResponseRequest.builder().httpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(apiId).statusCode("200").responseTemplates(Map.of("application/json", "")).build();
                    apiGatewayClient.putIntegrationResponse(putIntegrationResponseRequest);
                    String key = resource.path().toLowerCase() + "|" + entry.getKey().toString().toLowerCase();
                    if (!authorizers.containsKey(pathToArnMapping.get(key)) && !authorizers.containsKey(pathToArnMapping.get(key = "API"))) {
                        throw new DeployerException("Authorizer not found for the resource: " + resource.path());
                    }
                    String authorizerId = (String)authorizers.get(pathToArnMapping.get(key));
                    UpdateMethodRequest updateMethodRequest = (UpdateMethodRequest)UpdateMethodRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizationType").value("CUSTOM").build(), (PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizerId").value(authorizerId).build()}).build();
                    apiGatewayClient.updateMethod(updateMethodRequest);
                    GatewayUtil.configureCORSHeadersAtMethodLevel(apiId, resource, entry.getKey().toString(), apiGatewayClient);
                }
            }
            String stageName = (String)environment.getAdditionalProperties().get("stage");
            CreateDeploymentRequest createDeploymentRequest = (CreateDeploymentRequest)CreateDeploymentRequest.builder().restApiId(apiId).stageName(stageName).build();
            apiGatewayClient.createDeployment(createDeploymentRequest);
        }
        catch (Exception e) {
            try {
                GatewayUtil.rollbackDeployment(apiGatewayClient, apiId);
            }
            catch (APIManagementException ex) {
                throw new DeployerException("Error occurred while rolling back deployment: " + ex.getMessage());
            }
            throw new DeployerException("Error occurred while importing API: " + e.getMessage());
        }
        GetRestApiRequest getRestApiRequest = (GetRestApiRequest)GetRestApiRequest.builder().restApiId(apiId).build();
        return apiGatewayClient.getRestApi(getRestApiRequest).toString();
    }

    public static String reimportRestAPI(String referenceArtifact, API api, Environment environment) throws DeployerException {
        String awsApiId = GatewayUtil.getAWSApiIdFromReferenceArtifact(referenceArtifact);
        ApiGatewayClient apiGatewayClient = null;
        ArrayList<String> currentARNs = new ArrayList<String>();
        HashMap<String, String> authorizers = new HashMap<String, String>();
        HashMap<String, String> pathToArnMapping = new HashMap<String, String>();
        try {
            Set uriTemplates;
            String openAPI = api.getSwaggerDefinition();
            String region = (String)environment.getAdditionalProperties().get("region");
            String accessKey = (String)environment.getAdditionalProperties().get("access_key");
            String secretAccessKey = (String)environment.getAdditionalProperties().get("secret_key");
            apiGatewayClient = ApiGatewayClientManager.getClient(region, accessKey, secretAccessKey);
            PutRestApiRequest reimportApiRequest = (PutRestApiRequest)PutRestApiRequest.builder().restApiId(awsApiId).body(SdkBytes.fromUtf8String((String)openAPI)).failOnWarnings(Boolean.valueOf(false)).mode(PutMode.OVERWRITE).build();
            PutRestApiResponse reimportApiResponse = apiGatewayClient.putRestApi(reimportApiRequest);
            awsApiId = reimportApiResponse.id();
            GetAuthorizersRequest getAuthorizersRequest = (GetAuthorizersRequest)GetAuthorizersRequest.builder().restApiId(awsApiId).build();
            List existingAuthorizers = apiGatewayClient.getAuthorizers(getAuthorizersRequest).items();
            for (Authorizer authorizer : existingAuthorizers) {
                String regex = "arn:aws:apigateway:[^:]+:lambda:path/2015-03-31/functions/([^/]+)/invocations";
                Pattern compiledPattern = Pattern.compile(regex);
                Matcher matcher = compiledPattern.matcher(authorizer.authorizerUri());
                String arn = null;
                if (matcher.find()) {
                    arn = matcher.group(1);
                }
                authorizers.put(arn, authorizer.id());
                currentARNs.add(arn);
            }
            String lambdaArnAPI = null;
            String invokeRoleArn = null;
            List apiPolicies = api.getApiPolicies();
            if (apiPolicies != null) {
                for (Object policy : apiPolicies) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    lambdaArnAPI = policy.getParameters().get("lambdaARN").toString();
                    invokeRoleArn = policy.getParameters().get("invokeRoleArn").toString();
                    break;
                }
            }
            if (lambdaArnAPI != null && !authorizers.containsKey(lambdaArnAPI)) {
                pathToArnMapping.put("API", lambdaArnAPI);
                authorizers.put(lambdaArnAPI, GatewayUtil.getAuthorizer(awsApiId, lambdaArnAPI.substring(lambdaArnAPI.lastIndexOf(58) + 1), lambdaArnAPI, invokeRoleArn, region, apiGatewayClient).id());
            }
            if ((uriTemplates = api.getUriTemplates()) != null) {
                for (URITemplate resource : uriTemplates) {
                    String resourceLambdaARN = null;
                    String invokeRoleArnResource = null;
                    List resourcePolicies = resource.getOperationPolicies();
                    if (resourcePolicies != null) {
                        for (OperationPolicy policy : resourcePolicies) {
                            if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                            resourceLambdaARN = policy.getParameters().get("lambdaARN").toString();
                            invokeRoleArnResource = policy.getParameters().get("invokeRoleArn").toString();
                            break;
                        }
                    }
                    if (resourceLambdaARN == null || authorizers.containsKey(resourceLambdaARN)) continue;
                    pathToArnMapping.put(resource.getUriTemplate().toLowerCase() + "|" + resource.getHTTPVerb().toLowerCase(), resourceLambdaARN);
                    authorizers.put(resourceLambdaARN, GatewayUtil.getAuthorizer(awsApiId, resourceLambdaARN.substring(resourceLambdaARN.lastIndexOf(58) + 1), resourceLambdaARN, invokeRoleArnResource, region, apiGatewayClient).id());
                }
            }
            for (String arn : currentARNs) {
                if (authorizers.containsKey(arn)) continue;
                GatewayUtil.deleteAuthorizer(awsApiId, (String)authorizers.get(arn), apiGatewayClient);
                authorizers.remove(arn);
            }
            GetResourcesRequest getResourcesRequest = (GetResourcesRequest)GetResourcesRequest.builder().restApiId(awsApiId).build();
            GetResourcesResponse getResourcesResponse = apiGatewayClient.getResources(getResourcesRequest);
            JSONParser parser = new JSONParser();
            String endpointConfig = api.getEndpointConfig();
            JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
            JSONObject prodEndpoints = (JSONObject)endpointConfigJson.get((Object)"production_endpoints");
            String productionEndpoint = (String)prodEndpoints.get((Object)"url");
            productionEndpoint = productionEndpoint.charAt(productionEndpoint.length() - 1) == '/' ? productionEndpoint.substring(0, productionEndpoint.length() - 1) : productionEndpoint;
            List resources = getResourcesResponse.items();
            for (Resource resource : resources) {
                Map resourceMethods = resource.resourceMethods();
                if (resourceMethods.isEmpty()) continue;
                GatewayUtil.configureOptionsCallForCORS(awsApiId, resource, apiGatewayClient);
                for (Map.Entry entry : resourceMethods.entrySet()) {
                    PutIntegrationRequest putIntegrationRequest = (PutIntegrationRequest)PutIntegrationRequest.builder().httpMethod(entry.getKey().toString()).integrationHttpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(awsApiId).type(IntegrationType.HTTP).uri(productionEndpoint + resource.path()).build();
                    apiGatewayClient.putIntegration(putIntegrationRequest);
                    PutIntegrationResponseRequest putIntegrationResponseRequest = (PutIntegrationResponseRequest)PutIntegrationResponseRequest.builder().httpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(awsApiId).statusCode("200").responseTemplates(Map.of("application/json", "")).build();
                    apiGatewayClient.putIntegrationResponse(putIntegrationResponseRequest);
                    Object key = resource.path().toLowerCase() + "|" + entry.getKey().toString().toLowerCase();
                    if (!authorizers.containsKey(pathToArnMapping.get(key)) && !authorizers.containsKey(pathToArnMapping.get(key = "API"))) {
                        throw new DeployerException("Authorizer not found for the resource: " + resource.path());
                    }
                    String authorizerId = (String)authorizers.get(pathToArnMapping.get(key));
                    UpdateMethodRequest updateMethodRequest = (UpdateMethodRequest)UpdateMethodRequest.builder().restApiId(awsApiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizationType").value("CUSTOM").build(), (PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizerId").value(authorizerId).build()}).build();
                    apiGatewayClient.updateMethod(updateMethodRequest);
                    GatewayUtil.configureCORSHeadersAtMethodLevel(awsApiId, resource, entry.getKey().toString(), apiGatewayClient);
                }
            }
            String stageName = (String)environment.getAdditionalProperties().get("stage");
            CreateDeploymentRequest createDeploymentRequest = (CreateDeploymentRequest)CreateDeploymentRequest.builder().restApiId(awsApiId).stageName(stageName).build();
            CreateDeploymentResponse createDeploymentResponse = apiGatewayClient.createDeployment(createDeploymentRequest);
            String deploymentId = createDeploymentResponse.id();
            GetDeploymentsRequest getDeploymentsRequest = (GetDeploymentsRequest)GetDeploymentsRequest.builder().restApiId(awsApiId).build();
            GetDeploymentsResponse getDeploymentsResponse = apiGatewayClient.getDeployments(getDeploymentsRequest);
            List deployments = getDeploymentsResponse.items();
            for (Deployment deployment : deployments) {
                if (deployment.id().equals(deploymentId)) continue;
                DeleteDeploymentRequest deleteDeploymentRequest = (DeleteDeploymentRequest)DeleteDeploymentRequest.builder().deploymentId(deployment.id()).restApiId(awsApiId).build();
                apiGatewayClient.deleteDeployment(deleteDeploymentRequest);
            }
            GetRestApiRequest getRestApiRequest = (GetRestApiRequest)GetRestApiRequest.builder().restApiId(awsApiId).build();
            return apiGatewayClient.getRestApi(getRestApiRequest).toString();
        }
        catch (Exception e) {
            throw new DeployerException("Error occurred while re-importing API: " + e.getMessage());
        }
    }

    public static boolean deleteDeployment(Environment environment, String referenceArtifact) throws DeployerException {
        String awsApiId = GatewayUtil.getAWSApiIdFromReferenceArtifact(referenceArtifact);
        String region = (String)environment.getAdditionalProperties().get("region");
        String accessKey = (String)environment.getAdditionalProperties().get("access_key");
        String secretAccessKey = (String)environment.getAdditionalProperties().get("secret_key");
        ApiGatewayClient apiGatewayClient = ApiGatewayClientManager.getClient(region, accessKey, secretAccessKey);
        String stageName = (String)environment.getAdditionalProperties().get("stage");
        DeleteStageRequest deleteStageRequest = (DeleteStageRequest)DeleteStageRequest.builder().restApiId(awsApiId).stageName(stageName).build();
        apiGatewayClient.deleteStage(deleteStageRequest);
        GetDeploymentsRequest getDeploymentsRequest = (GetDeploymentsRequest)GetDeploymentsRequest.builder().restApiId(awsApiId).build();
        GetDeploymentsResponse getDeploymentsResponse = apiGatewayClient.getDeployments(getDeploymentsRequest);
        List deployments = getDeploymentsResponse.items();
        for (Deployment deployment : deployments) {
            DeleteDeploymentRequest deleteDeploymentRequest = (DeleteDeploymentRequest)DeleteDeploymentRequest.builder().deploymentId(deployment.id()).restApiId(awsApiId).build();
            apiGatewayClient.deleteDeployment(deleteDeploymentRequest);
        }
        return true;
    }
}

