/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.ApiGatewayClientBuilder;

public class ApiGatewayClientManager {
    private static final Map<String, ApiGatewayClient> clients = new ConcurrentHashMap<String, ApiGatewayClient>();

    public static ApiGatewayClient getClient(String region, String accessKey, String secretKey) {
        String key = region + "|" + accessKey + "|" + secretKey;
        return clients.computeIfAbsent(key, k -> ApiGatewayClientManager.createClient(region, accessKey, secretKey));
    }

    private static ApiGatewayClient createClient(String region, String accessKey, String secretKey) {
        SdkHttpClient httpClient = ApacheHttpClient.builder().build();
        return (ApiGatewayClient)((ApiGatewayClientBuilder)((ApiGatewayClientBuilder)((ApiGatewayClientBuilder)ApiGatewayClient.builder().region(Region.of((String)region))).httpClient(httpClient)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)))).build();
    }
}

