/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.wso2.aws.client.util.AWSAPIUtil;
import org.wso2.aws.client.util.GatewayUtil;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.Environment;
import org.wso2.carbon.apimgt.api.model.GatewayAPIValidationResult;
import org.wso2.carbon.apimgt.api.model.GatewayDeployer;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.ApiGatewayClientBuilder;

public class AWSGatewayDeployer
implements GatewayDeployer {
    private ApiGatewayClient apiGatewayClient;
    private String region;
    private String stage;

    public void init(Environment environment) throws APIManagementException {
        try {
            this.region = (String)environment.getAdditionalProperties().get("region");
            this.stage = (String)environment.getAdditionalProperties().get("stage");
            String accessKey = (String)environment.getAdditionalProperties().get("access_key");
            String secretKey = (String)environment.getAdditionalProperties().get("secret_key");
            SdkHttpClient httpClient = ApacheHttpClient.builder().build();
            this.apiGatewayClient = (ApiGatewayClient)((ApiGatewayClientBuilder)((ApiGatewayClientBuilder)((ApiGatewayClientBuilder)ApiGatewayClient.builder().region(Region.of((String)this.region))).httpClient(httpClient)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)))).build();
        }
        catch (Exception e) {
            throw new APIManagementException("Error occurred while initializing AWS Gateway Deployer", (Throwable)e);
        }
    }

    public String getType() {
        return "AWS";
    }

    public String deploy(API api, String externalReference) throws APIManagementException {
        if (externalReference == null) {
            return AWSAPIUtil.importRestAPI(api, this.apiGatewayClient, this.region, this.stage);
        }
        return AWSAPIUtil.reimportRestAPI(externalReference, api, this.apiGatewayClient, this.region, this.stage);
    }

    public boolean undeploy(String externalReference) throws APIManagementException {
        return AWSAPIUtil.deleteDeployment(externalReference, this.apiGatewayClient, this.stage);
    }

    public GatewayAPIValidationResult validateApi(API api) throws APIManagementException {
        ArrayList<String> errorList = new ArrayList<String>();
        errorList.add(GatewayUtil.validateAWSAPIEndpoint(GatewayUtil.getEndpointURL(api)));
        errorList.add(GatewayUtil.validateResourceContexts(api));
        GatewayAPIValidationResult result = new GatewayAPIValidationResult();
        result.setValid(errorList.stream().allMatch(Objects::isNull));
        result.setErrors(errorList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return result;
    }

    public String getAPIExecutionURL(String externalReference) throws APIManagementException {
        StringBuilder resolvedUrl = new StringBuilder("{apiId}.execute-api.{region}.amazonaws.com");
        String awsAPIId = GatewayUtil.getAWSApiIdFromReferenceArtifact(externalReference);
        int start = resolvedUrl.indexOf("{apiId}");
        if (start != -1) {
            resolvedUrl.replace(start, start + "{apiId}".length(), awsAPIId);
        }
        if ((start = resolvedUrl.indexOf("{region}")) != -1) {
            resolvedUrl.replace(start, start + "{region}".length(), this.region);
        }
        return resolvedUrl.toString() + "/" + this.stage;
    }

    public void transformAPI(API api) throws APIManagementException {
        for (URITemplate resource : api.getUriTemplates()) {
            if (!resource.getUriTemplate().endsWith("/*")) continue;
            resource.setUriTemplate(resource.getUriTemplate().replace("/*", "/"));
        }
    }
}

