/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.wso2.aws.client.util.GatewayUtil;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.OperationPolicy;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteDeploymentRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteStageRequest;
import software.amazon.awssdk.services.apigateway.model.Deployment;
import software.amazon.awssdk.services.apigateway.model.GetAuthorizersRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.GetResourcesRequest;
import software.amazon.awssdk.services.apigateway.model.GetResourcesResponse;
import software.amazon.awssdk.services.apigateway.model.GetRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.ImportRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.Op;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMode;
import software.amazon.awssdk.services.apigateway.model.PutRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.PutRestApiResponse;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;

public class AWSAPIUtil {
    private static final Log log = LogFactory.getLog(AWSAPIUtil.class);

    public static String importRestAPI(API api, ApiGatewayClient apiGatewayClient, String region, String stage) throws APIManagementException {
        String openAPI = api.getSwaggerDefinition();
        String apiId = null;
        HashMap<Object, String> authorizers = new HashMap<Object, String>();
        HashMap<String, Object> pathToArnMapping = new HashMap<String, Object>();
        try {
            ImportRestApiRequest importApiRequest = (ImportRestApiRequest)ImportRestApiRequest.builder().body(SdkBytes.fromUtf8String((String)openAPI)).failOnWarnings(Boolean.valueOf(false)).build();
            ImportRestApiResponse importApiResponse = apiGatewayClient.importRestApi(importApiRequest);
            apiId = importApiResponse.id();
            GetResourcesRequest getResourcesRequest = (GetResourcesRequest)GetResourcesRequest.builder().restApiId(apiId).build();
            GetResourcesResponse getResourcesResponse = apiGatewayClient.getResources(getResourcesRequest);
            List apiPolicies = api.getApiPolicies();
            if (apiPolicies != null) {
                for (OperationPolicy policy : apiPolicies) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    String lambdaArnAPI = policy.getParameters().get("lambdaARN").toString();
                    String invokeRoleArn = policy.getParameters().get("invokeRoleArn").toString();
                    String key = (String)lambdaArnAPI + "|" + invokeRoleArn;
                    pathToArnMapping.put("API", key);
                    String name = lambdaArnAPI.substring(lambdaArnAPI.lastIndexOf(58) + 1) + "-" + invokeRoleArn.substring(invokeRoleArn.lastIndexOf(47) + 1);
                    authorizers.put(key, GatewayUtil.getAuthorizer(apiId, name, lambdaArnAPI, invokeRoleArn, region, apiGatewayClient).id());
                    break;
                }
            }
            block5: for (URITemplate resource : api.getUriTemplates()) {
                for (OperationPolicy policy : resource.getOperationPolicies()) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    String resourceLambdaARN = policy.getParameters().get("lambdaARN").toString();
                    String invokeRoleArnResource = policy.getParameters().get("invokeRoleArn").toString();
                    String key = resourceLambdaARN + "|" + invokeRoleArnResource;
                    pathToArnMapping.put(resource.getUriTemplate().toLowerCase() + "|" + resource.getHTTPVerb().toLowerCase(), key);
                    if (authorizers.containsKey(key)) continue block5;
                    String name = resourceLambdaARN.substring(resourceLambdaARN.lastIndexOf(58) + 1) + "-" + invokeRoleArnResource.substring(invokeRoleArnResource.lastIndexOf(47) + 1);
                    authorizers.put(key, GatewayUtil.getAuthorizer(apiId, name, resourceLambdaARN, invokeRoleArnResource, region, apiGatewayClient).id());
                    continue block5;
                }
            }
            JSONParser parser = new JSONParser();
            String endpointConfig = api.getEndpointConfig();
            JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
            JSONObject prodEndpoints = (JSONObject)endpointConfigJson.get((Object)"production_endpoints");
            String productionEndpoint = (String)prodEndpoints.get((Object)"url");
            productionEndpoint = productionEndpoint.charAt(productionEndpoint.length() - 1) == '/' ? productionEndpoint.substring(0, productionEndpoint.length() - 1) : productionEndpoint;
            List resources = getResourcesResponse.items();
            for (Resource resource : resources) {
                Map resourceMethods = resource.resourceMethods();
                if (resourceMethods.isEmpty()) continue;
                GatewayUtil.configureOptionsCallForCORS(apiId, resource, apiGatewayClient);
                for (Map.Entry entry : resourceMethods.entrySet()) {
                    String key;
                    GetMethodRequest getMethodRequest = (GetMethodRequest)GetMethodRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).build();
                    GetMethodResponse getMethodResponse = apiGatewayClient.getMethod(getMethodRequest);
                    Map requestParamsFromMethod = getMethodResponse.requestParameters();
                    HashMap<String, String> requestParametersToBeAddedInIntegration = new HashMap<String, String>();
                    for (Map.Entry paramEntry : requestParamsFromMethod.entrySet()) {
                        int startIndex;
                        key = (String)paramEntry.getKey();
                        String paramName = key.substring(key.lastIndexOf(".") + 1);
                        String prefix = "method.request.";
                        int endIndex = key.indexOf(46, startIndex = key.indexOf(prefix) + prefix.length());
                        String location = key.substring(startIndex, endIndex != -1 ? endIndex : key.length());
                        requestParametersToBeAddedInIntegration.put("integration.request." + location + "." + paramName, "method.request." + location + "." + paramName);
                    }
                    PutIntegrationRequest putIntegrationRequest = (PutIntegrationRequest)PutIntegrationRequest.builder().httpMethod(entry.getKey().toString()).integrationHttpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(apiId).type(IntegrationType.HTTP).requestParameters(requestParametersToBeAddedInIntegration).uri(productionEndpoint + resource.path()).build();
                    apiGatewayClient.putIntegration(putIntegrationRequest);
                    PutIntegrationResponseRequest putIntegrationResponseRequest = (PutIntegrationResponseRequest)PutIntegrationResponseRequest.builder().httpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(apiId).statusCode("200").responseTemplates(Map.of("application/json", "")).build();
                    apiGatewayClient.putIntegrationResponse(putIntegrationResponseRequest);
                    key = resource.path().toLowerCase() + "|" + entry.getKey().toString().toLowerCase();
                    boolean isAuthorizerFound = false;
                    if (authorizers.containsKey(pathToArnMapping.get(key))) {
                        isAuthorizerFound = true;
                    } else {
                        key = "API";
                        if (authorizers.containsKey(pathToArnMapping.get(key))) {
                            isAuthorizerFound = true;
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Authorizer not found for the resource: " + resource.path() + " at API or Resource levels"));
                        }
                    }
                    if (isAuthorizerFound) {
                        String authorizerId = (String)authorizers.get(pathToArnMapping.get(key));
                        UpdateMethodRequest updateMethodRequest = (UpdateMethodRequest)UpdateMethodRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizationType").value("CUSTOM").build(), (PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizerId").value(authorizerId).build()}).build();
                        apiGatewayClient.updateMethod(updateMethodRequest);
                    }
                    GatewayUtil.configureCORSHeadersAtMethodLevel(apiId, resource, entry.getKey().toString(), apiGatewayClient);
                }
            }
            CreateDeploymentRequest createDeploymentRequest = (CreateDeploymentRequest)CreateDeploymentRequest.builder().restApiId(apiId).stageName(stage).build();
            apiGatewayClient.createDeployment(createDeploymentRequest);
        }
        catch (Exception e) {
            try {
                GatewayUtil.rollbackDeployment(apiGatewayClient, apiId);
            }
            catch (APIManagementException ex) {
                throw new APIManagementException("Error occurred while rolling back deployment: " + ex.getMessage());
            }
            throw new APIManagementException("Error occurred while importing API: " + e.getMessage());
        }
        GetRestApiRequest getRestApiRequest = (GetRestApiRequest)GetRestApiRequest.builder().restApiId(apiId).build();
        return apiGatewayClient.getRestApi(getRestApiRequest).toString();
    }

    public static String reimportRestAPI(String referenceArtifact, API api, ApiGatewayClient apiGatewayClient, String region, String stage) throws APIManagementException {
        String awsApiId = GatewayUtil.getAWSApiIdFromReferenceArtifact(referenceArtifact);
        ArrayList<String> currentARNs = new ArrayList<String>();
        HashMap<Object, String> authorizers = new HashMap<Object, String>();
        HashMap<String, Object> pathToArnMapping = new HashMap<String, Object>();
        try {
            Set uriTemplates;
            String openAPI = api.getSwaggerDefinition();
            PutRestApiRequest reimportApiRequest = (PutRestApiRequest)PutRestApiRequest.builder().restApiId(awsApiId).body(SdkBytes.fromUtf8String((String)openAPI)).failOnWarnings(Boolean.valueOf(false)).mode(PutMode.OVERWRITE).build();
            PutRestApiResponse reimportApiResponse = apiGatewayClient.putRestApi(reimportApiRequest);
            awsApiId = reimportApiResponse.id();
            GetAuthorizersRequest getAuthorizersRequest = (GetAuthorizersRequest)GetAuthorizersRequest.builder().restApiId(awsApiId).build();
            List existingAuthorizers = apiGatewayClient.getAuthorizers(getAuthorizersRequest).items();
            for (Object authorizer : existingAuthorizers) {
                String regex = "arn:aws:apigateway:[^:]+:lambda:path/2015-03-31/functions/([^/]+)/invocations";
                Pattern compiledPattern = Pattern.compile(regex);
                Matcher matcher = compiledPattern.matcher(authorizer.authorizerUri());
                String credentials = authorizer.authorizerCredentials();
                String arn = null;
                if (matcher.find()) {
                    arn = matcher.group(1);
                }
                authorizers.put(arn + "|" + credentials, authorizer.id());
                currentARNs.add(arn + "|" + credentials);
            }
            List apiPolicies = api.getApiPolicies();
            if (apiPolicies != null) {
                for (OperationPolicy policy : apiPolicies) {
                    if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                    String lambdaArnAPI = policy.getParameters().get("lambdaARN").toString();
                    String invokeRoleArn = policy.getParameters().get("invokeRoleArn").toString();
                    String key = lambdaArnAPI + "|" + invokeRoleArn;
                    pathToArnMapping.put("API", key);
                    if (authorizers.containsKey(key)) break;
                    String name = lambdaArnAPI.substring(lambdaArnAPI.lastIndexOf(58) + 1) + "-" + invokeRoleArn.substring(invokeRoleArn.lastIndexOf(47) + 1);
                    authorizers.put(key, GatewayUtil.getAuthorizer(awsApiId, name, lambdaArnAPI, invokeRoleArn, region, apiGatewayClient).id());
                    break;
                }
            }
            if ((uriTemplates = api.getUriTemplates()) != null) {
                block4: for (URITemplate resource : uriTemplates) {
                    List resourcePolicies = resource.getOperationPolicies();
                    if (resourcePolicies == null) continue;
                    for (OperationPolicy policy : resourcePolicies) {
                        if (!policy.getPolicyName().equals("awsOAuth2")) continue;
                        String resourceLambdaARN = policy.getParameters().get("lambdaARN").toString();
                        String invokeRoleArnResource = policy.getParameters().get("invokeRoleArn").toString();
                        String key = resourceLambdaARN + "|" + invokeRoleArnResource;
                        pathToArnMapping.put(resource.getUriTemplate().toLowerCase() + "|" + resource.getHTTPVerb().toLowerCase(), key);
                        if (authorizers.containsKey(key)) continue block4;
                        String name = resourceLambdaARN.substring(resourceLambdaARN.lastIndexOf(58) + 1) + "-" + invokeRoleArnResource.substring(invokeRoleArnResource.lastIndexOf(47) + 1);
                        authorizers.put(key, GatewayUtil.getAuthorizer(awsApiId, name, resourceLambdaARN, invokeRoleArnResource, region, apiGatewayClient).id());
                        continue block4;
                    }
                }
            }
            for (String arn : currentARNs) {
                if (authorizers.containsKey(arn)) continue;
                GatewayUtil.deleteAuthorizer(awsApiId, (String)authorizers.get(arn), apiGatewayClient);
                authorizers.remove(arn);
            }
            GetResourcesRequest getResourcesRequest = (GetResourcesRequest)GetResourcesRequest.builder().restApiId(awsApiId).build();
            GetResourcesResponse getResourcesResponse = apiGatewayClient.getResources(getResourcesRequest);
            JSONParser parser = new JSONParser();
            String endpointConfig = api.getEndpointConfig();
            JSONObject endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
            JSONObject prodEndpoints = (JSONObject)endpointConfigJson.get((Object)"production_endpoints");
            String productionEndpoint = (String)prodEndpoints.get((Object)"url");
            productionEndpoint = productionEndpoint.charAt(productionEndpoint.length() - 1) == '/' ? productionEndpoint.substring(0, productionEndpoint.length() - 1) : productionEndpoint;
            List resources = getResourcesResponse.items();
            for (Resource resource : resources) {
                Map resourceMethods = resource.resourceMethods();
                if (resourceMethods.isEmpty()) continue;
                GatewayUtil.configureOptionsCallForCORS(awsApiId, resource, apiGatewayClient);
                for (Map.Entry entry : resourceMethods.entrySet()) {
                    String key;
                    GetMethodRequest getMethodRequest = (GetMethodRequest)GetMethodRequest.builder().restApiId(awsApiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).build();
                    GetMethodResponse getMethodResponse = apiGatewayClient.getMethod(getMethodRequest);
                    Map requestParamsFromMethod = getMethodResponse.requestParameters();
                    HashMap<String, String> requestParametersToBeAddedInIntegration = new HashMap<String, String>();
                    for (Map.Entry paramEntry : requestParamsFromMethod.entrySet()) {
                        int startIndex;
                        key = (String)paramEntry.getKey();
                        String paramName = key.substring(key.lastIndexOf(".") + 1);
                        String prefix = "method.request.";
                        int endIndex = key.indexOf(46, startIndex = key.indexOf(prefix) + prefix.length());
                        String location = key.substring(startIndex, endIndex != -1 ? endIndex : key.length());
                        requestParametersToBeAddedInIntegration.put("integration.request." + location + "." + paramName, "method.request." + location + "." + paramName);
                    }
                    PutIntegrationRequest putIntegrationRequest = (PutIntegrationRequest)PutIntegrationRequest.builder().httpMethod(entry.getKey().toString()).integrationHttpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(awsApiId).requestParameters(requestParametersToBeAddedInIntegration).type(IntegrationType.HTTP).uri(productionEndpoint + resource.path()).build();
                    apiGatewayClient.putIntegration(putIntegrationRequest);
                    PutIntegrationResponseRequest putIntegrationResponseRequest = (PutIntegrationResponseRequest)PutIntegrationResponseRequest.builder().httpMethod(entry.getKey().toString()).resourceId(resource.id()).restApiId(awsApiId).statusCode("200").responseTemplates(Map.of("application/json", "")).build();
                    apiGatewayClient.putIntegrationResponse(putIntegrationResponseRequest);
                    key = resource.path().toLowerCase() + "|" + entry.getKey().toString().toLowerCase();
                    boolean isAuthorizerFound = false;
                    if (authorizers.containsKey(pathToArnMapping.get(key))) {
                        isAuthorizerFound = true;
                    } else {
                        key = "API";
                        if (authorizers.containsKey(pathToArnMapping.get(key))) {
                            isAuthorizerFound = true;
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Authorizer not found for the resource: " + resource.path() + " at API or Resource levels"));
                        }
                    }
                    if (isAuthorizerFound) {
                        String authorizerId = (String)authorizers.get(pathToArnMapping.get(key));
                        UpdateMethodRequest updateMethodRequest = (UpdateMethodRequest)UpdateMethodRequest.builder().restApiId(awsApiId).resourceId(resource.id()).httpMethod(entry.getKey().toString()).patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizationType").value("CUSTOM").build(), (PatchOperation)PatchOperation.builder().op(Op.REPLACE).path("/authorizerId").value(authorizerId).build()}).build();
                        apiGatewayClient.updateMethod(updateMethodRequest);
                    }
                    GatewayUtil.configureCORSHeadersAtMethodLevel(awsApiId, resource, entry.getKey().toString(), apiGatewayClient);
                }
            }
            CreateDeploymentRequest createDeploymentRequest = (CreateDeploymentRequest)CreateDeploymentRequest.builder().restApiId(awsApiId).stageName(stage).build();
            CreateDeploymentResponse createDeploymentResponse = apiGatewayClient.createDeployment(createDeploymentRequest);
            String deploymentId = createDeploymentResponse.id();
            GetDeploymentsRequest getDeploymentsRequest = (GetDeploymentsRequest)GetDeploymentsRequest.builder().restApiId(awsApiId).build();
            GetDeploymentsResponse getDeploymentsResponse = apiGatewayClient.getDeployments(getDeploymentsRequest);
            List deployments = getDeploymentsResponse.items();
            for (Deployment deployment : deployments) {
                if (deployment.id().equals(deploymentId)) continue;
                DeleteDeploymentRequest deleteDeploymentRequest = (DeleteDeploymentRequest)DeleteDeploymentRequest.builder().deploymentId(deployment.id()).restApiId(awsApiId).build();
                apiGatewayClient.deleteDeployment(deleteDeploymentRequest);
            }
            GetRestApiRequest getRestApiRequest = (GetRestApiRequest)GetRestApiRequest.builder().restApiId(awsApiId).build();
            return apiGatewayClient.getRestApi(getRestApiRequest).toString();
        }
        catch (Exception e) {
            throw new APIManagementException("Error occurred while re-importing API: " + e.getMessage());
        }
    }

    public static boolean deleteDeployment(String referenceArtifact, ApiGatewayClient apiGatewayClient, String stage) throws APIManagementException {
        String awsApiId = GatewayUtil.getAWSApiIdFromReferenceArtifact(referenceArtifact);
        DeleteStageRequest deleteStageRequest = (DeleteStageRequest)DeleteStageRequest.builder().restApiId(awsApiId).stageName(stage).build();
        apiGatewayClient.deleteStage(deleteStageRequest);
        GetDeploymentsRequest getDeploymentsRequest = (GetDeploymentsRequest)GetDeploymentsRequest.builder().restApiId(awsApiId).build();
        GetDeploymentsResponse getDeploymentsResponse = apiGatewayClient.getDeployments(getDeploymentsRequest);
        List deployments = getDeploymentsResponse.items();
        for (Deployment deployment : deployments) {
            DeleteDeploymentRequest deleteDeploymentRequest = (DeleteDeploymentRequest)DeleteDeploymentRequest.builder().deploymentId(deployment.id()).restApiId(awsApiId).build();
            apiGatewayClient.deleteDeployment(deleteDeploymentRequest);
        }
        return true;
    }
}

