/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.aws.client.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.AuthorizerType;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.apigateway.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.apigateway.model.DeleteRestApiRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.services.apigateway.model.GetMethodResponse;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.Op;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationRequest;
import software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.services.apigateway.model.UpdateGatewayResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateIntegrationResponseRequest;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodResponseRequest;

public class GatewayUtil {
    private static final Pattern VALID_PATH_PATTERN = Pattern.compile("^[a-zA-Z0-9-._~%!$&'()*+,;=:@/]*$");

    public static String getAWSApiIdFromReferenceArtifact(String referenceArtifact) throws APIManagementException {
        Pattern pattern = Pattern.compile("Id=([a-zA-Z0-9]+)");
        Matcher matcher = pattern.matcher(referenceArtifact);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new APIManagementException("Error while extracting AWS API ID from reference artifact");
    }

    public static void rollbackDeployment(ApiGatewayClient apiGatewayClient, String awsApiId) throws APIManagementException {
        if (apiGatewayClient != null && awsApiId != null) {
            DeleteRestApiRequest deleteRestApiRequest = (DeleteRestApiRequest)DeleteRestApiRequest.builder().restApiId(awsApiId).build();
            apiGatewayClient.deleteRestApi(deleteRestApiRequest);
        }
    }

    public static String getEndpointURL(API api) throws APIManagementException {
        try {
            String endpointConfig = api.getEndpointConfig();
            if (StringUtils.isEmpty((CharSequence)endpointConfig)) {
                return endpointConfig;
            }
            JSONParser parser = new JSONParser();
            JSONObject endpointConfigJson = null;
            endpointConfigJson = (JSONObject)parser.parse(endpointConfig);
            JSONObject prodEndpoints = (JSONObject)endpointConfigJson.get((Object)"production_endpoints");
            String productionEndpoint = (String)prodEndpoints.get((Object)"url");
            return productionEndpoint.charAt(productionEndpoint.length() - 1) == '/' ? productionEndpoint.substring(0, productionEndpoint.length() - 1) : productionEndpoint;
        }
        catch (ParseException e) {
            throw new APIManagementException("Error while parsing endpoint configuration", (Throwable)e);
        }
    }

    public static String validateAWSAPIEndpoint(String urlString) {
        try {
            if (StringUtils.isEmpty((CharSequence)urlString)) {
                return null;
            }
            URL url = new URL(urlString);
            String protocol = url.getProtocol();
            if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
                return "Invalid Endpoint URL";
            }
            if (url.getHost() == null || url.getHost().isEmpty() || url.getHost().equalsIgnoreCase("localhost")) {
                return "Invalid Endpoint URL";
            }
            if (!VALID_PATH_PATTERN.matcher(url.getPath()).matches()) {
                return "Invalid Endpoint URL";
            }
            return null;
        }
        catch (MalformedURLException e) {
            return "Invalid Endpoint URL";
        }
    }

    public static String validateResourceContexts(API api) {
        Set uriTemplates = api.getUriTemplates();
        if (!uriTemplates.isEmpty()) {
            for (URITemplate uriTemplate : uriTemplates) {
                if (!uriTemplate.getUriTemplate().contains("*")) continue;
                return "Some resource contexts contain '*' wildcard";
            }
        }
        return null;
    }

    public static void configureOptionsCallForCORS(String apiId, Resource resource, ApiGatewayClient apiGatewayClient) {
        PutMethodRequest putMethodRequest = (PutMethodRequest)PutMethodRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").authorizationType("NONE").apiKeyRequired(Boolean.valueOf(false)).build();
        apiGatewayClient.putMethod(putMethodRequest);
        PutMethodResponseRequest putMethodResponseRequest = (PutMethodResponseRequest)PutMethodResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").statusCode("200").responseModels(new HashMap()).build();
        apiGatewayClient.putMethodResponse(putMethodResponseRequest);
        PutIntegrationRequest putMethodIntegrationRequest = (PutIntegrationRequest)PutIntegrationRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").integrationHttpMethod("OPTIONS").type(IntegrationType.MOCK).requestTemplates(Map.of("application/json", "{\"statusCode\": 200}")).build();
        apiGatewayClient.putIntegration(putMethodIntegrationRequest);
        PutIntegrationResponseRequest putIntegrationResponseRequest = (PutIntegrationResponseRequest)PutIntegrationResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").statusCode("200").responseTemplates(Map.of("application/json", "")).build();
        apiGatewayClient.putIntegrationResponse(putIntegrationResponseRequest);
        UpdateMethodResponseRequest updateMethodResponseRequest = (UpdateMethodResponseRequest)UpdateMethodResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").statusCode("200").patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Origin").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Methods").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Headers").build()}).build();
        apiGatewayClient.updateMethodResponse(updateMethodResponseRequest);
        UpdateIntegrationResponseRequest updateIntegrationResponseRequest = (UpdateIntegrationResponseRequest)UpdateIntegrationResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod("OPTIONS").statusCode("200").patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Origin").value("'*'").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Methods").value("'GET,OPTIONS'").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Headers").value("'Content-Type,X-Amz-Date,Authorization,X-Api-Key,X-Amz-Security-Token'").build()}).build();
        apiGatewayClient.updateIntegrationResponse(updateIntegrationResponseRequest);
        UpdateGatewayResponseRequest updateGatewayResponseRequest = (UpdateGatewayResponseRequest)UpdateGatewayResponseRequest.builder().restApiId(apiId).responseType("DEFAULT_4XX").patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/gatewayresponse.header.Access-Control-Allow-Origin").value("'*'").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/gatewayresponse.header.Access-Control-Allow-Methods").value("'GET,OPTIONS'").build(), (PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/gatewayresponse.header.Access-Control-Allow-Headers").value("'Content-Type,X-Amz-Date,Authorization,X-Api-Key,X-Amz-Security-Token'").build()}).build();
        apiGatewayClient.updateGatewayResponse(updateGatewayResponseRequest);
    }

    public static void configureCORSHeadersAtMethodLevel(String apiId, Resource resource, String httpMethod, ApiGatewayClient apiGatewayClient) {
        GetMethodRequest getMethodRequest = (GetMethodRequest)GetMethodRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(httpMethod).build();
        GetMethodResponse getMethodResponse = apiGatewayClient.getMethod(getMethodRequest);
        if (getMethodResponse.hasMethodResponses()) {
            Map responses = getMethodResponse.methodResponses();
            for (Map.Entry entry : responses.entrySet()) {
                UpdateMethodResponseRequest updateMethodResponseRequest = (UpdateMethodResponseRequest)UpdateMethodResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(httpMethod).statusCode((String)entry.getKey()).patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Origin").build()}).build();
                apiGatewayClient.updateMethodResponse(updateMethodResponseRequest);
            }
            UpdateIntegrationResponseRequest updateIntegrationResponseRequest = (UpdateIntegrationResponseRequest)UpdateIntegrationResponseRequest.builder().restApiId(apiId).resourceId(resource.id()).httpMethod(httpMethod).statusCode("200").patchOperations(new PatchOperation[]{(PatchOperation)PatchOperation.builder().op(Op.ADD).path("/responseParameters/method.response.header.Access-Control-Allow-Origin").value("'*'").build()}).build();
            apiGatewayClient.updateIntegrationResponse(updateIntegrationResponseRequest);
        }
    }

    public static CreateAuthorizerResponse getAuthorizer(String awsApiId, String name, String lambdaArn, String roleArn, String region, ApiGatewayClient apiGatewayClient) {
        CreateAuthorizerRequest createAuthorizerRequest = (CreateAuthorizerRequest)CreateAuthorizerRequest.builder().restApiId(awsApiId).name(name + "-authorizer").type(AuthorizerType.TOKEN).identitySource("method.request.header.Authorization").authorizerUri("arn:aws:apigateway:" + region + ":lambda:path/2015-03-31/functions/" + lambdaArn + "/invocations").authorizerCredentials(roleArn).authorizerResultTtlInSeconds(Integer.valueOf(0)).build();
        return apiGatewayClient.createAuthorizer(createAuthorizerRequest);
    }

    public static void deleteAuthorizer(String awsApiId, String authorizerId, ApiGatewayClient apiGatewayClient) {
        DeleteAuthorizerRequest deleteAuthorizerRequest = (DeleteAuthorizerRequest)DeleteAuthorizerRequest.builder().restApiId(awsApiId).authorizerId(authorizerId).build();
        apiGatewayClient.deleteAuthorizer(deleteAuthorizerRequest);
    }

    public static List<String> extractPathParams(String path) {
        int end;
        ArrayList<String> pathParams = new ArrayList<String>();
        int start = path.indexOf("{");
        while (start < path.length() && (end = path.indexOf("}", start)) != -1) {
            pathParams.add(path.substring(start + 1, end));
            start = path.indexOf("{", end);
            if (start != -1) continue;
            break;
        }
        return pathParams;
    }
}

