/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.csv;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.module.core.SimpleMediator;
import org.wso2.carbon.module.core.SimpleMessageContext;
import org.wso2.carbon.module.core.models.CsvPayloadInfo;
import org.wso2.carbon.module.csv.constant.HeaderAvailability;
import org.wso2.carbon.module.csv.util.CsvTransformer;
import org.wso2.carbon.module.csv.util.PropertyReader;

abstract class AbstractCsvToAnyTransformer
extends SimpleMediator {
    AbstractCsvToAnyTransformer() {
    }

    public void mediate(SimpleMessageContext mc) {
        HeaderAvailability headerAvailability = PropertyReader.getEnumParam(mc, "headerPresent", HeaderAvailability.class, HeaderAvailability.ABSENT);
        Optional<Character> valueSeparatorOptional = PropertyReader.getCharParam(mc, "valueSeparator");
        char valueSeparator = valueSeparatorOptional.orElse(Character.valueOf(',')).charValue();
        boolean skipHeader = PropertyReader.getBooleanParam(mc, "skipHeader");
        Optional<Integer> dataRowsToSkip = PropertyReader.getIntegerParam(mc, "dataRowsToSkip");
        Optional<String> columnsToSkipQuery = PropertyReader.getStringParam(mc, "columnsToSkip");
        CsvPayloadInfo csvPayloadInfo = mc.getCsvPayloadInfo(valueSeparator);
        int linesToSkip = CsvTransformer.getLinesToSkip(headerAvailability, dataRowsToSkip.orElse(0));
        String[] header = CsvTransformer.getHeader(csvPayloadInfo, headerAvailability);
        Stream<String[]> csvArrayStream = mc.getCsvArrayStream(linesToSkip, valueSeparator);
        if (columnsToSkipQuery.isPresent()) {
            csvArrayStream = CsvTransformer.skipColumns(csvPayloadInfo.getNumberOfColumns(), columnsToSkipQuery.get(), csvArrayStream, header);
            if (headerAvailability == HeaderAvailability.PRESENT) {
                header = CsvTransformer.skipColumnsSingleRow(csvPayloadInfo.getNumberOfColumns(), columnsToSkipQuery.get(), csvPayloadInfo.getFirstRow(), header);
            }
        }
        if (headerAvailability == HeaderAvailability.PRESENT && !skipHeader) {
            csvArrayStream = Stream.concat(Stream.of(header), csvArrayStream);
        }
        this.mediate(mc, csvArrayStream, header);
    }

    String[] generateObjectKeys(String objectKeysQuery, String[] csvHeader) {
        String[] objectKeys = StringUtils.isNotBlank((String)objectKeysQuery) ? objectKeysQuery.split(",") : (String[])csvHeader.clone();
        return objectKeys;
    }

    String getObjectKey(String[] header, int index) {
        String headerValue = index < header.length ? header[index] : String.format("%s-%d", "key", index + 1);
        return headerValue;
    }

    abstract void mediate(SimpleMessageContext var1, Stream<String[]> var2, String[] var3);
}

